/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.money.AbstractContextBuilder;

public abstract class AbstractContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String KEY_PROVIDER = "provider";
    public static final String KEY_TIMESTAMP = "timestamp";
    final Map<String, Object> data = new HashMap<String, Object>();

    protected AbstractContext(AbstractContextBuilder<?, ?> builder) {
        this.data.putAll(builder.data);
    }

    public Set<String> getKeys(Class<?> type) {
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, Object> val : this.data.entrySet()) {
            if (!type.isAssignableFrom(val.getValue().getClass())) continue;
            keys.add(val.getKey());
        }
        return keys;
    }

    public Class<?> getType(String key) {
        Object val = this.data.get(key);
        return val == null ? null : val.getClass();
    }

    public <T> T get(String key, Class<T> type) {
        Object value = this.data.get(key);
        if (value != null && type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        return null;
    }

    public <T> T get(Class<T> type) {
        return this.get(type.getName(), type);
    }

    public Long getLong(String key) {
        return this.get(key, Long.class);
    }

    public Float getFloat(String key) {
        return this.get(key, Float.class);
    }

    public Integer getInt(String key) {
        return this.get(key, Integer.class);
    }

    public Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    public Double getDouble(String key) {
        return this.get(key, Double.class);
    }

    public String getText(String key) {
        return this.get(key, String.class);
    }

    public String getProvider() {
        return this.getText(KEY_PROVIDER);
    }

    public Long getTimestampMillis() {
        TemporalAccessor acc;
        Long value = this.get(KEY_TIMESTAMP, Long.class);
        if (Objects.isNull(value) && Objects.nonNull(acc = this.getTimestamp())) {
            return acc.getLong(ChronoField.INSTANT_SECONDS) * 1000L + acc.getLong(ChronoField.MILLI_OF_SECOND);
        }
        return value;
    }

    public TemporalAccessor getTimestamp() {
        Long value;
        TemporalAccessor acc = this.get(KEY_TIMESTAMP, TemporalAccessor.class);
        if (Objects.isNull(acc) && Objects.nonNull(value = this.get(KEY_TIMESTAMP, Long.class))) {
            acc = Instant.ofEpochMilli(value);
        }
        return acc;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public <T> Map<String, T> getValues(Class<T> type) {
        HashMap<String, T> result = new HashMap<String, T>();
        for (Map.Entry<String, Object> en : this.data.entrySet()) {
            if (!type.isAssignableFrom(en.getValue().getClass())) continue;
            result.put(en.getKey(), type.cast(en.getValue()));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractContext) {
            AbstractContext other = (AbstractContext)obj;
            return Objects.equals(this.data, other.data);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (\n" + this.data + ')';
    }
}

