/*
 * Decompiled with CFR 0.152.
 */
package javax.money.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import javax.money.spi.DefaultServiceProvider;
import javax.money.spi.ServiceProvider;

public final class Bootstrap {
    private static volatile ServiceProvider serviceProviderDelegate;
    private static final Object LOCK;

    private Bootstrap() {
    }

    private static ServiceProvider loadDefaultServiceProvider() {
        try {
            Iterator<ServiceProvider> iterator = ServiceLoader.load(ServiceProvider.class).iterator();
            if (iterator.hasNext()) {
                ServiceProvider sp = iterator.next();
                return sp;
            }
        }
        catch (Exception e) {
            Logger.getLogger(Bootstrap.class.getName()).info("No ServiceProvider loaded, using default.");
        }
        return new DefaultServiceProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceProvider init(ServiceProvider serviceProvider) {
        Objects.requireNonNull(serviceProvider);
        Object object = LOCK;
        synchronized (object) {
            if (serviceProviderDelegate == null) {
                serviceProviderDelegate = serviceProvider;
                Logger.getLogger(Bootstrap.class.getName()).info("Money Bootstrap: new ServiceProvider set: " + serviceProvider.getClass().getName());
                return null;
            }
            ServiceProvider prevProvider = serviceProviderDelegate;
            serviceProviderDelegate = serviceProvider;
            Logger.getLogger(Bootstrap.class.getName()).warning("Money Bootstrap: ServiceProvider replaced: " + serviceProvider.getClass().getName());
            return prevProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServiceProvider getServiceProvider() {
        if (serviceProviderDelegate == null) {
            Object object = LOCK;
            synchronized (object) {
                if (serviceProviderDelegate == null) {
                    serviceProviderDelegate = Bootstrap.loadDefaultServiceProvider();
                }
            }
        }
        return serviceProviderDelegate;
    }

    public static <T> Collection<T> getServices(Class<T> serviceType) {
        return Bootstrap.getServiceProvider().getServices(serviceType);
    }

    public static <T> T getService(Class<T> serviceType) {
        List<T> services = Bootstrap.getServiceProvider().getServices(serviceType);
        if (services.isEmpty()) {
            return null;
        }
        services = new ArrayList<T>(services);
        Collections.sort(services, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
            }
        });
        return services.get(0);
    }

    static {
        LOCK = new Object();
    }
}

