/*
 * Decompiled with CFR 0.152.
 */
package javax.money.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryException;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ConversionQueryBuilder;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRateProvider;
import javax.money.convert.ExchangeRateProviderSupplier;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryConversionsSingletonSpi;

public final class MonetaryConversions {
    private static final MonetaryConversionsSingletonSpi MONETARY_CONVERSION_SPI = MonetaryConversions.loadSpi();

    private static MonetaryConversionsSingletonSpi loadSpi() {
        MonetaryConversionsSingletonSpi spi = Bootstrap.getService(MonetaryConversionsSingletonSpi.class);
        if (spi == null) {
            throw new MonetaryException("MonetaryConversionsSingletonSpi no available: no conversion will be possible.");
        }
        return spi;
    }

    private MonetaryConversions() {
    }

    public static CurrencyConversion getConversion(CurrencyUnit termCurrency, String ... providers) {
        Objects.requireNonNull(providers);
        Objects.requireNonNull(termCurrency);
        if (providers.length == 0) {
            return MONETARY_CONVERSION_SPI.getConversion(((ConversionQueryBuilder)ConversionQueryBuilder.of().setTermCurrency(termCurrency).setProviderNames(MonetaryConversions.getDefaultConversionProviderChain())).build());
        }
        return MONETARY_CONVERSION_SPI.getConversion(((ConversionQueryBuilder)ConversionQueryBuilder.of().setTermCurrency(termCurrency).setProviderNames(providers)).build());
    }

    public static CurrencyConversion getConversion(String termCurrencyCode, String ... providers) {
        Objects.requireNonNull(termCurrencyCode, "Term currency code may not be null");
        return MonetaryConversions.getConversion(Monetary.getCurrency(termCurrencyCode, new String[0]), providers);
    }

    public static CurrencyConversion getConversion(ConversionQuery conversionQuery) {
        if (MONETARY_CONVERSION_SPI == null) {
            throw new MonetaryException("No MonetaryConveresionsSingletonSpi loaded, query functionality is not available.");
        }
        return MONETARY_CONVERSION_SPI.getConversion(conversionQuery);
    }

    public static boolean isConversionAvailable(ConversionQuery conversionQuery) {
        if (MONETARY_CONVERSION_SPI == null) {
            throw new MonetaryException("No MonetaryConveresionsSingletonSpi loaded, query functionality is not available.");
        }
        return MONETARY_CONVERSION_SPI.isConversionAvailable(conversionQuery);
    }

    public static boolean isConversionAvailable(String currencyCode, String ... providers) {
        if (MONETARY_CONVERSION_SPI == null) {
            throw new MonetaryException("No MonetaryConveresionsSingletonSpi loaded, query functionality is not available.");
        }
        return MONETARY_CONVERSION_SPI.isConversionAvailable(Monetary.getCurrency(currencyCode, new String[0]), providers);
    }

    public static boolean isConversionAvailable(CurrencyUnit termCurrency, String ... providers) {
        if (MONETARY_CONVERSION_SPI == null) {
            throw new MonetaryException("No MonetaryConveresionsSingletonSpi loaded, query functionality is not available.");
        }
        return MONETARY_CONVERSION_SPI.isConversionAvailable(termCurrency, providers);
    }

    public static ExchangeRateProvider getExchangeRateProvider(String ... providers) {
        if (providers.length == 0) {
            List<String> defaultProviderChain = MonetaryConversions.getDefaultConversionProviderChain();
            return MONETARY_CONVERSION_SPI.getExchangeRateProvider(((ConversionQueryBuilder)ConversionQueryBuilder.of().setProviderNames(defaultProviderChain.toArray(new String[defaultProviderChain.size()]))).build());
        }
        ExchangeRateProvider provider = MONETARY_CONVERSION_SPI.getExchangeRateProvider(((ConversionQueryBuilder)ConversionQueryBuilder.of().setProviderNames(providers)).build());
        if (provider == null) {
            throw new MonetaryException("No such rate provider: " + Arrays.toString(providers));
        }
        return provider;
    }

    public static ExchangeRateProvider getExchangeRateProvider(ExchangeRateProviderSupplier provider, ExchangeRateProviderSupplier ... providers) {
        ArrayList<ExchangeRateProviderSupplier> suppliers = new ArrayList<ExchangeRateProviderSupplier>();
        suppliers.add(Objects.requireNonNull(provider));
        Collections.addAll(suppliers, providers);
        String[] array = new String[suppliers.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = ((ExchangeRateProviderSupplier)suppliers.get(i)).get();
        }
        return MonetaryConversions.getExchangeRateProvider(array);
    }

    public static ExchangeRateProvider getExchangeRateProvider(ConversionQuery conversionQuery) {
        if (MONETARY_CONVERSION_SPI == null) {
            throw new MonetaryException("No MonetaryConveresionsSingletonSpi loaded, query functionality is not available.");
        }
        return MONETARY_CONVERSION_SPI.getExchangeRateProvider(conversionQuery);
    }

    public static boolean isExchangeRateProviderAvailable(ConversionQuery conversionQuery) {
        if (MONETARY_CONVERSION_SPI == null) {
            throw new MonetaryException("No MonetaryConveresionsSingletonSpi loaded, query functionality is not available.");
        }
        return MONETARY_CONVERSION_SPI.isExchangeRateProviderAvailable(conversionQuery);
    }

    public static Collection<String> getConversionProviderNames() {
        if (MONETARY_CONVERSION_SPI == null) {
            throw new MonetaryException("No MonetaryConveresionsSingletonSpi loaded, query functionality is not available.");
        }
        return MONETARY_CONVERSION_SPI.getProviderNames();
    }

    public static List<String> getDefaultConversionProviderChain() {
        if (MONETARY_CONVERSION_SPI == null) {
            throw new MonetaryException("No MonetaryConveresionsSingletonSpi loaded, query functionality is not available.");
        }
        List<String> defaultChain = MONETARY_CONVERSION_SPI.getDefaultProviderChain();
        Objects.requireNonNull(defaultChain, "No default provider chain provided by SPI: " + MONETARY_CONVERSION_SPI.getClass().getName());
        return defaultChain;
    }
}

