/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.util.Locale;
import javax.money.MonetaryException;

public class UnknownCurrencyException
extends MonetaryException {
    private static final long serialVersionUID = 1421993009305080653L;
    private final String currencyCode;
    private final Locale locale;

    public UnknownCurrencyException(String code) {
        super("Unknown currency code: " + code);
        this.currencyCode = code;
        this.locale = null;
    }

    public UnknownCurrencyException(Locale locale) {
        super("No currency for found for Locale: " + locale);
        this.locale = locale;
        this.currencyCode = null;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String toString() {
        if (this.locale == null) {
            return "UnknownCurrencyException [currencyCode=" + this.currencyCode + "]";
        }
        return "UnknownCurrencyException [locale=" + this.locale + "]";
    }
}

