/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyQuery;
import javax.money.CurrencyUnit;
import javax.money.DefaultMonetaryCurrenciesSingletonSpi;
import javax.money.DefaultMonetaryRoundingsSingletonSpi;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryAmountFactoryQuery;
import javax.money.MonetaryException;
import javax.money.MonetaryRounding;
import javax.money.RoundingQuery;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountsSingletonQuerySpi;
import javax.money.spi.MonetaryAmountsSingletonSpi;
import javax.money.spi.MonetaryCurrenciesSingletonSpi;
import javax.money.spi.MonetaryRoundingsSingletonSpi;

public final class Monetary {
    private static final MonetaryCurrenciesSingletonSpi monetaryCurrenciesSpi = Monetary.loadMonetaryCurrenciesSingletonSpi();
    private static final MonetaryAmountsSingletonSpi monetaryAmountsSingletonSpi = Monetary.loadMonetaryAmountsSingletonSpi();
    private static final MonetaryAmountsSingletonQuerySpi monetaryAmountsSingletonQuerySpi = Monetary.loadMonetaryAmountsSingletonQuerySpi();
    private static final MonetaryRoundingsSingletonSpi monetaryRoundingsSpi = Monetary.loadMonetaryRoundingsSingletonSpi();

    private Monetary() {
    }

    private static MonetaryCurrenciesSingletonSpi loadMonetaryCurrenciesSingletonSpi() {
        try {
            MonetaryCurrenciesSingletonSpi spi = Bootstrap.getService(MonetaryCurrenciesSingletonSpi.class);
            if (spi == null) {
                spi = new DefaultMonetaryCurrenciesSingletonSpi();
            }
            return spi;
        }
        catch (Exception e) {
            Logger.getLogger(Monetary.class.getName()).log(Level.INFO, "Failed to load MonetaryCurrenciesSingletonSpi, using default.", e);
            return new DefaultMonetaryCurrenciesSingletonSpi();
        }
    }

    private static MonetaryAmountsSingletonSpi loadMonetaryAmountsSingletonSpi() {
        try {
            return Bootstrap.getService(MonetaryAmountsSingletonSpi.class);
        }
        catch (Exception e) {
            Logger.getLogger(Monetary.class.getName()).log(Level.SEVERE, "Failed to load MonetaryAmountsSingletonSpi.", e);
            return null;
        }
    }

    private static MonetaryAmountsSingletonQuerySpi loadMonetaryAmountsSingletonQuerySpi() {
        try {
            return Bootstrap.getService(MonetaryAmountsSingletonQuerySpi.class);
        }
        catch (Exception e) {
            Logger.getLogger(Monetary.class.getName()).log(Level.SEVERE, "Failed to load MonetaryAmountsSingletonQuerySpi, query functionality will not be available.", e);
            return null;
        }
    }

    private static MonetaryRoundingsSingletonSpi loadMonetaryRoundingsSingletonSpi() {
        try {
            MonetaryRoundingsSingletonSpi spi = Bootstrap.getService(MonetaryRoundingsSingletonSpi.class);
            if (spi == null) {
                spi = new DefaultMonetaryRoundingsSingletonSpi();
            }
            return spi;
        }
        catch (Exception e) {
            Logger.getLogger(Monetary.class.getName()).log(Level.SEVERE, "Failed to load MonetaryCurrenciesSingletonSpi, using default.", e);
            return new DefaultMonetaryRoundingsSingletonSpi();
        }
    }

    public static CurrencyUnit getCurrency(String currencyCode, String ... providers) {
        if (monetaryCurrenciesSpi == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return monetaryCurrenciesSpi.getCurrency(currencyCode, providers);
    }

    public static CurrencyUnit getCurrency(Locale locale, String ... providers) {
        if (monetaryCurrenciesSpi == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return monetaryCurrenciesSpi.getCurrency(locale, providers);
    }

    public static Set<CurrencyUnit> getCurrencies(Locale locale, String ... providers) {
        if (monetaryCurrenciesSpi == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return monetaryCurrenciesSpi.getCurrencies(locale, providers);
    }

    public static boolean isCurrencyAvailable(String code, String ... providers) {
        if (monetaryCurrenciesSpi == null) {
            throw new IllegalStateException("No Monetary Spi loaded.");
        }
        return monetaryCurrenciesSpi.isCurrencyAvailable(code, providers);
    }

    public static boolean isCurrencyAvailable(Locale locale, String ... providers) {
        if (monetaryCurrenciesSpi == null) {
            throw new IllegalStateException("No Monetary Spi loaded.");
        }
        return monetaryCurrenciesSpi.isCurrencyAvailable(locale, providers);
    }

    public static Collection<CurrencyUnit> getCurrencies(String ... providers) {
        if (monetaryCurrenciesSpi == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return monetaryCurrenciesSpi.getCurrencies(providers);
    }

    public static CurrencyUnit getCurrency(CurrencyQuery query) {
        if (monetaryCurrenciesSpi == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return monetaryCurrenciesSpi.getCurrency(query);
    }

    public static Collection<CurrencyUnit> getCurrencies(CurrencyQuery query) {
        if (monetaryCurrenciesSpi == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return monetaryCurrenciesSpi.getCurrencies(query);
    }

    public static Set<String> getCurrencyProviderNames() {
        if (monetaryCurrenciesSpi == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return monetaryCurrenciesSpi.getProviderNames();
    }

    public static List<String> getDefaultCurrencyProviderChain() {
        if (monetaryCurrenciesSpi == null) {
            throw new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.");
        }
        return monetaryCurrenciesSpi.getDefaultProviderChain();
    }

    public static <T extends MonetaryAmount> MonetaryAmountFactory<T> getAmountFactory(Class<T> amountType) {
        if (monetaryAmountsSingletonQuerySpi == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonQuerySpi loaded, query functionality is not available.");
        }
        MonetaryAmountFactory<T> factory = monetaryAmountsSingletonSpi.getAmountFactory(amountType);
        if (factory == null) {
            throw new MonetaryException("No AmountFactory available for type: " + amountType.getName());
        }
        return factory;
    }

    public static MonetaryAmountFactory<?> getDefaultAmountFactory() {
        if (monetaryAmountsSingletonSpi == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonSpi loaded, query functionality is not available.");
        }
        return monetaryAmountsSingletonSpi.getDefaultAmountFactory();
    }

    public static Collection<MonetaryAmountFactory<?>> getAmountFactories() {
        if (monetaryAmountsSingletonSpi == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonSpi loaded, query functionality is not available.");
        }
        return monetaryAmountsSingletonSpi.getAmountFactories();
    }

    public static Collection<Class<? extends MonetaryAmount>> getAmountTypes() {
        if (monetaryAmountsSingletonSpi == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonSpi loaded, query functionality is not available.");
        }
        return monetaryAmountsSingletonSpi.getAmountTypes();
    }

    public static Class<? extends MonetaryAmount> getDefaultAmountType() {
        if (monetaryAmountsSingletonSpi == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonSpi loaded, query functionality is not available.");
        }
        return monetaryAmountsSingletonSpi.getDefaultAmountType();
    }

    public static MonetaryAmountFactory getAmountFactory(MonetaryAmountFactoryQuery query) {
        if (monetaryAmountsSingletonQuerySpi == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonQuerySpi loaded, query functionality is not available.");
        }
        return monetaryAmountsSingletonQuerySpi.getAmountFactory(query);
    }

    public static Collection<MonetaryAmountFactory<?>> getAmountFactories(MonetaryAmountFactoryQuery query) {
        if (monetaryAmountsSingletonQuerySpi == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonQuerySpi loaded, query functionality is not available.");
        }
        return monetaryAmountsSingletonQuerySpi.getAmountFactories(query);
    }

    public static boolean isAvailable(MonetaryAmountFactoryQuery query) {
        if (monetaryAmountsSingletonQuerySpi == null) {
            throw new MonetaryException("No MonetaryAmountsSingletonQuerySpi loaded, query functionality is not available.");
        }
        return monetaryAmountsSingletonQuerySpi.isAvailable(query);
    }

    public static MonetaryRounding getDefaultRounding() {
        if (monetaryRoundingsSpi == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return monetaryRoundingsSpi.getDefaultRounding();
    }

    public static MonetaryRounding getRounding(CurrencyUnit currencyUnit, String ... providers) {
        if (monetaryRoundingsSpi == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return monetaryRoundingsSpi.getRounding(currencyUnit, providers);
    }

    public static MonetaryRounding getRounding(String roundingName, String ... providers) {
        if (monetaryRoundingsSpi == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return monetaryRoundingsSpi.getRounding(roundingName, providers);
    }

    public static MonetaryRounding getRounding(RoundingQuery roundingQuery) {
        if (monetaryRoundingsSpi == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return monetaryRoundingsSpi.getRounding(roundingQuery);
    }

    public static boolean isRoundingAvailable(String roundingName, String ... providers) {
        if (monetaryRoundingsSpi == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return monetaryRoundingsSpi.isRoundingAvailable(roundingName, providers);
    }

    public static boolean isRoundingAvailable(CurrencyUnit currencyUnit, String ... providers) {
        if (monetaryRoundingsSpi == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return monetaryRoundingsSpi.isRoundingAvailable(currencyUnit, providers);
    }

    public static boolean isRoundingAvailable(RoundingQuery roundingQuery) {
        if (monetaryRoundingsSpi == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return monetaryRoundingsSpi.isRoundingAvailable(roundingQuery);
    }

    public static Collection<MonetaryRounding> getRoundings(RoundingQuery roundingQuery) {
        if (monetaryRoundingsSpi == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return monetaryRoundingsSpi.getRoundings(roundingQuery);
    }

    public static Set<String> getRoundingNames(String ... providers) {
        if (monetaryRoundingsSpi == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return monetaryRoundingsSpi.getRoundingNames(providers);
    }

    public static Set<String> getRoundingProviderNames() {
        if (monetaryRoundingsSpi == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return monetaryRoundingsSpi.getProviderNames();
    }

    public static List<String> getDefaultRoundingProviderChain() {
        if (monetaryRoundingsSpi == null) {
            throw new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.");
        }
        return monetaryRoundingsSpi.getDefaultProviderChain();
    }
}

