/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javax.money.AbstractQueryBuilder;
import javax.money.CurrencyQuery;

public final class CurrencyQueryBuilder
extends AbstractQueryBuilder<CurrencyQueryBuilder, CurrencyQuery> {
    private CurrencyQueryBuilder() {
    }

    private CurrencyQueryBuilder(CurrencyQuery currencyQuery) {
        Objects.requireNonNull(currencyQuery);
        this.importContext(currencyQuery);
    }

    public CurrencyQueryBuilder setCountries(Locale ... countries) {
        return (CurrencyQueryBuilder)this.set("Query.countries", Arrays.asList(countries));
    }

    public CurrencyQueryBuilder setCurrencyCodes(String ... codes) {
        return (CurrencyQueryBuilder)this.set("Query.currencyCodes", Arrays.asList(codes));
    }

    public CurrencyQueryBuilder setNumericCodes(int ... codes) {
        ArrayList<Integer> intList = new ArrayList<Integer>(codes.length);
        int[] arr$ = codes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer code = arr$[i$];
            intList.add(code);
        }
        return (CurrencyQueryBuilder)this.set("Query.numericCodes", intList);
    }

    @Override
    public CurrencyQuery build() {
        return new CurrencyQuery(this);
    }

    public static CurrencyQueryBuilder of() {
        return new CurrencyQueryBuilder();
    }

    public static CurrencyQueryBuilder of(CurrencyQuery currencyQuery) {
        return new CurrencyQueryBuilder(currencyQuery);
    }
}

