/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.spi;

import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.spi.DefaultServiceProvider;
import javax.measure.spi.ServiceProvider;

public final class Bootstrap {
    private static volatile ServiceProvider serviceProviderDelegate;
    private static final Object LOCK;

    private Bootstrap() {
    }

    private static ServiceProvider loadDefaultServiceProvider() {
        try {
            Iterator<ServiceProvider> i$ = ServiceLoader.load(ServiceProvider.class).iterator();
            if (i$.hasNext()) {
                ServiceProvider sp = i$.next();
                return sp;
            }
        }
        catch (Exception e) {
            Logger.getLogger(Bootstrap.class.getName()).log(Level.INFO, "No ServiceProvider loaded, using default.");
        }
        return new DefaultServiceProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceProvider init(ServiceProvider serviceProvider) {
        if (serviceProvider == null) {
            throw new NullPointerException();
        }
        Object object = LOCK;
        synchronized (object) {
            if (serviceProviderDelegate == null) {
                serviceProviderDelegate = serviceProvider;
                Logger.getLogger(Bootstrap.class.getName()).log(Level.INFO, "Measurement Bootstrap: new ServiceProvider set: " + serviceProvider.getClass().getName());
                return null;
            }
            ServiceProvider prevProvider = serviceProviderDelegate;
            serviceProviderDelegate = serviceProvider;
            Logger.getLogger(Bootstrap.class.getName()).log(Level.WARNING, "Measurement Bootstrap: ServiceProvider replaced: " + serviceProvider.getClass().getName());
            return prevProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServiceProvider getServiceProvider() {
        if (serviceProviderDelegate == null) {
            Object object = LOCK;
            synchronized (object) {
                if (serviceProviderDelegate == null) {
                    serviceProviderDelegate = Bootstrap.loadDefaultServiceProvider();
                }
            }
        }
        return serviceProviderDelegate;
    }

    public static <T> Collection<T> getServices(Class<T> serviceType) {
        return Bootstrap.getServiceProvider().getServices(serviceType);
    }

    public static <T> T getService(Class<T> serviceType) {
        return Bootstrap.getServiceProvider().getService(serviceType);
    }

    static {
        LOCK = new Object();
    }
}

