/*
 * Decompiled with CFR 0.152.
 */
package javax.batch.operations;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.batch.operations.exception.JobExecutionAlreadyCompleteException;
import javax.batch.operations.exception.JobExecutionIsRunningException;
import javax.batch.operations.exception.JobExecutionNotMostRecentException;
import javax.batch.operations.exception.JobExecutionNotRunningException;
import javax.batch.operations.exception.JobRestartException;
import javax.batch.operations.exception.JobStartException;
import javax.batch.operations.exception.NoSuchJobException;
import javax.batch.operations.exception.NoSuchJobExecutionException;
import javax.batch.operations.exception.NoSuchJobInstanceException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;

public interface JobOperator {
    public Set<String> getJobNames();

    public int getJobInstanceCount(String var1) throws NoSuchJobException;

    public List<JobInstance> getJobInstances(String var1, int var2, int var3) throws NoSuchJobException;

    public List<JobInstance> getRunningInstances(String var1) throws NoSuchJobException;

    public List<JobExecution> getExecutions(JobInstance var1) throws NoSuchJobInstanceException;

    public Properties getParameters(JobInstance var1) throws NoSuchJobInstanceException;

    public long start(String var1, Properties var2) throws JobStartException;

    public long restart(long var1) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException;

    public long restart(long var1, Properties var3) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException;

    public void stop(long var1) throws NoSuchJobExecutionException, JobExecutionNotRunningException;

    public void abandon(JobInstance var1) throws NoSuchJobInstanceException, JobExecutionIsRunningException;

    public JobInstance getJobInstance(long var1) throws NoSuchJobExecutionException;

    public List<JobExecution> getJobExecutions(JobInstance var1) throws NoSuchJobInstanceException;

    public JobExecution getJobExecution(long var1) throws NoSuchJobExecutionException;

    public List<StepExecution> getStepExecutions(long var1) throws NoSuchJobExecutionException;

    public static enum BatchStatus {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        FAILED,
        COMPLETED,
        ABANDONED;

    }
}

