/*
 * Decompiled with CFR 0.152.
 */
package lti.java.jcf;

import java.io.IOException;
import lti.java.jcf.JcfClassInput;
import lti.java.jcf.JcfClassOutput;
import lti.java.jcf.JcfCodeAttribute;

public class JcfExceptionTable {
    public short catExceptTableSize;
    public short[] catExceptStartPC;
    public short[] catExceptEndPC;
    public short[] catExceptHandlerPC;
    public short[] catExceptCatchType;
    protected JcfCodeAttribute parent;

    public final JcfCodeAttribute getParent() {
        return this.parent;
    }

    public JcfExceptionTable(JcfClassInput ist, JcfCodeAttribute p) throws IOException {
        this.parent = p;
        this.catExceptTableSize = ist.readShort();
        this.catExceptStartPC = new short[this.catExceptTableSize];
        this.catExceptEndPC = new short[this.catExceptTableSize];
        this.catExceptHandlerPC = new short[this.catExceptTableSize];
        this.catExceptCatchType = new short[this.catExceptTableSize];
        int codeLength = this.parent.catCode.length;
        int i = 0;
        while (i < this.catExceptTableSize) {
            this.catExceptStartPC[i] = ist.readShortMax(codeLength);
            this.catExceptEndPC[i] = ist.readShortMax(codeLength);
            this.catExceptHandlerPC[i] = ist.readShortMax(codeLength);
            this.catExceptCatchType[i] = ist.readCPRef();
            ++i;
        }
    }

    public void write(JcfClassOutput ost) throws IOException {
        ost.writeShort(this.catExceptTableSize);
        int codeLength = this.parent.catCode.length;
        int i = 0;
        while (i < this.catExceptTableSize) {
            ost.writeShortMax(this.catExceptStartPC[i], codeLength);
            ost.writeShortMax(this.catExceptEndPC[i], codeLength);
            ost.writeShortMax(this.catExceptHandlerPC[i], codeLength);
            ost.writeCPRef(this.catExceptCatchType[i]);
            ++i;
        }
    }
}

