/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.AutoGridBagLayout;
import ccl.swing.ExitJDialog;
import ccl.swing.SwingUtil;
import ccl.util.SysEnv;
import ccl.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListEditDialog
extends ExitJDialog
implements ActionListener,
DocumentListener,
ListSelectionListener {
    private static final int WIDTH = 300;
    private static final int HEIGHT = 400;
    private static final Insets INSETS = new Insets(24, 4, 5, 4);
    private JButton _btnBrowse = new JButton("Browse...");
    private JButton _btnAdd = new JButton("Add");
    private JButton _btnChange = new JButton("Change");
    private JButton _btnDelete = new JButton("Delete");
    private JButton _btnUp = new JButton("Up");
    private JButton _btnDown = new JButton("Down");
    private JButton _btnOK = new JButton("OK");
    private JButton _btnCancel = new JButton("Cancel");
    private JList _lstItems = null;
    private JTextField _txtItem = new JTextField();
    private Vector _vOrigListItems = null;
    private Vector _vListItems = null;
    private boolean _bEnabled = false;
    private Frame _frmParent = null;
    private boolean _bOK = false;

    private void _setFont(Component pComponent_) {
        pComponent_.setFont(new Font("Dialog", 1, 12));
        pComponent_.setForeground(Color.black);
    }

    private void _addButton(AutoGridBagLayout agblLayout_, JPanel pnlBackground_, JButton pButton_) {
        agblLayout_.setExpandNone();
        this._setFont(pButton_);
        pButton_.setEnabled(false);
        pButton_.addActionListener(this);
        pnlBackground_.add(pButton_);
    }

    public ListEditDialog(Frame frmParent_, String sTitle_, Vector vListItems_) {
        this(frmParent_, sTitle_, vListItems_, false);
    }

    public ListEditDialog(Frame frmParent_, String sTitle_, Vector vListItems_, boolean bAddFileAndDirBrowsing_) {
        super(frmParent_, sTitle_);
        this._frmParent = frmParent_;
        JPanel pnlBackground = (JPanel)this.getContentPane();
        Util.panicIf(vListItems_ == null);
        this._vOrigListItems = (Vector)vListItems_.clone();
        this._vListItems = (Vector)vListItems_.clone();
        DefaultListModel<String> dlmItems = new DefaultListModel<String>();
        this._lstItems = new JList(dlmItems);
        Enumeration e = this._vListItems.elements();
        while (e.hasMoreElements()) {
            dlmItems.addElement((String)e.nextElement());
        }
        AutoGridBagLayout agblLayout = new AutoGridBagLayout();
        pnlBackground.setLayout(agblLayout);
        Util.debug("ListEditDialog: <init>: insets: " + this.getInsets());
        agblLayout.setFillHorizontal();
        agblLayout.setExpandHorizontal();
        JLabel lblNew = new JLabel("New Item:");
        this._setFont(lblNew);
        pnlBackground.add(lblNew);
        agblLayout.endLine();
        this._txtItem.getDocument().addDocumentListener(this);
        this._txtItem.setBorder(SwingUtil.createCCLBorder());
        pnlBackground.add(this._txtItem);
        if (bAddFileAndDirBrowsing_) {
            agblLayout.setExpandNone();
            this._setFont(this._btnBrowse);
            this._btnBrowse.addActionListener(this);
            pnlBackground.add(this._btnBrowse);
        } else {
            this._addButton(agblLayout, pnlBackground, this._btnAdd);
        }
        agblLayout.endLine();
        agblLayout.setExpandHorizontal();
        JLabel lblCurrent = new JLabel("Current Items:");
        this._setFont(lblCurrent);
        pnlBackground.add(lblCurrent);
        if (bAddFileAndDirBrowsing_) {
            agblLayout.setExpandNone();
            pnlBackground.add(new JLabel(" "));
        } else {
            this._addButton(agblLayout, pnlBackground, this._btnChange);
        }
        agblLayout.endLine();
        agblLayout.setFillBoth();
        agblLayout.setExpandBoth();
        int lines = 5;
        if (bAddFileAndDirBrowsing_) {
            lines += 2;
        }
        agblLayout.setExtend(1, lines);
        this._lstItems.addListSelectionListener(this);
        JScrollPane scpList = new JScrollPane(this._lstItems);
        scpList.setBorder(SwingUtil.createCCLBorder());
        pnlBackground.add(scpList);
        agblLayout.setExtend(1, 1);
        if (bAddFileAndDirBrowsing_) {
            this._addButton(agblLayout, pnlBackground, this._btnAdd);
            agblLayout.nextLine();
            this._addButton(agblLayout, pnlBackground, this._btnChange);
            agblLayout.nextLine();
        }
        agblLayout.setAnchor(11);
        agblLayout.setFillHorizontal();
        agblLayout.setExpandNone();
        this._setFont(this._btnDelete);
        this._btnDelete.setEnabled(false);
        this._btnDelete.addActionListener(this);
        pnlBackground.add(this._btnDelete);
        agblLayout.nextLine();
        agblLayout.setAnchor(15);
        agblLayout.setExpandVertical();
        this._setFont(this._btnUp);
        this._btnUp.setEnabled(false);
        this._btnUp.addActionListener(this);
        pnlBackground.add(this._btnUp);
        agblLayout.setAnchor(10);
        agblLayout.nextLine();
        agblLayout.setExpandNone();
        this._setFont(this._btnDown);
        this._btnDown.addActionListener(this);
        this._btnDown.setEnabled(false);
        pnlBackground.add(this._btnDown);
        agblLayout.nextLine();
        agblLayout.setAnchor(15);
        agblLayout.setExpandVertical(2.0);
        this._setFont(this._btnOK);
        this._btnOK.addActionListener(this);
        pnlBackground.add(this._btnOK);
        agblLayout.setAnchor(10);
        agblLayout.setExpandNone();
        agblLayout.nextLine();
        this._setFont(this._btnCancel);
        this._btnCancel.addActionListener(this);
        pnlBackground.add(this._btnCancel);
        this.setSize(300, 400);
        SwingUtil.centerComponent(this);
    }

    public Insets getInsets() {
        return INSETS;
    }

    public Vector getValue() {
        if (!this._bOK) {
            return this._vOrigListItems;
        }
        return this._vListItems;
    }

    public boolean isOK() {
        return this._bOK;
    }

    public void actionPerformed(ActionEvent pActionEvent_) {
        String sTemp;
        String sNewItem;
        Object oSource = pActionEvent_.getSource();
        DefaultListModel dlmItems = (DefaultListModel)this._lstItems.getModel();
        if (oSource == this._btnCancel) {
            this.setVisible(false);
        }
        if (oSource == this._btnOK) {
            this._bOK = true;
            this.setVisible(false);
        }
        if (oSource == this._btnBrowse) {
            String sStartDir = this._txtItem.getText().trim();
            String sFile = SwingUtil.getFileOrDirName(this._frmParent, "Select", sStartDir = SysEnv.evalEnvVariable(sStartDir));
            if (sFile != null) {
                this._txtItem.setText(sFile);
            }
        }
        if (oSource == this._btnAdd) {
            sNewItem = this._txtItem.getText();
            this._vListItems.addElement(sNewItem);
            dlmItems.addElement(sNewItem);
            int selectedIndex = this._vListItems.size() - 1;
            this._lstItems.setSelectedIndex(selectedIndex);
            this._btnDelete.setEnabled(true);
            this._btnChange.setEnabled(this._bEnabled);
            this._btnUp.setEnabled(selectedIndex != 0);
            this._btnDown.setEnabled(false);
            this._btnChange.setEnabled(false);
        }
        if (oSource == this._btnChange) {
            sNewItem = this._txtItem.getText();
            int selectedIndex = this._lstItems.getSelectedIndex();
            Util.debug("actionPerformed(..).selectedIndex: " + selectedIndex);
            Util.debug("actionPerformed(..)._vListItems: " + this._vListItems);
            this._vListItems.setElementAt(sNewItem, selectedIndex);
            Util.debug("actionPerformed(..)._vListItems: " + this._vListItems);
            dlmItems.setElementAt(sNewItem, selectedIndex);
            this._lstItems.setSelectedIndex(selectedIndex);
            this._btnChange.setEnabled(false);
        }
        if (oSource == this._btnDelete) {
            int selectedIndex = this._lstItems.getSelectedIndex();
            this._vListItems.removeElementAt(selectedIndex);
            dlmItems.removeElementAt(selectedIndex);
            if (selectedIndex == this._vListItems.size()) {
                --selectedIndex;
            }
            if (0 <= selectedIndex) {
                this._lstItems.setSelectedIndex(selectedIndex);
                this._btnDelete.setEnabled(true);
                this._btnChange.setEnabled(this._bEnabled);
                this._btnUp.setEnabled(selectedIndex != 0);
                this._btnDown.setEnabled(selectedIndex != this._vListItems.size() - 1);
                this._txtItem.setText((String)this._vListItems.elementAt(selectedIndex));
            } else {
                this._btnDelete.setEnabled(false);
                this._btnChange.setEnabled(false);
                this._btnDown.setEnabled(false);
                this._btnUp.setEnabled(false);
                this._txtItem.setText("");
            }
        }
        if (oSource == this._btnUp) {
            int selectedIndex = this._lstItems.getSelectedIndex();
            sTemp = (String)this._vListItems.elementAt(selectedIndex);
            this._vListItems.removeElementAt(selectedIndex);
            this._vListItems.insertElementAt(sTemp, selectedIndex - 1);
            dlmItems.removeElementAt(selectedIndex);
            dlmItems.insertElementAt(sTemp, selectedIndex - 1);
            this._lstItems.setSelectedIndex(selectedIndex - 1);
            this._btnUp.setEnabled(selectedIndex > 1);
            this._btnDown.setEnabled(true);
        }
        if (oSource == this._btnDown) {
            int selectedIndex = this._lstItems.getSelectedIndex();
            sTemp = (String)this._vListItems.elementAt(selectedIndex);
            this._vListItems.removeElementAt(selectedIndex);
            this._vListItems.insertElementAt(sTemp, selectedIndex + 1);
            dlmItems.removeElementAt(selectedIndex);
            dlmItems.insertElementAt(sTemp, selectedIndex + 1);
            this._lstItems.setSelectedIndex(selectedIndex + 1);
            this._btnUp.setEnabled(true);
            this._btnDown.setEnabled(selectedIndex + 2 != this._vListItems.size());
        }
    }

    public void changedUpdate(DocumentEvent pDocumentEvent_) {
        this._bEnabled = this._txtItem.getText().trim().length() > 0;
        this._btnAdd.setEnabled(this._bEnabled);
        this._btnChange.setEnabled(this._bEnabled && this._btnDelete.isEnabled() && !this._txtItem.getText().equals(this._lstItems.getSelectedValue().toString()));
    }

    public void insertUpdate(DocumentEvent pDocumentEvent_) {
        this.changedUpdate(pDocumentEvent_);
    }

    public void removeUpdate(DocumentEvent pDocumentEvent_) {
        this.changedUpdate(pDocumentEvent_);
    }

    public void valueChanged(ListSelectionEvent pListSelectionEvent_) {
        int selectedIndex = this._lstItems.getSelectedIndex();
        this._btnDelete.setEnabled(selectedIndex != -1);
        this._btnChange.setEnabled(this._bEnabled && selectedIndex != -1);
        this._btnUp.setEnabled(selectedIndex > 0);
        this._btnDown.setEnabled(selectedIndex != -1 && selectedIndex != this._vListItems.size() - 1);
        if (selectedIndex != -1) {
            this._txtItem.setText((String)this._vListItems.elementAt(selectedIndex));
        } else {
            this._txtItem.setText("");
        }
    }
}

