/*
 * Decompiled with CFR 0.152.
 */
package ccl.servlet;

import ccl.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.servlet.http.HttpServletResponse;

public class HTML {
    private PrintWriter _out = null;
    private boolean _bBeforeTR = true;
    private String _headerBGColor = null;
    private String _secondBGColor = null;
    private boolean _bSecondTableColor = false;

    public HTML(HttpServletResponse response_) throws IOException {
        response_.setContentType("text/html");
        this._initialize(response_.getWriter());
    }

    public HTML(Writer writer) {
        this._initialize(new PrintWriter(writer));
    }

    public HTML(PrintWriter writer) {
        this._initialize(writer);
    }

    public static HTML getDummyHTML() {
        StringWriter writer = new StringWriter();
        HTML html = new HTML(writer);
        return html;
    }

    private void _initialize(PrintWriter writer) {
        this._out = writer;
        this._out.println("<html>");
        this._out.println("<head>");
    }

    public void printTitle(String sTitle_) {
        this._out.println("<title>" + sTitle_ + "</title>");
        this._out.println("</head>");
        this._out.println("<body>");
        this._out.println("<center><h1>" + sTitle_ + "</h1></center>");
    }

    public void printTitle(String sTitle_, String bgcolor) {
        this._out.println("<title>" + sTitle_ + "</title>");
        this._out.println("</head>");
        this._out.println("<body bgcolor=\"" + bgcolor + "\">");
        this._out.println("<center><h1>" + sTitle_ + "</h1></center>");
    }

    public void printTitle(String title, String bgcolor, String textcolor) {
        this._out.println("<title>" + title + "</title>");
        this._out.println("</head>");
        this._out.println("<body text=\"" + textcolor + "\" bgcolor=\"" + bgcolor + "\">");
        this._out.println("<center><h1>" + title + "</h1></center>");
    }

    public void printTitle(String title, String bgcolor, String textcolor, String linkcolor, String vlinkcolor) {
        this._out.println("<title>" + title + "</title>");
        this._out.println("</head>");
        this._out.println("<body text=\"" + textcolor + "\" bgcolor=\"" + bgcolor + "\" link=\"" + linkcolor + "\" vlink=\"" + vlinkcolor + "\">");
        this._out.println("<center><h1>" + title + "</h1></center>");
    }

    public void print(String sHTML_) {
        this._out.print(sHTML_);
    }

    public void println(String sLine_) {
        this._out.println(sLine_);
    }

    public void printBR() {
        this.println("<br>");
    }

    public void printBR(String sText) {
        this.print(sText);
        this.printBR();
    }

    public void printP() {
        this.println("<p>");
    }

    public void printP(String sText) {
        this.print(sText);
        this.println("<p>");
    }

    public void printFormularStart(String sMethod_, String sAction_) {
        this._out.println("<form method=\"" + sMethod_ + "\" action=\"" + sAction_ + "\">");
        this._out.println("<table>");
    }

    public void printFormularHidden(String sName_, String sValue_) {
        this._out.println("<input type=\"hidden\" name=\"" + sName_ + "\" value=\"" + sValue_ + "\">");
    }

    public void printFormularTextInput(String sMessage_, String sName_) {
        this.printFormularTextInput(sMessage_, sName_, "");
    }

    public void printFormularTextArea(String sMessage_, String sName_, String sDefault_) {
        this._out.print("<tr><td>" + sMessage_ + ": </td>");
        this._out.print("<td rowspan=2><textarea name=\"" + sName_ + "\" cols=80 rows=12>");
        this._out.print(sDefault_);
        this._out.print("</textarea></td></tr>");
        this._out.print("<tr><td></td></tr>");
    }

    public void printFormularTextInput(String sMessage_, String sName_, String sDefault_, int size) {
        this._out.println("<tr><td>" + sMessage_ + ": </td>");
        this._out.println("<td><input type=\"text\" name=\"" + sName_ + "\" value=\"" + sDefault_ + "\" size=\"" + size + "\"></td></tr>");
    }

    public void printFormularTextInput(String sMessage_, String sName_, String sDefault_) {
        this._out.println("<tr><td>" + sMessage_ + ": </td>");
        this._out.println("<td><input type=\"text\" name=\"" + sName_ + "\" value=\"" + Util.replace(sDefault_, "\"", "&quot;") + "\"></td></tr>");
    }

    public void printFormularSelection(String sMessage_, String sName_, String[] asValue_, String sDefault_) {
        this.printFormularSelection(sMessage_, sName_, Util.objectsToVector(asValue_), Util.objectsToVector(asValue_), sDefault_);
    }

    public void printFormularSelection(String sMessage_, String sName_, String[] asValue_, String[] asRepresentation_, String sDefaultValue_) {
        this.printFormularSelection(sMessage_, sName_, Util.objectsToVector(asValue_), Util.objectsToVector(asRepresentation_), sDefaultValue_);
    }

    public void printFormularSelection(String sMessage_, String sName_, String[] asValue_, String[] asRepresentation_) {
        this.printFormularSelection(sMessage_, sName_, Util.objectsToVector(asValue_), Util.objectsToVector(asRepresentation_), asValue_[0]);
    }

    public void printFormularSelection(String sMessage_, String sName_, Vector vValues_, Vector vRepresentations_, String sDefaultValue_) {
        this._out.println("<tr><td>" + sMessage_ + ": </td>");
        this._out.println("<td><select name=\"" + sName_ + "\">");
        int option = 0;
        while (option < vValues_.size()) {
            this._out.print("  <option value=\"" + vValues_.elementAt(option) + "\"");
            if (((String)vValues_.elementAt(option)).equals(sDefaultValue_)) {
                this._out.print(" selected");
            }
            this._out.println(">" + vRepresentations_.elementAt(option) + "</option>");
            ++option;
        }
        this._out.println("</select></td></tr>");
    }

    public void printFormularSelection(String sMessage_, String sName_, String sSqlQuery_, String sDefaultValue_, Statement statement_) throws SQLException {
        Vector<String> vIds = new Vector<String>();
        Vector<String> vNames = new Vector<String>();
        ResultSet result = statement_.executeQuery(sSqlQuery_);
        while (result.next()) {
            vIds.addElement(result.getString("id"));
            vNames.addElement(result.getString("name"));
        }
        result.close();
        this.printFormularSelection(sMessage_, sName_, vIds, vNames, sDefaultValue_);
    }

    public void printFormularOperationMode() {
        this._out.println("<tr><td>Operation mode:&nbsp</td><td><input type=\"submit\" name=\"operation_mode\" value=\"   Add   \" length=\"10\"><input type=\"submit\" name=\"operation_mode\" value=\"Change\" length=\"10\"><input type=\"submit\" name=\"operation_mode\" value=\" Delete \" length=\"10\"></td></tr>");
        this._out.println("</table>");
        this._out.println("</form>");
    }

    public void printFormularSubmit() {
        this.printFormularSubmit("Submit");
    }

    public void printFormularSubmit(String label) {
        this._out.println("<tr><td></td><td><input type=\"submit\" name=\"" + label + "\"></td></tr>");
        this._out.println("</table>");
        this._out.println("</form>");
    }

    public void printLink(String sText, String sURL) {
        this._out.print("<a href=\"" + sURL + "\">" + sText + "</a>");
    }

    public void printTableStart() {
        this._out.println("<table>");
    }

    public void printTableValue(String value) {
        if (this._bBeforeTR) {
            this._out.println("  <tr>");
            this._bBeforeTR = false;
        }
        this._out.println("    <td>" + value + "</td>");
    }

    public void printTableValue(String value, String align) {
        if (this._bBeforeTR) {
            this._out.println("  <tr>");
            this._bBeforeTR = false;
        }
        this._out.println("    <td align=" + align + ">" + value + "</td>");
    }

    public void endTableLine() {
        this._out.println("  </tr>");
        this._bBeforeTR = true;
    }

    public void printTableEnd() {
        this._out.println("</table>");
    }

    public void printDataTableStart(String headerBGColor, String secondBGColor) {
        this._out.println("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        this._headerBGColor = headerBGColor;
        this._secondBGColor = secondBGColor;
        this._bBeforeTR = true;
        this._bSecondTableColor = false;
    }

    public void printDataTableHeader(String header) {
        this.printDataTableHeader(header, "left");
    }

    public void printDataTableHeader(String header, String align) {
        this.printDataTableHeader(header, align, 1);
    }

    public void printDataTableHeader(String header, String align, int colspan) {
        if (this._bBeforeTR) {
            this._out.println("  <tr bgcolor=\"" + this._headerBGColor + "\">");
            this._bBeforeTR = false;
        }
        this._out.print("    <td>&nbsp;&nbsp;</td><td");
        if (colspan > 1) {
            this._out.print(" colspan=" + colspan);
        }
        this._out.print(" valign=top align=" + align + "><b>" + header + "</b></td>");
    }

    public void printDataTableValue(String value) {
        this.printDataTableValue(value, "left");
    }

    public void printDataTableValue(String value, String align) {
        this.printDataTableValue(value, align, 1);
    }

    public void printDataTableValue(String value, String align, int colspan) {
        if (this._bBeforeTR) {
            this._out.print("  <tr");
            if (this._bSecondTableColor) {
                this._out.print(" bgcolor=\"" + this._secondBGColor + "\"");
            }
            this._out.println(">");
            this._bSecondTableColor = !this._bSecondTableColor;
            this._bBeforeTR = false;
        }
        this._out.print("    <td>&nbsp;</td><td");
        if (colspan > 1) {
            this._out.print(" colspan=" + colspan);
        }
        this._out.println(" valign=top align=" + align + ">" + value + "</td>");
    }

    public void endDataTableLine() {
        this._out.println("<td>&nbsp;&nbsp;</td>\n  </tr>");
        this._bBeforeTR = true;
    }

    public void printResultSet(String headerBGColor, String secondBGColor, ResultSet result) throws SQLException {
        ResultSetMetaData metaData = result.getMetaData();
        int numberOfColumns = metaData.getColumnCount();
        this.printDataTableStart(headerBGColor, secondBGColor);
        int column = 1;
        while (column <= numberOfColumns) {
            String sColumnName = metaData.getColumnName(column);
            this.printDataTableHeader(sColumnName);
            ++column;
        }
        this.endDataTableLine();
        while (result.next()) {
            int column2 = 1;
            while (column2 <= numberOfColumns) {
                String sValue;
                Object oValue = result.getObject(column2);
                if (oValue == null) {
                    oValue = "";
                }
                if (Util.isEmpty(sValue = String.valueOf(oValue).trim())) {
                    sValue = "&nbsp;";
                }
                this.printDataTableValue(sValue);
                ++column2;
            }
            this.endDataTableLine();
        }
        this.printTableEnd();
    }

    public void close() {
        this._out.println("</body>");
        this._out.println("</html>");
        this._out.close();
    }

    public static String spacify(String value) {
        if (Util.isEmpty(value)) {
            return "&nbsp;";
        }
        return value;
    }

    private static String untabify(String s) {
        return Util.replace(s, "\t", " ");
    }

    public static void exportCSV(HttpServletResponse response, ResultSet result) throws IOException, SQLException {
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        ResultSetMetaData metaData = result.getMetaData();
        int numberOfColumns = metaData.getColumnCount();
        int column = 1;
        while (column <= numberOfColumns) {
            String sColumnName = metaData.getColumnName(column);
            if (column > 1) {
                out.print("\t");
            }
            out.print(HTML.untabify(sColumnName));
            ++column;
        }
        out.println();
        while (result.next()) {
            int column2 = 1;
            while (column2 <= numberOfColumns) {
                Object oValue = result.getObject(column2);
                if (oValue == null) {
                    oValue = "";
                }
                String sValue = HTML.untabify(String.valueOf(oValue).trim());
                if (column2 > 1) {
                    out.print("\t");
                }
                out.print(sValue);
                ++column2;
            }
            out.println();
        }
    }
}

