/*
 * Decompiled with CFR 0.152.
 */
package javagh.jenkins.mashupportlets;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.Collection;
import javagh.jenkins.mashupportlets.AbstractMashupPortlet;
import javagh.jenkins.mashupportlets.ServerSideHttpCall;
import javagh.jenkins.mashupportlets.SonarAssigneeStatus;
import javagh.jenkins.mashupportlets.SonarPriority;
import javagh.jenkins.mashupportlets.Utils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class SonarIssuesPortlet
extends AbstractMashupPortlet {
    private static final int DEFAULT_PRIO_NO = -1;
    private final String sonarBaseUrl;
    private final String sonarProjectsList;
    private final int sonarPriorityThreshold;
    private final int sonarNewIssuesPriorityThreshold;
    private final int sonarAssigneeStatus;
    private final boolean sonarShowAssigneeBar;
    private final String labelAssigneesRanking;
    private final int maxAssigneesInRanking;
    private final int maxEntries;
    private final int deltaDaysForNewIssues;
    private final String divId;
    private Secret secretSonarApiUserOrToken;
    private Secret secretSonarApiPw;

    @DataBoundConstructor
    public SonarIssuesPortlet(String name, String sonarBaseUrl, String sonarProjectsList, int sonarPriorityThreshold, int sonarAssigneeStatus, boolean sonarShowAssigneeBar, int maxEntries, int sonarNewIssuesPriorityThreshold, int deltaDaysForNewIssues, int violationDescriptionMaximumLength, Secret secretSonarApiUserOrToken, Secret secretSonarApiPw, String labelAssigneesRanking, int maxAssigneesInRanking) {
        super(name);
        this.sonarBaseUrl = Utils.normalizeBaseUrl(sonarBaseUrl);
        this.sonarProjectsList = sonarProjectsList;
        this.sonarPriorityThreshold = sonarPriorityThreshold;
        this.sonarAssigneeStatus = sonarAssigneeStatus;
        this.sonarShowAssigneeBar = sonarShowAssigneeBar;
        this.labelAssigneesRanking = labelAssigneesRanking;
        this.maxAssigneesInRanking = maxAssigneesInRanking;
        this.maxEntries = maxEntries;
        this.sonarNewIssuesPriorityThreshold = sonarNewIssuesPriorityThreshold;
        this.deltaDaysForNewIssues = deltaDaysForNewIssues;
        this.secretSonarApiUserOrToken = secretSonarApiUserOrToken;
        this.secretSonarApiPw = secretSonarApiPw;
        this.divId = "sonarDiv_" + this.getId();
    }

    public String getDivId() {
        return this.divId;
    }

    public String getSonarBaseUrl() {
        return this.sonarBaseUrl;
    }

    public String getSonarProjectsList() {
        return this.sonarProjectsList;
    }

    public int getMaxEntries() {
        return this.maxEntries > 0 ? this.maxEntries : 50;
    }

    public int getMaxAssigneesInRanking() {
        return this.maxAssigneesInRanking > 0 ? this.maxAssigneesInRanking : 5;
    }

    public int getSonarPriorityThreshold() {
        return this.sonarPriorityThreshold;
    }

    public int getSonarNewIssuesPriorityThreshold() {
        return this.sonarNewIssuesPriorityThreshold;
    }

    public int getDeltaDaysForNewIssues() {
        return this.deltaDaysForNewIssues > 0 ? this.deltaDaysForNewIssues : 5;
    }

    public int getSonarAssigneeStatus() {
        return this.sonarAssigneeStatus;
    }

    public boolean isSonarShowAssigneeBar() {
        return this.sonarShowAssigneeBar;
    }

    public String getLabelAssigneesRanking() {
        return this.labelAssigneesRanking;
    }

    public Secret getSecretSonarApiUserOrToken() {
        return this.secretSonarApiUserOrToken;
    }

    public Secret getSecretSonarApiPw() {
        return this.secretSonarApiPw;
    }

    public String getSonarProjectsJson() {
        String projectsJson = Utils.configListToJsonList(this.sonarProjectsList);
        return projectsJson;
    }

    public String getSonarPrioritiesJson() {
        return this.getPrioritiesListForThreshold(this.sonarPriorityThreshold);
    }

    public String getSonarNewIssuesPrioritiesJson() {
        int applicableThreshold = this.sonarNewIssuesPriorityThreshold != -1 ? this.sonarNewIssuesPriorityThreshold : this.sonarPriorityThreshold;
        return this.getPrioritiesListForThreshold(applicableThreshold);
    }

    private String getPrioritiesListForThreshold(int threshold) {
        SonarPriority[] values = SonarPriority.values();
        Object[] applicableValues = ArrayUtils.subarray((Object[])values, (int)threshold, (int)values.length);
        ArrayUtils.reverse((Object[])applicableValues);
        String json = "['" + StringUtils.join((Object[])applicableValues, (String)"', '") + "']";
        return json;
    }

    public String getPriorityValueByNameJson() {
        return SonarPriority.getPriorityValueByNameJson();
    }

    public String getAssigneeStatusValueByNameJson() {
        return SonarAssigneeStatus.getPriorityValueByNameJson();
    }

    @JavaScriptMethod
    public HttpResponse ajaxViaJenkins(String urlStr) {
        return new ServerSideHttpCall(urlStr, Secret.toString((Secret)this.secretSonarApiUserOrToken), Secret.toString((Secret)this.secretSonarApiPw));
    }

    @Extension
    public static class SonarIssuesPortletDescriptor
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return "SonarQube Issues";
        }

        public ListBoxModel doFillSonarPriorityThresholdItems() {
            ListBoxModel items = new ListBoxModel();
            for (SonarPriority sonarPriority : SonarPriority.values()) {
                items.add(sonarPriority.name(), String.valueOf(sonarPriority.ordinal()));
            }
            return items;
        }

        public ListBoxModel doFillSonarNewIssuesPriorityThresholdItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Same as for default list", String.valueOf(-1));
            items.addAll((Collection)this.doFillSonarPriorityThresholdItems());
            return items;
        }

        public ListBoxModel doFillSonarAssigneeStatusItems() {
            ListBoxModel items = new ListBoxModel();
            for (SonarAssigneeStatus sonarAssigneeStatus : SonarAssigneeStatus.values()) {
                items.add(sonarAssigneeStatus.name(), String.valueOf(sonarAssigneeStatus.ordinal()));
            }
            return items;
        }
    }
}

