/*
 * Decompiled with CFR 0.152.
 */
package javagh.jenkins.mashupportlets;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.util.ListBoxModel;
import java.util.Collection;
import javagh.jenkins.mashupportlets.AbstractMashupPortlet;
import javagh.jenkins.mashupportlets.ServerSideHttpCall;
import javagh.jenkins.mashupportlets.SonarAssigneeStatus;
import javagh.jenkins.mashupportlets.SonarPriority;
import javagh.jenkins.mashupportlets.Utils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class SonarIssuesPortlet
extends AbstractMashupPortlet {
    private static final int DEFAULT_PRIO_NO = -1;
    private final String sonarBaseUrl;
    private final String sonarProjectsList;
    private final int sonarPriorityThreshold;
    private final int sonarNewIssuesPriorityThreshold;
    private final int sonarAssigneeStatus;
    private final boolean sonarShowAssigneeBar;
    private final String labelAssigneesRanking;
    private final int maxAssigneesInRanking;
    private final int maxEntries;
    private final int deltaDaysForNewIssues;
    private final String divId;
    private final String sonarApiUser;
    private final String sonarApiPw;
    private final boolean showAlerts;
    private final String metricsCheckedForAlerts;
    private final String alwaysShowMetrics;

    @DataBoundConstructor
    public SonarIssuesPortlet(String name, String sonarBaseUrl, String sonarProjectsList, int sonarPriorityThreshold, int sonarAssigneeStatus, boolean sonarShowAssigneeBar, boolean showAlerts, String metricsCheckedForAlerts, String alwaysShowMetrics, int maxEntries, int sonarNewIssuesPriorityThreshold, int deltaDaysForNewIssues, int violationDescriptionMaximumLength, String sonarApiUser, String sonarApiPw, String labelAssigneesRanking, int maxAssigneesInRanking) {
        super(name);
        this.sonarBaseUrl = Utils.normalizeBaseUrl(sonarBaseUrl);
        this.sonarProjectsList = sonarProjectsList;
        this.sonarPriorityThreshold = sonarPriorityThreshold;
        this.sonarAssigneeStatus = sonarAssigneeStatus;
        this.sonarShowAssigneeBar = sonarShowAssigneeBar;
        this.labelAssigneesRanking = labelAssigneesRanking;
        this.maxAssigneesInRanking = maxAssigneesInRanking;
        this.maxEntries = maxEntries;
        this.sonarNewIssuesPriorityThreshold = sonarNewIssuesPriorityThreshold;
        this.deltaDaysForNewIssues = deltaDaysForNewIssues;
        this.sonarApiUser = sonarApiUser;
        this.sonarApiPw = sonarApiPw;
        this.showAlerts = showAlerts;
        this.metricsCheckedForAlerts = metricsCheckedForAlerts;
        this.alwaysShowMetrics = alwaysShowMetrics;
        this.divId = "sonarDiv_" + this.getId();
    }

    public String getDivId() {
        return this.divId;
    }

    public String getSonarBaseUrl() {
        return this.sonarBaseUrl;
    }

    public String getSonarProjectsList() {
        return this.sonarProjectsList;
    }

    public int getMaxEntries() {
        return this.maxEntries > 0 ? this.maxEntries : 50;
    }

    public int getMaxAssigneesInRanking() {
        return this.maxAssigneesInRanking > 0 ? this.maxAssigneesInRanking : 5;
    }

    public int getSonarPriorityThreshold() {
        return this.sonarPriorityThreshold;
    }

    public int getSonarNewIssuesPriorityThreshold() {
        return this.sonarNewIssuesPriorityThreshold;
    }

    public int getDeltaDaysForNewIssues() {
        return this.deltaDaysForNewIssues > 0 ? this.deltaDaysForNewIssues : 5;
    }

    public int getSonarAssigneeStatus() {
        return this.sonarAssigneeStatus;
    }

    public boolean isSonarShowAssigneeBar() {
        return this.sonarShowAssigneeBar;
    }

    public String getLabelAssigneesRanking() {
        return this.labelAssigneesRanking;
    }

    public String getSonarApiUser() {
        return this.sonarApiUser;
    }

    public String getSonarApiPw() {
        return this.sonarApiPw;
    }

    public boolean getShowAlerts() {
        return this.showAlerts;
    }

    public String getMetricsCheckedForAlerts() {
        return this.metricsCheckedForAlerts;
    }

    public String getMetricsCheckedForAlertsJson() {
        String metricsCheckedForAlerts = StringUtils.isBlank((String)this.metricsCheckedForAlerts) ? "complexity,class_complexity,file_complexity,function_complexity,file_cycles,file_edges_weight,package_tangles,file_tangles,file_tangle_index,package_cycles,package_feedback_edges,package_tangle_index,package_edges_weight,file_feedback_edges,comment_lines,comment_lines_density,public_documented_api_density,public_undocumented_api,duplicated_blocks,duplicated_files,duplicated_lines,duplicated_lines_density,new_violations,new_blocker_violations,new_critical_violations,new_major_violations,blocker_violations,critical_violations,major_violations,violations,false_positive_issues,open_issues,confirmed_issues,reopened_issues,weighted_violations,violations_density,sqale_index,branch_coverage,new_branch_coverage,coverage,new_coverage,new_line_coverage,skipped_tests,uncovered_conditions,new_uncovered_conditions,uncovered_lines,new_uncovered_lines,tests,test_execution_time,test_errors,test_failures,test_success_density" : this.metricsCheckedForAlerts;
        String metricsCheckedForAlertsJson = Utils.configListToJsonList(metricsCheckedForAlerts);
        return metricsCheckedForAlertsJson;
    }

    public String getAlwaysShowMetrics() {
        return this.alwaysShowMetrics;
    }

    public String getAlwaysShowMetricsJson() {
        String alwaysShowMetricsJson = Utils.configListToJsonList(this.alwaysShowMetrics);
        return alwaysShowMetricsJson;
    }

    public String getSonarProjectsJson() {
        String projectsJson = Utils.configListToJsonList(this.sonarProjectsList);
        return projectsJson;
    }

    public String getSonarPrioritiesJson() {
        return this.getPrioritiesListForThreshold(this.sonarPriorityThreshold);
    }

    public String getSonarNewIssuesPrioritiesJson() {
        int applicableThreshold = this.sonarNewIssuesPriorityThreshold != -1 ? this.sonarNewIssuesPriorityThreshold : this.sonarPriorityThreshold;
        return this.getPrioritiesListForThreshold(applicableThreshold);
    }

    private String getPrioritiesListForThreshold(int threshold) {
        SonarPriority[] values = SonarPriority.values();
        Object[] applicableValues = ArrayUtils.subarray((Object[])values, (int)threshold, (int)values.length);
        ArrayUtils.reverse((Object[])applicableValues);
        String json = "['" + StringUtils.join((Object[])applicableValues, (String)"', '") + "']";
        return json;
    }

    public String getPriorityValueByNameJson() {
        return SonarPriority.getPriorityValueByNameJson();
    }

    public String getAssigneeStatusValueByNameJson() {
        return SonarAssigneeStatus.getPriorityValueByNameJson();
    }

    @JavaScriptMethod
    public HttpResponse ajaxViaJenkins(String urlStr) {
        return new ServerSideHttpCall(urlStr, this.sonarApiUser, this.sonarApiPw);
    }

    @Extension
    public static class SonarIssuesPortletDescriptor
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return "SonarQube Issues";
        }

        public ListBoxModel doFillSonarPriorityThresholdItems() {
            ListBoxModel items = new ListBoxModel();
            for (SonarPriority sonarPriority : SonarPriority.values()) {
                items.add(sonarPriority.name(), String.valueOf(sonarPriority.ordinal()));
            }
            return items;
        }

        public ListBoxModel doFillSonarNewIssuesPriorityThresholdItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Same as for default list", String.valueOf(-1));
            items.addAll((Collection)this.doFillSonarPriorityThresholdItems());
            return items;
        }

        public ListBoxModel doFillSonarAssigneeStatusItems() {
            ListBoxModel items = new ListBoxModel();
            for (SonarAssigneeStatus sonarAssigneeStatus : SonarAssigneeStatus.values()) {
                items.add(sonarAssigneeStatus.name(), String.valueOf(sonarAssigneeStatus.ordinal()));
            }
            return items;
        }
    }
}

