/*
 * Decompiled with CFR 0.152.
 */
package javagh.jenkins.mashupportlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.ServletException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ServerSideHttpCall
implements HttpResponse {
    private static final String ERROR = "ERROR: ";
    private static final String HEADER_ORIG_RESPONSE_MESSAGE = "X-OriginalResponseMessage";
    private static final String HEADER_ORIG_RESPONSE_CODE = "X-OriginalResponseCode";
    private final String urlStr;
    private final String httpBasicAuthUser;
    private final String httpBasicAuthPw;

    public ServerSideHttpCall(String urlStr, String httpBasicAuthUser, String httpBasicAuthPw) {
        this.urlStr = urlStr;
        this.httpBasicAuthUser = httpBasicAuthUser;
        this.httpBasicAuthPw = httpBasicAuthPw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateResponse(StaplerRequest request, StaplerResponse response, Object node) throws IOException, ServletException {
        HttpURLConnection urlCon = null;
        InputStream inputStream = null;
        String out = "";
        try {
            URL url = new URL(this.urlStr);
            urlCon = (HttpURLConnection)url.openConnection();
            if (StringUtils.isNotBlank((String)this.httpBasicAuthUser) && StringUtils.isNotBlank((String)this.httpBasicAuthPw)) {
                String strEncoding = "UTF-8";
                String encoded = new String(Base64.encodeBase64((byte[])(this.httpBasicAuthUser + ":" + this.httpBasicAuthPw).getBytes("UTF-8")), "UTF-8");
                urlCon.setRequestProperty("Authorization", "Basic " + encoded);
            }
            response.setHeader(HEADER_ORIG_RESPONSE_CODE, String.valueOf(urlCon.getResponseCode()));
            response.setHeader(HEADER_ORIG_RESPONSE_MESSAGE, urlCon.getResponseMessage());
            response.setContentType(urlCon.getContentType());
            response.setCharacterEncoding(urlCon.getContentEncoding());
            inputStream = urlCon.getInputStream();
            out = IOUtils.toString((InputStream)inputStream);
        }
        catch (Exception e) {
            if (urlCon != null && (inputStream = urlCon.getErrorStream()) != null) {
                try {
                    out = ERROR + IOUtils.toString((InputStream)inputStream);
                }
                catch (Exception ex) {
                    out = "ERROR: Sending error stream failed: " + ex + " Cause: " + e;
                }
            } else {
                out = ERROR + e;
            }
        }
        finally {
            PrintWriter responseWriter = response.getWriter();
            responseWriter.print(out);
            IOUtils.closeQuietly((Writer)responseWriter);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

