/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.soap;

import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.ServiceLoaderUtil;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

class FactoryFinder {
    private static final Logger logger;
    private static final ServiceLoaderUtil.ExceptionHandler<SOAPException> EXCEPTION_HANDLER;
    private static final PrivilegedAction<String> propertyAction;
    private static final String OSGI_SERVICE_LOADER_CLASS_NAME = "org.glassfish.hk2.osgiresourcelocator.ServiceLoader";

    FactoryFinder() {
    }

    static <T> T find(Class<T> factoryClass, String defaultClassName, boolean tryFallback) throws SOAPException {
        Object result;
        Object result2;
        ClassLoader tccl = ServiceLoaderUtil.contextClassLoader(EXCEPTION_HANDLER);
        String factoryId = factoryClass.getName();
        String className = FactoryFinder.fromSystemProperty(factoryId);
        if (className != null && (result2 = FactoryFinder.newInstance(className, defaultClassName, tccl)) != null) {
            return (T)result2;
        }
        className = FactoryFinder.fromJDKProperties(factoryId);
        if (className != null && (result2 = FactoryFinder.newInstance(className, defaultClassName, tccl)) != null) {
            return (T)result2;
        }
        T factory = ServiceLoaderUtil.firstByServiceLoader(factoryClass, logger, EXCEPTION_HANDLER);
        if (factory != null) {
            return factory;
        }
        if (FactoryFinder.isOsgi() && (result = FactoryFinder.lookupUsingOSGiServiceLoader(factoryId)) != null) {
            return (T)result;
        }
        if (!tryFallback) {
            return null;
        }
        if (defaultClassName == null) {
            throw new SOAPException("Provider for " + factoryId + " cannot be found", null);
        }
        logger.fine("Trying to create the default implementation of the message factory");
        return (T)FactoryFinder.newInstance(defaultClassName, defaultClassName, tccl);
    }

    private static Object newInstance(String className, String defaultClassName, ClassLoader tccl) throws SOAPException {
        Object newInstance = ServiceLoaderUtil.newInstance(className, defaultClassName, tccl, EXCEPTION_HANDLER);
        if (logger.isLoggable(Level.FINE)) {
            Class<?> newInstanceClass = newInstance.getClass();
            logger.log(Level.FINE, "loaded {0} from {1}", new Object[]{newInstanceClass.getName(), FactoryFinder.which(newInstanceClass)});
        }
        return newInstance;
    }

    private static String fromJDKProperties(String factoryId) {
        block10: {
            Path path = null;
            try {
                String JAVA_HOME = FactoryFinder.getSystemProperty("java.home");
                path = Paths.get(JAVA_HOME, "conf", "jaxm.properties");
                logger.log(Level.FINE, "Checking configuration in {0}", path);
                if (!Files.exists(path, new LinkOption[0])) {
                    path = Paths.get(JAVA_HOME, "lib", "jaxm.properties");
                }
                logger.log(Level.FINE, "Checking configuration in {0}", path);
                if (!Files.exists(path, new LinkOption[0])) break block10;
                Properties props = new Properties();
                try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                    props.load(inputStream);
                }
                logger.log(Level.FINE, "Checking property {0}", factoryId);
                String factoryClassName = props.getProperty(factoryId);
                FactoryFinder.logFound(factoryClassName);
                if (factoryClassName != null) {
                    return factoryClassName;
                }
            }
            catch (Exception ignored) {
                logger.log(Level.SEVERE, "Error reading SAAJ configuration from [" + path + "] file. Check it is accessible and has correct format.", ignored);
            }
        }
        return null;
    }

    private static String fromSystemProperty(String factoryId) {
        String systemProp = FactoryFinder.getSystemProperty(factoryId);
        if (systemProp != null) {
            return systemProp;
        }
        return null;
    }

    private static String getSystemProperty(final String property) {
        logger.log(Level.FINE, "Checking system property {0}", property);
        String value = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(property);
            }
        });
        FactoryFinder.logFound(value);
        return value;
    }

    private static void logFound(String value) {
        if (value != null) {
            logger.log(Level.FINE, "  found {0}", value);
        } else {
            logger.log(Level.FINE, "  not found");
        }
    }

    private static boolean isOsgi() {
        try {
            Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            logger.log(Level.SEVERE, "Class org.glassfish.hk2.osgiresourcelocator.ServiceLoader cannot be loaded", ignored);
            return false;
        }
    }

    private static Object lookupUsingOSGiServiceLoader(String factoryId) {
        try {
            logger.fine("Trying to create the provider from the OSGi ServiceLoader");
            Class<?> serviceClass = Class.forName(factoryId);
            Class[] args = new Class[]{serviceClass};
            Class<?> target = Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            Method m = target.getMethod("lookupProviderInstances", Class.class);
            Iterator iter = ((Iterable)m.invoke(null, (Object[])args)).iterator();
            return iter.hasNext() ? iter.next() : null;
        }
        catch (Exception ignored) {
            logger.log(Level.SEVERE, "Access to the system property with key " + factoryId + " is not allowed", ignored);
            return null;
        }
    }

    static URL which(Class clazz) {
        return FactoryFinder.which(clazz, FactoryFinder.getClassClassLoader(clazz));
    }

    static URL which(Class clazz, ClassLoader loader) {
        String classnameAsResource = clazz.getName().replace('.', '/') + ".class";
        if (loader == null) {
            loader = FactoryFinder.getSystemClassLoader();
        }
        return loader.getResource(classnameAsResource);
    }

    private static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    private static ClassLoader getClassClassLoader(Class c) {
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(c::getClassLoader);
    }

    static {
        EXCEPTION_HANDLER = new ServiceLoaderUtil.ExceptionHandler<SOAPException>(){

            @Override
            public SOAPException createException(Throwable throwable, String message) {
                return new SOAPException(message, throwable);
            }
        };
        propertyAction = () -> System.getProperty("saaj.debug");
        logger = Logger.getLogger("jakarta.xml.soap");
        try {
            if (AccessController.doPrivileged(propertyAction) != null) {
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
                ConsoleHandler handler = new ConsoleHandler();
                handler.setLevel(Level.ALL);
                logger.addHandler(handler);
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception during loading the class", t);
        }
    }
}

