/*  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

/*
 * This source code implements specifications defined by the Java
 * Community Process. In order to remain compliant with the specification
 * DO NOT add / change / or delete method signatures!
 */

/**
 * <span class="changed_modified_4_0">The</span> jakarta.portlet package defines the API
 * for the Jakarta Portlet Specification <span class="changed_modified_4_0">V4.0</span>.
 * <p>
 * A portlet is a Java technology based web component, managed by a portlet container,
 * that processes requests and generates dynamic content. Portlets provide a presentation
 * layer to Information Systems.
 * </p>
 * <p>
 * Portlets generate fragments of markup (e.g. HTML, XHTML, WML). A portal combines markup
 * fragments generated by different portlets into a portal page.
 * </p>
 * <p>
 * A portlet container manages the lifecyle of portlets. It also provides the required runtime environment.
 * </p>
 * <p>
 * Portlets are bundled in Portlet Applications as web applications using the WAR file format.
 * A portlet application consists of two deployment descriptors: one to specify
 * the web application resources (web.xml) and one to specify the portlet resources
 * (portlet.xml). The portlet.xml must follow the schema defined by the
 * http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd namespace.
 * </p>
 */
package jakarta.portlet;
