/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.el.ValueExpression;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.MessageFactory;
import jakarta.faces.component.StateHolderSaver;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import jakarta.faces.render.Renderer;
import jakarta.faces.validator.RequiredValidator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;

public class UIViewParameter
extends UIInput {
    public static final String COMPONENT_TYPE = "jakarta.faces.ViewParameter";
    public static final String COMPONENT_FAMILY = "jakarta.faces.ViewParameter";
    private Renderer inputTextRenderer = null;
    private transient Boolean emptyStringIsNull;
    private String rawValue;

    public UIViewParameter() {
        this.setRendererType(null);
    }

    @Override
    public String getFamily() {
        return "jakarta.faces.ViewParameter";
    }

    public String getName() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.name));
    }

    public void setName(String name) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.name), name);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public Object getSubmittedValue() {
        return this.getStateHelper().get((Serializable)((Object)PropertyKeys.submittedValue));
    }

    @Override
    public void setSubmittedValue(Object submittedValue) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.submittedValue), submittedValue);
    }

    @Override
    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        String paramValue = context.getExternalContext().getRequestParameterMap().get(this.getName());
        if (paramValue != null) {
            this.setSubmittedValue(paramValue);
        }
        this.rawValue = (String)this.getSubmittedValue();
        this.setValid(true);
    }

    @Override
    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue == null && this.myIsRequired()) {
            String requiredMessageStr = this.getRequiredMessage();
            FacesMessage message = null != requiredMessageStr ? new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessageStr, requiredMessageStr) : MessageFactory.getMessage(context, "jakarta.faces.component.UIInput.REQUIRED", MessageFactory.getLabel(context, this));
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
            context.validationFailed();
            context.renderResponse();
        } else {
            if (this.myConsiderEmptyStringNull(context) && null == submittedValue) {
                this.setSubmittedValue("");
            }
            super.processValidators(context);
        }
    }

    private boolean myConsiderEmptyStringNull(FacesContext ctx) {
        if (this.emptyStringIsNull == null) {
            String val = ctx.getExternalContext().getInitParameter("jakarta.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL");
            this.emptyStringIsNull = Boolean.valueOf(val);
        }
        return this.emptyStringIsNull;
    }

    private boolean myIsRequired() {
        return super.isRequired() || this.isRequiredViaNestedRequiredValidator();
    }

    private boolean isRequiredViaNestedRequiredValidator() {
        boolean result = false;
        if (null == this.validators) {
            return result;
        }
        Iterator iter = this.validators.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof RequiredValidator)) continue;
            result = true;
            Object submittedValue = this.getSubmittedValue();
            if (submittedValue != null) break;
            this.setSubmittedValue("");
            break;
        }
        return result;
    }

    @Override
    public void updateModel(FacesContext context) {
        super.updateModel(context);
        if (!this.hasValueExpression() && this.isValid() && this.isLocalValueSet()) {
            context.getExternalContext().getRequestMap().put(this.getName(), this.getLocalValue());
        }
    }

    @Override
    public void encodeAll(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        this.setSubmittedValue(this.getStringValue(context));
    }

    public String getStringValue(FacesContext context) {
        String result = null;
        result = this.hasValueExpression() ? this.getStringValueFromModel(context) : (null != this.rawValue ? this.rawValue : (String)this.getValue());
        return result;
    }

    public String getStringValueFromModel(FacesContext context) throws ConverterException {
        ValueExpression ve = this.getValueExpression("value");
        if (ve == null) {
            return null;
        }
        Object currentValue = ve.getValue(context.getELContext());
        Converter c = this.getConverter();
        if (c == null) {
            if (currentValue == null) {
                return null;
            }
            if (currentValue instanceof String) {
                return (String)currentValue;
            }
            Class<?> converterType = currentValue.getClass();
            c = context.getApplication().createConverter(converterType);
            if (c == null) {
                return currentValue.toString();
            }
        }
        return c.getAsString(context, this, currentValue);
    }

    @Override
    protected Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        return this.getInputTextRenderer(context).getConvertedValue(context, this, submittedValue);
    }

    private Renderer getInputTextRenderer(FacesContext context) {
        if (null == this.inputTextRenderer) {
            RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory("jakarta.faces.render.RenderKitFactory");
            RenderKit standard = rkf.getRenderKit(context, "HTML_BASIC");
            this.inputTextRenderer = standard.getRenderer("jakarta.faces.Input", "jakarta.faces.Text");
        }
        assert (null != this.inputTextRenderer);
        return this.inputTextRenderer;
    }

    private boolean hasValueExpression() {
        return null != this.getValueExpression("value");
    }

    public static class Reference {
        private StateHolderSaver saver;
        private int indexInParent;
        private String viewIdAtTimeOfConstruction;

        public Reference(FacesContext context, UIViewParameter param, int indexInParent, String viewIdAtTimeOfConstruction) {
            this.saver = new StateHolderSaver(context, param);
            this.indexInParent = indexInParent;
            this.viewIdAtTimeOfConstruction = viewIdAtTimeOfConstruction;
        }

        public UIViewParameter getUIViewParameter(FacesContext context) {
            UIViewParameter result = null;
            UIViewRoot root = context.getViewRoot();
            if (this.viewIdAtTimeOfConstruction.equals(root.getViewId())) {
                UIComponent metadataFacet = root.getFacet("jakarta_faces_metadata");
                result = (UIViewParameter)metadataFacet.getChildren().get(this.indexInParent);
            } else {
                result = (UIViewParameter)this.saver.restore(context);
            }
            return result;
        }
    }

    static enum PropertyKeys {
        name,
        submittedValue;

    }
}

