/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.configurators.bean;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Model;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessSyntheticBean;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.cdi.tck.tests.full.extensions.configurators.bean.Bogey;
import org.jboss.cdi.tck.tests.full.extensions.configurators.bean.Dangerous;
import org.jboss.cdi.tck.tests.full.extensions.configurators.bean.DesireToHurtHumans;
import org.jboss.cdi.tck.tests.full.extensions.configurators.bean.Ghost;
import org.jboss.cdi.tck.tests.full.extensions.configurators.bean.Monster;
import org.jboss.cdi.tck.tests.full.extensions.configurators.bean.MonsterController;
import org.jboss.cdi.tck.tests.full.extensions.configurators.bean.Skeleton;
import org.jboss.cdi.tck.tests.full.extensions.configurators.bean.Undead;
import org.jboss.cdi.tck.tests.full.extensions.configurators.bean.Vampire;
import org.jboss.cdi.tck.tests.full.extensions.configurators.bean.Weapon;
import org.jboss.cdi.tck.tests.full.extensions.configurators.bean.Werewolf;
import org.jboss.cdi.tck.tests.full.extensions.configurators.bean.Zombie;

public class LifecycleObserver
implements Extension {
    private AtomicBoolean vampirePSBFired = new AtomicBoolean(false);
    private AtomicBoolean skeletonPSBFired = new AtomicBoolean(false);
    private AtomicBoolean ghostPSBFired = new AtomicBoolean(false);
    private AtomicBoolean zombiePSBFired = new AtomicBoolean(false);

    public void observeUndead(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        this.configureSkeleton(bm, (BeanConfigurator<Skeleton>)abd.addBean());
        this.configureZombie(bm, (BeanConfigurator<Zombie>)abd.addBean());
        this.configureGhost(bm, (BeanConfigurator<Ghost>)abd.addBean());
        this.configureVampire(bm, (BeanConfigurator<Vampire>)abd.addBean());
        this.configureBogey(bm, (BeanConfigurator<Bogey>)abd.addBean());
        this.configureWerewolf(bm, (BeanConfigurator<Werewolf>)abd.addBean());
    }

    private void configureSkeleton(BeanManager bm, BeanConfigurator<Skeleton> skeleton) {
        skeleton.beanClass(Skeleton.class);
        skeleton.addQualifier((Annotation)Undead.UndeadLiteral.INSTANCE);
        skeleton.addStereotype(Monster.class);
        skeleton.scope(RequestScoped.class);
        skeleton.addTransitiveTypeClosure(Skeleton.class);
        for (AnnotatedField field : bm.createAnnotatedType(Skeleton.class).getFields()) {
            if (!field.getJavaMember().getType().equals(DesireToHurtHumans.class)) continue;
            skeleton.addInjectionPoint(bm.createInjectionPoint(field));
            break;
        }
        skeleton.produceWith(MonsterController.skeletonSupplier);
        skeleton.disposeWith(MonsterController.skeletonConsumer);
    }

    private void configureZombie(BeanManager bm, BeanConfigurator<Zombie> zombie) {
        zombie.read(bm.createAnnotatedType(Zombie.class));
        zombie.beanClass(Zombie.class);
        zombie.addQualifiers(new Annotation[]{Undead.UndeadLiteral.INSTANCE, Dangerous.DangerousLiteral.INSTANCE});
        zombie.addStereotype(Monster.class);
        zombie.scope(RequestScoped.class);
        InjectionPoint zombieWeaponIP = null;
        InjectionPoint zombieDesireIP = null;
        for (AnnotatedField field : bm.createAnnotatedType(Zombie.class).getFields()) {
            if (field.getJavaMember().getType().equals(DesireToHurtHumans.class)) {
                zombieDesireIP = bm.createInjectionPoint(field);
            }
            if (!field.getJavaMember().getType().equals(Weapon.class)) continue;
            zombieWeaponIP = bm.createInjectionPoint(field);
        }
        zombie.addInjectionPoints(new InjectionPoint[]{zombieWeaponIP, zombieDesireIP});
        zombie.produceWith(MonsterController.zombieProducingFunction);
        zombie.destroyWith(MonsterController.zombieConsumer);
        zombie.id("zombie");
    }

    private void configureGhost(BeanManager bm, BeanConfigurator<Ghost> ghost) {
        ghost.read(bm.createBeanAttributes(bm.createAnnotatedType(Ghost.class)));
        ghost.beanClass(Ghost.class);
        ghost.addQualifier((Annotation)Undead.UndeadLiteral.INSTANCE);
        ghost.addStereotype(Monster.class);
        ghost.scope(RequestScoped.class);
        InjectionPoint ghostWeaponIP = null;
        InjectionPoint ghostDesireIP = null;
        for (AnnotatedField field : bm.createAnnotatedType(Ghost.class).getFields()) {
            if (field.getJavaMember().getType().equals(DesireToHurtHumans.class)) {
                ghostDesireIP = bm.createInjectionPoint(field);
            }
            if (!field.getJavaMember().getType().equals(Weapon.class)) continue;
            ghostWeaponIP = bm.createInjectionPoint(field);
        }
        ghost.addInjectionPoint(ghostWeaponIP);
        ghost.injectionPoints(new InjectionPoint[]{ghostDesireIP});
        ghost.produceWith(MonsterController.getGhostInstance);
    }

    private void configureVampire(BeanManager bm, BeanConfigurator<Vampire> vampire) {
        vampire.read(bm.createAnnotatedType(Vampire.class));
        vampire.beanClass(Vampire.class);
        vampire.addQualifier((Annotation)Undead.UndeadLiteral.INSTANCE);
        vampire.addStereotype(Monster.class);
        vampire.scope(RequestScoped.class);
        vampire.createWith(creationalContext -> {
            MonsterController.vampireInstanceCreated = true;
            AnnotatedType at = bm.createAnnotatedType(Vampire.class);
            BeanAttributes ba = bm.createBeanAttributes(at);
            return (Vampire)bm.createBean(ba, Vampire.class, bm.getInjectionTargetFactory(at)).create(creationalContext);
        });
    }

    private void configureBogey(BeanManager bm, BeanConfigurator<Bogey> bogey) {
        bogey.beanClass(Bogey.class);
        bogey.addType(Bogey.class);
        bogey.addQualifier((Annotation)Undead.UndeadLiteral.INSTANCE);
        bogey.produceWith(obj -> new Bogey());
    }

    private void configureWerewolf(BeanManager bm, BeanConfigurator<Werewolf> werewolf) {
        werewolf.beanClass(Werewolf.class);
        werewolf.addTransitiveTypeClosure(Werewolf.class);
        HashSet<Class<Model>> stereotypes = new HashSet<Class<Model>>();
        stereotypes.add(Model.class);
        werewolf.stereotypes(stereotypes);
        werewolf.produceWith(obj -> new Werewolf());
    }

    void processSkeletonBean(@Observes ProcessSyntheticBean<Skeleton> event) {
        this.skeletonPSBFired.set(true);
    }

    void processSVampireBean(@Observes ProcessSyntheticBean<Vampire> event) {
        this.vampirePSBFired.set(true);
    }

    void processZombieBean(@Observes ProcessSyntheticBean<Zombie> event) {
        this.zombiePSBFired.set(true);
    }

    void processGhostBean(@Observes ProcessSyntheticBean<Ghost> event) {
        this.ghostPSBFired.set(true);
    }

    public boolean isVampirePSBFired() {
        return this.vampirePSBFired.get();
    }

    public boolean isSkeletonPSBFired() {
        return this.skeletonPSBFired.get();
    }

    public boolean isGhostPSBFired() {
        return this.ghostPSBFired.get();
    }

    public boolean isZombiePSBFired() {
        return this.zombiePSBFired.get();
    }
}

