/*
 * Decompiled with CFR 0.152.
 */
package jakarta.security.jacc;

import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PolicyContextHandler;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class PolicyContext {
    public static final String SUBJECT = "javax.security.auth.Subject.container";
    public static final String PRINCIPAL_MAPPER = "jakarta.security.jacc.PrincipalMapper";
    public static final String HTTP_SERVLET_REQUEST = "jakarta.servlet.http.HttpServletRequest";
    public static final String SOAP_MESSAGE = "jakarta.xml.soap.SOAPMessage";
    private static ThreadLocal<String> threadLocalContextID = new ThreadLocal();
    private static ThreadLocal<Object> threadLocalHandlerData = new ThreadLocal();
    private static Map<String, PolicyContextHandler> handlerTable = new ConcurrentHashMap<String, PolicyContextHandler>();

    private PolicyContext() {
    }

    public static void setContextID(String contextID) {
        threadLocalContextID.set(contextID);
    }

    public static String getContextID() {
        return threadLocalContextID.get();
    }

    public static void setHandlerData(Object data) {
        threadLocalHandlerData.set(data);
    }

    public static void registerHandler(String key, PolicyContextHandler handler, boolean replace) throws PolicyContextException {
        if (handler == null || key == null) {
            throw new IllegalArgumentException("invalid (null) key or handler");
        }
        if (!handler.supports(key)) {
            throw new IllegalArgumentException("handler does not support key");
        }
        if (handlerTable.containsKey(key) && !replace) {
            throw new IllegalArgumentException("handler exists");
        }
        handlerTable.put(key, handler);
    }

    public static Set<String> getHandlerKeys() {
        return handlerTable.keySet();
    }

    public static <T> T getContext(String key) throws PolicyContextException {
        if (key == null) {
            throw new IllegalArgumentException("invalid key");
        }
        PolicyContextHandler handler = handlerTable.get(key);
        if (handler == null || !handler.supports(key)) {
            throw new IllegalArgumentException("unknown handler key");
        }
        Object returnValue = handler.getContext(key, threadLocalHandlerData.get());
        return (T)returnValue;
    }
}

