/*
 * Decompiled with CFR 0.152.
 */
package ja.burhanrashid52.photoeditor;

import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import ja.burhanrashid52.photoeditor.Vector2D;

class ScaleGestureDetector {
    private static final String TAG = "ScaleGestureDetector";
    private static final float PRESSURE_THRESHOLD = 0.67f;
    private final OnScaleGestureListener mListener;
    private boolean mGestureInProgress;
    private MotionEvent mPrevEvent;
    private MotionEvent mCurrEvent;
    private Vector2D mCurrSpanVector;
    private float mFocusX;
    private float mFocusY;
    private float mPrevFingerDiffX;
    private float mPrevFingerDiffY;
    private float mCurrFingerDiffX;
    private float mCurrFingerDiffY;
    private float mCurrLen;
    private float mPrevLen;
    private float mScaleFactor;
    private float mCurrPressure;
    private float mPrevPressure;
    private long mTimeDelta;
    private boolean mInvalidGesture;
    private int mActiveId0;
    private int mActiveId1;
    private boolean mActive0MostRecent;

    ScaleGestureDetector(OnScaleGestureListener listener) {
        this.mListener = listener;
        this.mCurrSpanVector = new Vector2D();
    }

    boolean onTouchEvent(View view, MotionEvent event) {
        int action = event.getActionMasked();
        if (action == 0) {
            this.reset();
        }
        boolean handled = true;
        if (this.mInvalidGesture) {
            handled = false;
        } else if (!this.mGestureInProgress) {
            switch (action) {
                case 0: {
                    this.mActiveId0 = event.getPointerId(0);
                    this.mActive0MostRecent = true;
                    break;
                }
                case 1: {
                    this.reset();
                    break;
                }
                case 5: {
                    if (this.mPrevEvent != null) {
                        this.mPrevEvent.recycle();
                    }
                    this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                    this.mTimeDelta = 0L;
                    int index1 = event.getActionIndex();
                    int index0 = event.findPointerIndex(this.mActiveId0);
                    this.mActiveId1 = event.getPointerId(index1);
                    if (index0 < 0 || index0 == index1) {
                        index0 = this.findNewActiveIndex(event, this.mActiveId1, -1);
                        this.mActiveId0 = event.getPointerId(index0);
                    }
                    this.mActive0MostRecent = false;
                    this.setContext(view, event);
                    this.mGestureInProgress = this.mListener.onScaleBegin(view, this);
                    break;
                }
            }
        } else {
            switch (action) {
                case 5: {
                    this.mListener.onScaleEnd(view, this);
                    int oldActive0 = this.mActiveId0;
                    int oldActive1 = this.mActiveId1;
                    this.reset();
                    this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                    this.mActiveId0 = this.mActive0MostRecent ? oldActive0 : oldActive1;
                    this.mActiveId1 = event.getPointerId(event.getActionIndex());
                    this.mActive0MostRecent = false;
                    int index0 = event.findPointerIndex(this.mActiveId0);
                    if (index0 < 0 || this.mActiveId0 == this.mActiveId1) {
                        index0 = this.findNewActiveIndex(event, this.mActiveId1, -1);
                        this.mActiveId0 = event.getPointerId(index0);
                    }
                    this.setContext(view, event);
                    this.mGestureInProgress = this.mListener.onScaleBegin(view, this);
                    break;
                }
                case 6: {
                    int pointerCount = event.getPointerCount();
                    int actionIndex = event.getActionIndex();
                    int actionId = event.getPointerId(actionIndex);
                    boolean gestureEnded = false;
                    if (pointerCount > 2) {
                        int newIndex;
                        if (actionId == this.mActiveId0) {
                            newIndex = this.findNewActiveIndex(event, this.mActiveId1, actionIndex);
                            if (newIndex >= 0) {
                                this.mListener.onScaleEnd(view, this);
                                this.mActiveId0 = event.getPointerId(newIndex);
                                this.mActive0MostRecent = true;
                                this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                                this.setContext(view, event);
                                this.mGestureInProgress = this.mListener.onScaleBegin(view, this);
                            } else {
                                gestureEnded = true;
                            }
                        } else if (actionId == this.mActiveId1) {
                            newIndex = this.findNewActiveIndex(event, this.mActiveId0, actionIndex);
                            if (newIndex >= 0) {
                                this.mListener.onScaleEnd(view, this);
                                this.mActiveId1 = event.getPointerId(newIndex);
                                this.mActive0MostRecent = false;
                                this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                                this.setContext(view, event);
                                this.mGestureInProgress = this.mListener.onScaleBegin(view, this);
                            } else {
                                gestureEnded = true;
                            }
                        }
                        this.mPrevEvent.recycle();
                        this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                        this.setContext(view, event);
                    } else {
                        gestureEnded = true;
                    }
                    if (!gestureEnded) break;
                    this.setContext(view, event);
                    int activeId = actionId == this.mActiveId0 ? this.mActiveId1 : this.mActiveId0;
                    int index = event.findPointerIndex(activeId);
                    this.mFocusX = event.getX(index);
                    this.mFocusY = event.getY(index);
                    this.mListener.onScaleEnd(view, this);
                    this.reset();
                    this.mActiveId0 = activeId;
                    this.mActive0MostRecent = true;
                    break;
                }
                case 3: {
                    this.mListener.onScaleEnd(view, this);
                    this.reset();
                    break;
                }
                case 1: {
                    this.reset();
                    break;
                }
                case 2: {
                    boolean updatePrevious;
                    this.setContext(view, event);
                    if (!(this.mCurrPressure / this.mPrevPressure > 0.67f) || !(updatePrevious = this.mListener.onScale(view, this))) break;
                    this.mPrevEvent.recycle();
                    this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                }
            }
        }
        return handled;
    }

    private int findNewActiveIndex(MotionEvent ev, int otherActiveId, int removedPointerIndex) {
        int pointerCount = ev.getPointerCount();
        int otherActiveIndex = ev.findPointerIndex(otherActiveId);
        for (int i = 0; i < pointerCount; ++i) {
            if (i == removedPointerIndex || i == otherActiveIndex) continue;
            return i;
        }
        return -1;
    }

    private void setContext(View view, MotionEvent curr) {
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
        }
        this.mCurrEvent = MotionEvent.obtain((MotionEvent)curr);
        this.mCurrLen = -1.0f;
        this.mPrevLen = -1.0f;
        this.mScaleFactor = -1.0f;
        this.mCurrSpanVector.set(0.0f, 0.0f);
        MotionEvent prev = this.mPrevEvent;
        int prevIndex0 = prev.findPointerIndex(this.mActiveId0);
        int prevIndex1 = prev.findPointerIndex(this.mActiveId1);
        int currIndex0 = curr.findPointerIndex(this.mActiveId0);
        int currIndex1 = curr.findPointerIndex(this.mActiveId1);
        if (prevIndex0 < 0 || prevIndex1 < 0 || currIndex0 < 0 || currIndex1 < 0) {
            this.mInvalidGesture = true;
            Log.e((String)TAG, (String)"Invalid MotionEvent stream detected.", (Throwable)new Throwable());
            if (this.mGestureInProgress) {
                this.mListener.onScaleEnd(view, this);
            }
            return;
        }
        float px0 = prev.getX(prevIndex0);
        float py0 = prev.getY(prevIndex0);
        float px1 = prev.getX(prevIndex1);
        float py1 = prev.getY(prevIndex1);
        float cx0 = curr.getX(currIndex0);
        float cy0 = curr.getY(currIndex0);
        float cx1 = curr.getX(currIndex1);
        float cy1 = curr.getY(currIndex1);
        float pvx = px1 - px0;
        float pvy = py1 - py0;
        float cvx = cx1 - cx0;
        float cvy = cy1 - cy0;
        this.mCurrSpanVector.set(cvx, cvy);
        this.mPrevFingerDiffX = pvx;
        this.mPrevFingerDiffY = pvy;
        this.mCurrFingerDiffX = cvx;
        this.mCurrFingerDiffY = cvy;
        this.mFocusX = cx0 + cvx * 0.5f;
        this.mFocusY = cy0 + cvy * 0.5f;
        this.mTimeDelta = curr.getEventTime() - prev.getEventTime();
        this.mCurrPressure = curr.getPressure(currIndex0) + curr.getPressure(currIndex1);
        this.mPrevPressure = prev.getPressure(prevIndex0) + prev.getPressure(prevIndex1);
    }

    private void reset() {
        if (this.mPrevEvent != null) {
            this.mPrevEvent.recycle();
            this.mPrevEvent = null;
        }
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
        this.mGestureInProgress = false;
        this.mActiveId0 = -1;
        this.mActiveId1 = -1;
        this.mInvalidGesture = false;
    }

    boolean isInProgress() {
        return this.mGestureInProgress;
    }

    float getFocusX() {
        return this.mFocusX;
    }

    float getFocusY() {
        return this.mFocusY;
    }

    private float getCurrentSpan() {
        if (this.mCurrLen == -1.0f) {
            float cvx = this.mCurrFingerDiffX;
            float cvy = this.mCurrFingerDiffY;
            this.mCurrLen = (float)Math.sqrt(cvx * cvx + cvy * cvy);
        }
        return this.mCurrLen;
    }

    Vector2D getCurrentSpanVector() {
        return this.mCurrSpanVector;
    }

    public float getCurrentSpanX() {
        return this.mCurrFingerDiffX;
    }

    public float getCurrentSpanY() {
        return this.mCurrFingerDiffY;
    }

    private float getPreviousSpan() {
        if (this.mPrevLen == -1.0f) {
            float pvx = this.mPrevFingerDiffX;
            float pvy = this.mPrevFingerDiffY;
            this.mPrevLen = (float)Math.sqrt(pvx * pvx + pvy * pvy);
        }
        return this.mPrevLen;
    }

    public float getPreviousSpanX() {
        return this.mPrevFingerDiffX;
    }

    public float getPreviousSpanY() {
        return this.mPrevFingerDiffY;
    }

    public float getScaleFactor() {
        if (this.mScaleFactor == -1.0f) {
            this.mScaleFactor = this.getCurrentSpan() / this.getPreviousSpan();
        }
        return this.mScaleFactor;
    }

    public long getTimeDelta() {
        return this.mTimeDelta;
    }

    public long getEventTime() {
        return this.mCurrEvent.getEventTime();
    }

    static class SimpleOnScaleGestureListener
    implements OnScaleGestureListener {
        SimpleOnScaleGestureListener() {
        }

        @Override
        public boolean onScale(View view, ScaleGestureDetector detector) {
            return false;
        }

        @Override
        public boolean onScaleBegin(View view, ScaleGestureDetector detector) {
            return true;
        }

        @Override
        public void onScaleEnd(View view, ScaleGestureDetector detector) {
        }
    }

    static interface OnScaleGestureListener {
        public boolean onScale(View var1, ScaleGestureDetector var2);

        public boolean onScaleBegin(View var1, ScaleGestureDetector var2);

        public void onScaleEnd(View var1, ScaleGestureDetector var2);
    }
}

