/*
 * Decompiled with CFR 0.152.
 */
package ja.burhanrashid52.photoeditor;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.RequiresPermission;
import android.support.annotation.UiThread;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import ja.burhanrashid52.photoeditor.BrushDrawingView;
import ja.burhanrashid52.photoeditor.BrushViewChangeListener;
import ja.burhanrashid52.photoeditor.MultiTouchListener;
import ja.burhanrashid52.photoeditor.OnPhotoEditorListener;
import ja.burhanrashid52.photoeditor.PhotoEditorView;
import ja.burhanrashid52.photoeditor.R;
import ja.burhanrashid52.photoeditor.ViewType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PhotoEditor
implements MultiTouchListener.OnMultiTouchListener,
BrushViewChangeListener {
    private static final String TAG = PhotoEditor.class.getSimpleName();
    private Context context;
    private RelativeLayout parentView;
    private ImageView imageView;
    private View deleteView;
    private BrushDrawingView brushDrawingView;
    private List<View> addedViews;
    private List<View> redoViews;
    private OnPhotoEditorListener mOnPhotoEditorListener;
    private boolean isTextPinchZoomable;
    private boolean mIsBackground = false;

    private PhotoEditor(Builder builder) {
        this.context = builder.context;
        this.parentView = builder.parentView;
        this.imageView = builder.imageView;
        this.deleteView = builder.deleteView;
        this.brushDrawingView = builder.brushDrawingView;
        this.isTextPinchZoomable = builder.isTextPinchZoomable;
        this.brushDrawingView.setBrushViewChangeListener(this);
        this.addedViews = new ArrayList<View>();
        this.redoViews = new ArrayList<View>();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void addText(String text, int colorCodeTextView) {
        this.mIsBackground = true;
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        final View addTextRootView = inflater.inflate(R.layout.photo_editor_sdk_text_item_list, null);
        final TextView textInputTv = (TextView)addTextRootView.findViewById(R.id.photo_editor_sdk_text_tv);
        final ImageView imgClose = (ImageView)addTextRootView.findViewById(R.id.imgClose);
        imgClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoEditor.this.viewUndo(addTextRootView);
            }
        });
        textInputTv.setGravity(17);
        textInputTv.setText((CharSequence)text);
        textInputTv.setTextColor(colorCodeTextView);
        MultiTouchListener multiTouchListener = new MultiTouchListener(this.deleteView, this.parentView, this.imageView, this.isTextPinchZoomable, this.mOnPhotoEditorListener);
        multiTouchListener.setOnMultiTouchListener(this);
        textInputTv.setBackgroundResource(R.drawable.rounded_border_tv);
        multiTouchListener.setOnGestureControl(new MultiTouchListener.OnGestureControl(){

            @Override
            public void onClick() {
                textInputTv.setBackgroundResource(PhotoEditor.this.mIsBackground ? 0 : R.drawable.rounded_border_tv);
                imgClose.setVisibility(PhotoEditor.this.mIsBackground ? 8 : 0);
                PhotoEditor.this.mIsBackground = !PhotoEditor.this.mIsBackground;
            }

            @Override
            public void onLongClick() {
                String textInput = textInputTv.getText().toString();
                int currentTextColor = textInputTv.getCurrentTextColor();
                if (PhotoEditor.this.mOnPhotoEditorListener != null) {
                    PhotoEditor.this.mOnPhotoEditorListener.onEditTextChangeListener(addTextRootView, textInput, currentTextColor);
                }
            }
        });
        addTextRootView.setOnTouchListener((View.OnTouchListener)multiTouchListener);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13, -1);
        this.parentView.addView(addTextRootView, (ViewGroup.LayoutParams)params);
        this.addedViews.add(addTextRootView);
        if (this.mOnPhotoEditorListener != null) {
            this.mOnPhotoEditorListener.onAddViewListener(ViewType.TEXT, this.addedViews.size());
        }
    }

    public void editText(View view, String inputText, int colorCode) {
        TextView inputTextView = (TextView)view.findViewById(R.id.photo_editor_sdk_text_tv);
        if (inputTextView != null && this.addedViews.contains(view)) {
            inputTextView.setText((CharSequence)inputText);
            inputTextView.setTextColor(colorCode);
            this.parentView.updateViewLayout(view, view.getLayoutParams());
            int i = this.addedViews.indexOf(view);
            if (i > -1) {
                this.addedViews.set(i, view);
            }
        }
    }

    public void setBrushDrawingMode(boolean brushDrawingMode) {
        if (this.brushDrawingView != null) {
            this.brushDrawingView.setBrushDrawingMode(brushDrawingMode);
        }
    }

    public Boolean getBrushDrawableMode() {
        return this.brushDrawingView != null && this.brushDrawingView.getBrushDrawingMode();
    }

    public void setBrushSize(float size) {
        if (this.brushDrawingView != null) {
            this.brushDrawingView.setBrushSize(size);
        }
    }

    public void setOpacity(@IntRange(from=0L, to=100L) int opacity) {
        if (this.brushDrawingView != null) {
            opacity = (int)((double)opacity / 100.0 * 255.0);
            this.brushDrawingView.setOpacity(opacity);
        }
    }

    public void setBrushColor(@ColorInt int color) {
        if (this.brushDrawingView != null) {
            this.brushDrawingView.setBrushColor(color);
        }
    }

    public void setBrushEraserSize(float brushEraserSize) {
        if (this.brushDrawingView != null) {
            this.brushDrawingView.setBrushEraserSize(brushEraserSize);
        }
    }

    public void setBrushEraserColor(@ColorInt int color) {
        if (this.brushDrawingView != null) {
            this.brushDrawingView.setBrushEraserColor(color);
        }
    }

    public float getEraserSize() {
        return this.brushDrawingView != null ? this.brushDrawingView.getEraserSize() : 0.0f;
    }

    public float getBrushSize() {
        if (this.brushDrawingView != null) {
            return this.brushDrawingView.getBrushSize();
        }
        return 0.0f;
    }

    public int getBrushColor() {
        if (this.brushDrawingView != null) {
            return this.brushDrawingView.getBrushColor();
        }
        return 0;
    }

    public void brushEraser() {
        if (this.brushDrawingView != null) {
            this.brushDrawingView.brushEraser();
        }
    }

    public void viewUndo() {
        if (this.addedViews.size() > 0) {
            this.parentView.removeView(this.addedViews.remove(this.addedViews.size() - 1));
            if (this.mOnPhotoEditorListener != null) {
                this.mOnPhotoEditorListener.onRemoveViewListener(this.addedViews.size());
            }
        }
    }

    private void viewUndo(View removedView) {
        if (this.addedViews.size() > 0 && this.addedViews.contains(removedView)) {
            this.parentView.removeView(removedView);
            this.addedViews.remove(removedView);
            this.redoViews.add(removedView);
            if (this.mOnPhotoEditorListener != null) {
                this.mOnPhotoEditorListener.onRemoveViewListener(this.addedViews.size());
            }
        }
    }

    public boolean undo() {
        if (this.addedViews.size() > 0) {
            View removeView = this.addedViews.get(this.addedViews.size() - 1);
            if (removeView instanceof BrushDrawingView) {
                return this.brushDrawingView != null && this.brushDrawingView.undo();
            }
            this.addedViews.remove(this.addedViews.size() - 1);
            this.parentView.removeView(removeView);
            this.redoViews.add(removeView);
            if (this.mOnPhotoEditorListener != null) {
                this.mOnPhotoEditorListener.onRemoveViewListener(this.addedViews.size());
            }
        }
        return this.addedViews.size() != 0;
    }

    public boolean redo() {
        if (this.redoViews.size() > 0) {
            View redoView = this.redoViews.get(this.redoViews.size() - 1);
            if (redoView instanceof BrushDrawingView) {
                return this.brushDrawingView != null && this.brushDrawingView.redo();
            }
            this.redoViews.remove(this.redoViews.size() - 1);
            this.parentView.addView(redoView);
            this.addedViews.add(redoView);
        }
        return this.redoViews.size() != 0;
    }

    private void clearBrushAllViews() {
        if (this.brushDrawingView != null) {
            this.brushDrawingView.clearAll();
        }
    }

    public void clearAllViews() {
        for (int i = 0; i < this.addedViews.size(); ++i) {
            this.parentView.removeView(this.addedViews.get(i));
        }
        if (this.addedViews.contains((Object)this.brushDrawingView)) {
            this.parentView.addView((View)this.brushDrawingView);
        }
        this.addedViews.clear();
        this.redoViews.clear();
        this.clearBrushAllViews();
    }

    @UiThread
    private void clearTextHelperBox() {
        for (int i = 0; i < this.parentView.getChildCount(); ++i) {
            ImageView imgClose;
            View childAt = this.parentView.getChildAt(i);
            TextView txtInput = (TextView)childAt.findViewById(R.id.photo_editor_sdk_text_tv);
            if (txtInput != null) {
                txtInput.setBackgroundResource(0);
            }
            if ((imgClose = (ImageView)childAt.findViewById(R.id.imgClose)) == null) continue;
            imgClose.setVisibility(8);
        }
    }

    @RequiresPermission(allOf={"android.permission.WRITE_EXTERNAL_STORAGE"})
    public void saveImage(String imagePath) {
        Log.d((String)TAG, (String)("Image Path: " + imagePath));
        this.clearTextHelperBox();
        this.parentView.setDrawingCacheEnabled(false);
        File file = new File(imagePath);
        try {
            FileOutputStream out = new FileOutputStream(file, false);
            if (this.parentView != null) {
                this.parentView.setDrawingCacheEnabled(true);
                Bitmap drawingCache = this.parentView.getDrawingCache();
                drawingCache.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
            }
            out.flush();
            out.close();
            Log.d((String)TAG, (String)"Filed Saved Successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)TAG, (String)"Failed to save File");
        }
    }

    private boolean isSDCARDMounted() {
        String status = Environment.getExternalStorageState();
        return status.equals("mounted");
    }

    private String convertEmoji(String emoji) {
        String returnedEmoji;
        try {
            int convertEmojiToInt = Integer.parseInt(emoji.substring(2), 16);
            returnedEmoji = this.getEmojiByUnicode(convertEmojiToInt);
        }
        catch (NumberFormatException e) {
            returnedEmoji = "";
        }
        return returnedEmoji;
    }

    private String getEmojiByUnicode(int unicode) {
        return new String(Character.toChars(unicode));
    }

    public void setOnPhotoEditorListener(OnPhotoEditorListener onPhotoEditorListener) {
        this.mOnPhotoEditorListener = onPhotoEditorListener;
    }

    public boolean isCacheEmpty() {
        return this.addedViews.size() == 0 && this.redoViews.size() == 0;
    }

    @Override
    public void onEditTextClickListener(String text, int colorCode) {
    }

    @Override
    public void onRemoveViewListener(View removedView) {
    }

    @Override
    public void onViewAdd(BrushDrawingView brushDrawingView) {
        if (this.redoViews.size() > 0) {
            this.redoViews.remove(this.redoViews.size() - 1);
        }
        this.addedViews.add(brushDrawingView);
        if (this.mOnPhotoEditorListener != null) {
            this.mOnPhotoEditorListener.onAddViewListener(ViewType.BRUSH_DRAWING, this.addedViews.size());
        }
    }

    @Override
    public void onViewRemoved(BrushDrawingView brushDrawingView) {
        if (this.addedViews.size() > 0) {
            View removeView = this.addedViews.remove(this.addedViews.size() - 1);
            if (!(removeView instanceof BrushDrawingView)) {
                this.parentView.removeView(removeView);
            }
            this.redoViews.add(removeView);
        }
        if (this.mOnPhotoEditorListener != null) {
            this.mOnPhotoEditorListener.onRemoveViewListener(this.addedViews.size());
        }
    }

    public static class Builder {
        private Context context;
        private RelativeLayout parentView;
        private ImageView imageView;
        private View deleteView;
        private BrushDrawingView brushDrawingView;
        private boolean isTextPinchZoomable = true;

        public Builder(Context context, PhotoEditorView photoEditorView) {
            this.context = context;
            this.parentView = photoEditorView.getParentLayout();
            this.imageView = photoEditorView.getImageSource();
            this.brushDrawingView = photoEditorView.getBrushDrawingView();
        }

        Builder setParentView(RelativeLayout parentView) {
            this.parentView = parentView;
            return this;
        }

        Builder setChildView(ImageView imageView) {
            this.imageView = imageView;
            return this;
        }

        public Builder setDeleteView(View deleteView) {
            this.deleteView = deleteView;
            return this;
        }

        public Builder setPinchTextScalable(boolean isTextPinchZoomable) {
            this.isTextPinchZoomable = isTextPinchZoomable;
            return this;
        }

        Builder setBrushDrawingView(BrushDrawingView brushDrawingView) {
            this.brushDrawingView = brushDrawingView;
            return this;
        }

        public PhotoEditor build() {
            return new PhotoEditor(this);
        }
    }
}

