/*
 * Decompiled with CFR 0.152.
 */
package ja.burhanrashid52.photoeditor;

import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import ja.burhanrashid52.photoeditor.OnPhotoEditorListener;
import ja.burhanrashid52.photoeditor.ScaleGestureDetector;
import ja.burhanrashid52.photoeditor.Vector2D;
import ja.burhanrashid52.photoeditor.ViewType;

class MultiTouchListener
implements View.OnTouchListener {
    private static final int INVALID_POINTER_ID = -1;
    private final GestureDetector mGestureListener;
    private boolean isRotateEnabled = true;
    private boolean isTranslateEnabled = true;
    private boolean isScaleEnabled = true;
    private float minimumScale = 0.5f;
    private float maximumScale = 10.0f;
    private int mActivePointerId = -1;
    private float mPrevX;
    private float mPrevY;
    private float mPrevRawX;
    private float mPrevRawY;
    private ScaleGestureDetector mScaleGestureDetector;
    private int[] location = new int[2];
    private Rect outRect;
    private View deleteView;
    private ImageView photoEditImageView;
    private RelativeLayout parentView;
    private OnMultiTouchListener onMultiTouchListener;
    private OnGestureControl mOnGestureControl;
    private boolean mIsTextPinchZoomable;
    private OnPhotoEditorListener mOnPhotoEditorListener;

    MultiTouchListener(@Nullable View deleteView, RelativeLayout parentView, ImageView photoEditImageView, boolean isTextPinchZoomable, OnPhotoEditorListener onPhotoEditorListener) {
        this.mIsTextPinchZoomable = isTextPinchZoomable;
        this.mScaleGestureDetector = new ScaleGestureDetector(new ScaleGestureListener());
        this.mGestureListener = new GestureDetector((GestureDetector.OnGestureListener)new GestureListener());
        this.deleteView = deleteView;
        this.parentView = parentView;
        this.photoEditImageView = photoEditImageView;
        this.mOnPhotoEditorListener = onPhotoEditorListener;
        this.outRect = deleteView != null ? new Rect(deleteView.getLeft(), deleteView.getTop(), deleteView.getRight(), deleteView.getBottom()) : new Rect(0, 0, 0, 0);
    }

    private static float adjustAngle(float degrees) {
        if (degrees > 180.0f) {
            degrees -= 360.0f;
        } else if (degrees < -180.0f) {
            degrees += 360.0f;
        }
        return degrees;
    }

    private static void move(View view, TransformInfo info) {
        MultiTouchListener.computeRenderOffset(view, info.pivotX, info.pivotY);
        MultiTouchListener.adjustTranslation(view, info.deltaX, info.deltaY);
        float scale = view.getScaleX() * info.deltaScale;
        scale = Math.max(info.minimumScale, Math.min(info.maximumScale, scale));
        view.setScaleX(scale);
        view.setScaleY(scale);
        float rotation = MultiTouchListener.adjustAngle(view.getRotation() + info.deltaAngle);
        view.setRotation(rotation);
    }

    private static void adjustTranslation(View view, float deltaX, float deltaY) {
        float[] deltaVector = new float[]{deltaX, deltaY};
        view.getMatrix().mapVectors(deltaVector);
        view.setTranslationX(view.getTranslationX() + deltaVector[0]);
        view.setTranslationY(view.getTranslationY() + deltaVector[1]);
    }

    private static void computeRenderOffset(View view, float pivotX, float pivotY) {
        if (view.getPivotX() == pivotX && view.getPivotY() == pivotY) {
            return;
        }
        float[] prevPoint = new float[]{0.0f, 0.0f};
        view.getMatrix().mapPoints(prevPoint);
        view.setPivotX(pivotX);
        view.setPivotY(pivotY);
        float[] currPoint = new float[]{0.0f, 0.0f};
        view.getMatrix().mapPoints(currPoint);
        float offsetX = currPoint[0] - prevPoint[0];
        float offsetY = currPoint[1] - prevPoint[1];
        view.setTranslationX(view.getTranslationX() - offsetX);
        view.setTranslationY(view.getTranslationY() - offsetY);
    }

    public boolean onTouch(View view, MotionEvent event) {
        this.mScaleGestureDetector.onTouchEvent(view, event);
        this.mGestureListener.onTouchEvent(event);
        if (!this.isTranslateEnabled) {
            return true;
        }
        int action = event.getAction();
        int x = (int)event.getRawX();
        int y = (int)event.getRawY();
        switch (action & event.getActionMasked()) {
            case 0: {
                this.mPrevX = event.getX();
                this.mPrevY = event.getY();
                this.mPrevRawX = event.getRawX();
                this.mPrevRawY = event.getRawY();
                this.mActivePointerId = event.getPointerId(0);
                if (this.deleteView != null) {
                    this.deleteView.setVisibility(0);
                }
                view.bringToFront();
                this.firePhotoEditorSDKListener(view, true);
                break;
            }
            case 2: {
                int pointerIndexMove = event.findPointerIndex(this.mActivePointerId);
                if (pointerIndexMove == -1) break;
                float currX = event.getX(pointerIndexMove);
                float currY = event.getY(pointerIndexMove);
                if (this.mScaleGestureDetector.isInProgress()) break;
                MultiTouchListener.adjustTranslation(view, currX - this.mPrevX, currY - this.mPrevY);
                break;
            }
            case 3: {
                this.mActivePointerId = -1;
                break;
            }
            case 1: {
                this.mActivePointerId = -1;
                if (this.deleteView != null && this.isViewInBounds(this.deleteView, x, y)) {
                    if (this.onMultiTouchListener != null) {
                        this.onMultiTouchListener.onRemoveViewListener(view);
                    }
                } else if (!this.isViewInBounds((View)this.photoEditImageView, x, y)) {
                    view.animate().translationY(0.0f).translationY(0.0f);
                }
                if (this.deleteView != null) {
                    this.deleteView.setVisibility(8);
                }
                this.firePhotoEditorSDKListener(view, false);
                break;
            }
            case 6: {
                int pointerIndexPointerUp = (action & 0xFF00) >> 8;
                int pointerId = event.getPointerId(pointerIndexPointerUp);
                if (pointerId != this.mActivePointerId) break;
                int newPointerIndex = pointerIndexPointerUp == 0 ? 1 : 0;
                this.mPrevX = event.getX(newPointerIndex);
                this.mPrevY = event.getY(newPointerIndex);
                this.mActivePointerId = event.getPointerId(newPointerIndex);
            }
        }
        return true;
    }

    private void firePhotoEditorSDKListener(View view, boolean isStart) {
        if (view instanceof TextView) {
            if (this.onMultiTouchListener != null) {
                if (this.mOnPhotoEditorListener != null) {
                    if (isStart) {
                        this.mOnPhotoEditorListener.onStartViewChangeListener(ViewType.TEXT);
                    } else {
                        this.mOnPhotoEditorListener.onStopViewChangeListener(ViewType.TEXT);
                    }
                }
            } else if (this.mOnPhotoEditorListener != null) {
                if (isStart) {
                    this.mOnPhotoEditorListener.onStartViewChangeListener(ViewType.EMOJI);
                } else {
                    this.mOnPhotoEditorListener.onStopViewChangeListener(ViewType.EMOJI);
                }
            }
        } else if (this.mOnPhotoEditorListener != null) {
            if (isStart) {
                this.mOnPhotoEditorListener.onStartViewChangeListener(ViewType.IMAGE);
            } else {
                this.mOnPhotoEditorListener.onStopViewChangeListener(ViewType.IMAGE);
            }
        }
    }

    private boolean isViewInBounds(View view, int x, int y) {
        view.getDrawingRect(this.outRect);
        view.getLocationOnScreen(this.location);
        this.outRect.offset(this.location[0], this.location[1]);
        return this.outRect.contains(x, y);
    }

    void setOnMultiTouchListener(OnMultiTouchListener onMultiTouchListener) {
        this.onMultiTouchListener = onMultiTouchListener;
    }

    void setOnGestureControl(OnGestureControl onGestureControl) {
        this.mOnGestureControl = onGestureControl;
    }

    private final class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            if (MultiTouchListener.this.mOnGestureControl != null) {
                MultiTouchListener.this.mOnGestureControl.onClick();
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
            super.onLongPress(e);
            if (MultiTouchListener.this.mOnGestureControl != null) {
                MultiTouchListener.this.mOnGestureControl.onLongClick();
            }
        }
    }

    static interface OnGestureControl {
        public void onClick();

        public void onLongClick();
    }

    static interface OnMultiTouchListener {
        public void onEditTextClickListener(String var1, int var2);

        public void onRemoveViewListener(View var1);
    }

    private class TransformInfo {
        float deltaX;
        float deltaY;
        float deltaScale;
        float deltaAngle;
        float pivotX;
        float pivotY;
        float minimumScale;
        float maximumScale;

        private TransformInfo() {
        }
    }

    private class ScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private float mPivotX;
        private float mPivotY;
        private Vector2D mPrevSpanVector = new Vector2D();

        private ScaleGestureListener() {
        }

        @Override
        public boolean onScaleBegin(View view, ScaleGestureDetector detector) {
            this.mPivotX = detector.getFocusX();
            this.mPivotY = detector.getFocusY();
            this.mPrevSpanVector.set(detector.getCurrentSpanVector());
            return MultiTouchListener.this.mIsTextPinchZoomable;
        }

        @Override
        public boolean onScale(View view, ScaleGestureDetector detector) {
            TransformInfo info = new TransformInfo();
            info.deltaScale = MultiTouchListener.this.isScaleEnabled ? detector.getScaleFactor() : 1.0f;
            info.deltaAngle = MultiTouchListener.this.isRotateEnabled ? Vector2D.getAngle(this.mPrevSpanVector, detector.getCurrentSpanVector()) : 0.0f;
            info.deltaX = MultiTouchListener.this.isTranslateEnabled ? detector.getFocusX() - this.mPivotX : 0.0f;
            info.deltaY = MultiTouchListener.this.isTranslateEnabled ? detector.getFocusY() - this.mPivotY : 0.0f;
            info.pivotX = this.mPivotX;
            info.pivotY = this.mPivotY;
            info.minimumScale = MultiTouchListener.this.minimumScale;
            info.maximumScale = MultiTouchListener.this.maximumScale;
            MultiTouchListener.move(view, info);
            return !MultiTouchListener.this.mIsTextPinchZoomable;
        }
    }
}

