/*
 * Decompiled with CFR 0.152.
 */
package ja.burhanrashid52.photoeditor;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import ja.burhanrashid52.photoeditor.BrushViewChangeListener;
import java.util.ArrayList;
import java.util.List;

public class BrushDrawingView
extends View {
    private float mBrushSize = 10.0f;
    private float mBrushEraserSize = 50.0f;
    private int mOpacity = 255;
    private List<LinePath> mLinePaths = new ArrayList<LinePath>();
    private List<LinePath> mRedoLinePaths = new ArrayList<LinePath>();
    private Paint mDrawPaint;
    private Canvas mDrawCanvas;
    private boolean mBrushDrawMode;
    private Path mPath;
    private float mTouchX;
    private float mTouchY;
    private static final float TOUCH_TOLERANCE = 4.0f;
    private BrushViewChangeListener mBrushViewChangeListener;

    public BrushDrawingView(Context context) {
        this(context, null);
    }

    public BrushDrawingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupBrushDrawing();
    }

    public BrushDrawingView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setupBrushDrawing();
    }

    void setupBrushDrawing() {
        this.setLayerType(2, null);
        this.mDrawPaint = new Paint();
        this.mPath = new Path();
        this.mDrawPaint.setAntiAlias(true);
        this.mDrawPaint.setDither(true);
        this.mDrawPaint.setColor(-16777216);
        this.mDrawPaint.setStyle(Paint.Style.STROKE);
        this.mDrawPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mDrawPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mDrawPaint.setStrokeWidth(this.mBrushSize);
        this.mDrawPaint.setAlpha(this.mOpacity);
        this.mDrawPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DARKEN));
        this.setVisibility(8);
    }

    private void refreshBrushDrawing() {
        this.mBrushDrawMode = true;
        this.mPath = new Path();
        this.mDrawPaint.setAntiAlias(true);
        this.mDrawPaint.setDither(true);
        this.mDrawPaint.setStyle(Paint.Style.STROKE);
        this.mDrawPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mDrawPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mDrawPaint.setStrokeWidth(this.mBrushSize);
        this.mDrawPaint.setAlpha(this.mOpacity);
        this.mDrawPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DARKEN));
    }

    void brushEraser() {
        this.mDrawPaint.setStrokeWidth(this.mBrushEraserSize);
        this.mDrawPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
    }

    void setBrushDrawingMode(boolean brushDrawMode) {
        this.mBrushDrawMode = brushDrawMode;
        if (brushDrawMode) {
            this.setVisibility(0);
            this.refreshBrushDrawing();
        }
    }

    void setOpacity(@IntRange(from=0L, to=255L) int opacity) {
        this.mOpacity = opacity;
        if (this.mBrushDrawMode) {
            this.setVisibility(0);
            this.refreshBrushDrawing();
        }
    }

    boolean getBrushDrawingMode() {
        return this.mBrushDrawMode;
    }

    void setBrushSize(float size) {
        this.mBrushSize = size;
        this.refreshBrushDrawing();
    }

    void setBrushColor(@ColorInt int color) {
        this.mDrawPaint.setColor(color);
        this.refreshBrushDrawing();
    }

    void setBrushEraserSize(float brushEraserSize) {
        this.mBrushEraserSize = brushEraserSize;
    }

    void setBrushEraserColor(@ColorInt int color) {
        this.mDrawPaint.setColor(color);
        this.refreshBrushDrawing();
    }

    float getEraserSize() {
        return this.mBrushEraserSize;
    }

    float getBrushSize() {
        return this.mBrushSize;
    }

    int getBrushColor() {
        return this.mDrawPaint.getColor();
    }

    void clearAll() {
        this.mLinePaths.clear();
        this.mRedoLinePaths.clear();
        if (this.mDrawCanvas != null) {
            this.mDrawCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        this.invalidate();
    }

    public void setBrushViewChangeListener(BrushViewChangeListener brushViewChangeListener) {
        this.mBrushViewChangeListener = brushViewChangeListener;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        Bitmap canvasBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mDrawCanvas = new Canvas(canvasBitmap);
    }

    protected void onDraw(Canvas canvas) {
        for (LinePath linePath : this.mLinePaths) {
            canvas.drawPath(linePath.getDrawPath(), linePath.getDrawPaint());
        }
        canvas.drawPath(this.mPath, this.mDrawPaint);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.mBrushDrawMode) {
            float touchX = event.getX();
            float touchY = event.getY();
            switch (event.getAction()) {
                case 0: {
                    this.touchStart(touchX, touchY);
                    break;
                }
                case 2: {
                    this.touchMove(touchX, touchY);
                    break;
                }
                case 1: {
                    this.touchUp();
                }
            }
            this.invalidate();
            return true;
        }
        return false;
    }

    boolean undo() {
        if (this.mLinePaths.size() > 0) {
            this.mRedoLinePaths.add(this.mLinePaths.remove(this.mLinePaths.size() - 1));
            this.invalidate();
        }
        if (this.mBrushViewChangeListener != null) {
            this.mBrushViewChangeListener.onViewRemoved(this);
        }
        return this.mLinePaths.size() != 0;
    }

    boolean redo() {
        if (this.mRedoLinePaths.size() > 0) {
            this.mLinePaths.add(this.mRedoLinePaths.remove(this.mRedoLinePaths.size() - 1));
            this.invalidate();
        }
        if (this.mBrushViewChangeListener != null) {
            this.mBrushViewChangeListener.onViewAdd(this);
        }
        return this.mRedoLinePaths.size() != 0;
    }

    private void touchStart(float x, float y) {
        this.mRedoLinePaths.clear();
        this.mPath.reset();
        this.mPath.moveTo(x, y);
        this.mTouchX = x;
        this.mTouchY = y;
    }

    private void touchMove(float x, float y) {
        float dx = Math.abs(x - this.mTouchX);
        float dy = Math.abs(y - this.mTouchY);
        if (dx >= 4.0f || dy >= 4.0f) {
            this.mPath.quadTo(this.mTouchX, this.mTouchY, (x + this.mTouchX) / 2.0f, (y + this.mTouchY) / 2.0f);
            this.mTouchX = x;
            this.mTouchY = y;
        }
    }

    private void touchUp() {
        this.mPath.lineTo(this.mTouchX, this.mTouchY);
        this.mDrawCanvas.drawPath(this.mPath, this.mDrawPaint);
        this.mLinePaths.add(new LinePath(this.mPath, this.mDrawPaint));
        this.mPath = new Path();
        if (this.mBrushViewChangeListener != null) {
            this.mBrushViewChangeListener.onViewAdd(this);
        }
    }

    private class LinePath {
        private Paint mDrawPaint;
        private Path mDrawPath;

        LinePath(Path drawPath, Paint drawPaints) {
            this.mDrawPaint = new Paint(drawPaints);
            this.mDrawPath = new Path(drawPath);
        }

        Paint getDrawPaint() {
            return this.mDrawPaint;
        }

        Path getDrawPath() {
            return this.mDrawPath;
        }
    }
}

