/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.AbstractFloatBigList;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class MappedFloatBigList
extends AbstractFloatBigList {
    private static int LOG2_BITS = 63 - Long.numberOfLeadingZeros(4L);
    private static int CHUNK_SHIFT = 30 - LOG2_BITS;
    public static final long CHUNK_SIZE = 1L << CHUNK_SHIFT;
    private static final long CHUNK_MASK = CHUNK_SIZE - 1L;
    private final FloatBuffer[] FloatBuffer;
    private final boolean[] readyToUse;
    private final int n;
    private final long size;

    protected MappedFloatBigList(FloatBuffer[] FloatBuffer2, long size, boolean[] readyToUse) {
        this.FloatBuffer = FloatBuffer2;
        this.n = FloatBuffer2.length;
        this.size = size;
        this.readyToUse = readyToUse;
        for (int i = 0; i < this.n; ++i) {
            if (i >= this.n - 1 || (long)FloatBuffer2[i].capacity() == CHUNK_SIZE) continue;
            throw new IllegalArgumentException();
        }
    }

    public static MappedFloatBigList map(FileChannel fileChannel) throws IOException {
        return MappedFloatBigList.map(fileChannel, ByteOrder.BIG_ENDIAN);
    }

    public static MappedFloatBigList map(FileChannel fileChannel, ByteOrder byteOrder) throws IOException {
        return MappedFloatBigList.map(fileChannel, byteOrder, FileChannel.MapMode.READ_ONLY);
    }

    public static MappedFloatBigList map(FileChannel fileChannel, ByteOrder byteOrder, FileChannel.MapMode mapMode) throws IOException {
        long size = fileChannel.size() / 4L;
        int chunks = (int)((size + (CHUNK_SIZE - 1L)) / CHUNK_SIZE);
        FloatBuffer[] FloatBuffer2 = new FloatBuffer[chunks];
        for (int i = 0; i < chunks; ++i) {
            FloatBuffer2[i] = fileChannel.map(mapMode, (long)i * CHUNK_SIZE * 4L, Math.min(CHUNK_SIZE, size - (long)i * CHUNK_SIZE) * 4L).order(byteOrder).asFloatBuffer();
        }
        boolean[] readyToUse = new boolean[chunks];
        Arrays.fill(readyToUse, true);
        return new MappedFloatBigList(FloatBuffer2, size, readyToUse);
    }

    private FloatBuffer FloatBuffer(int n) {
        if (this.readyToUse[n]) {
            return this.FloatBuffer[n];
        }
        this.readyToUse[n] = true;
        this.FloatBuffer[n] = this.FloatBuffer[n].duplicate();
        return this.FloatBuffer[n];
    }

    public MappedFloatBigList copy() {
        return new MappedFloatBigList((FloatBuffer[])this.FloatBuffer.clone(), this.size, new boolean[this.n]);
    }

    @Override
    public float getFloat(long index) {
        return this.FloatBuffer((int)(index >>> CHUNK_SHIFT)).get((int)(index & CHUNK_MASK));
    }

    @Override
    public void getElements(long from, float[] a, int offset, int length) {
        int chunk = (int)(from >>> CHUNK_SHIFT);
        int displ = (int)(from & CHUNK_MASK);
        while (length > 0) {
            FloatBuffer b = this.FloatBuffer(chunk);
            int l = Math.min(b.capacity() - displ, length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            b.position(displ);
            b.get(a, offset, l);
            if ((long)(displ += l) == CHUNK_SIZE) {
                displ = 0;
                ++chunk;
            }
            offset += l;
            length -= l;
        }
    }

    @Override
    public float set(long index, float value) {
        FloatBuffer b = this.FloatBuffer((int)(index >>> CHUNK_SHIFT));
        int i = (int)(index & CHUNK_MASK);
        float previousValue = b.get(i);
        b.put(i, value);
        return previousValue;
    }

    @Override
    public long size64() {
        return this.size;
    }
}

