/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloat2LongMap;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2LongMap;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatHash;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

public class Float2LongOpenCustomHashMap
extends AbstractFloat2LongMap
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient float[] key;
    protected transient long[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected FloatHash.Strategy strategy;
    protected transient int n;
    protected transient int maxFill;
    protected int size;
    protected final float f;
    protected volatile transient Float2LongMap.FastEntrySet entries;
    protected volatile transient FloatSet keys;
    protected volatile transient LongCollection values;

    public Float2LongOpenCustomHashMap(int expected, float f, FloatHash.Strategy strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new float[this.n + 1];
        this.value = new long[this.n + 1];
    }

    public Float2LongOpenCustomHashMap(int expected, FloatHash.Strategy strategy) {
        this(expected, 0.75f, strategy);
    }

    public Float2LongOpenCustomHashMap(FloatHash.Strategy strategy) {
        this(16, 0.75f, strategy);
    }

    public Float2LongOpenCustomHashMap(Map<? extends Float, ? extends Long> m, float f, FloatHash.Strategy strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Float2LongOpenCustomHashMap(Map<? extends Float, ? extends Long> m, FloatHash.Strategy strategy) {
        this(m, 0.75f, strategy);
    }

    public Float2LongOpenCustomHashMap(Float2LongMap m, float f, FloatHash.Strategy strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Float2LongOpenCustomHashMap(Float2LongMap m, FloatHash.Strategy strategy) {
        this(m, 0.75f, strategy);
    }

    public Float2LongOpenCustomHashMap(float[] k, long[] v, float f, FloatHash.Strategy strategy) {
        this(k.length, f, strategy);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Float2LongOpenCustomHashMap(float[] k, long[] v, FloatHash.Strategy strategy) {
        this(k, v, 0.75f, strategy);
    }

    public FloatHash.Strategy strategy() {
        return this.strategy;
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    private void ensureCapacity(int capacity) {
        int needed = HashCommon.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private void tryCapacity(long capacity) {
        int needed = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private long setValue(int pos, long v) {
        long oldValue = this.value[pos];
        this.value[pos] = v;
        return oldValue;
    }

    private long removeEntry(int pos) {
        long oldValue = this.value[pos];
        --this.size;
        this.shiftKeys(pos);
        return oldValue;
    }

    private long removeNullEntry() {
        this.containsNullKey = false;
        long oldValue = this.value[this.n];
        --this.size;
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Long> m) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(m.size());
        } else {
            this.tryCapacity(this.size() + m.size());
        }
        super.putAll(m);
    }

    private int insert(float k, long v) {
        int pos;
        if (k == 0.0f) {
            if (this.containsNullKey) {
                return this.n;
            }
            this.containsNullKey = true;
            pos = this.n;
        } else {
            float[] key = this.key;
            pos = HashCommon.phiMix(this.strategy.hashCode(k)) & this.mask;
            float curr = key[pos];
            if (curr != 0.0f) {
                if (this.strategy.equals(curr, k)) {
                    return pos;
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0.0f) {
                    if (!this.strategy.equals(curr, k)) continue;
                    return pos;
                }
            }
            key[pos] = k;
        }
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return -1;
    }

    @Override
    public long put(float k, long v) {
        int pos = this.insert(k, v);
        if (pos < 0) {
            return this.defRetValue;
        }
        long oldValue = this.value[pos];
        this.value[pos] = v;
        return oldValue;
    }

    @Override
    public Long put(Float ok, Long ov) {
        long v = ov;
        int pos = this.insert(ok.floatValue(), v);
        if (pos < 0) {
            return null;
        }
        long oldValue = this.value[pos];
        this.value[pos] = v;
        return oldValue;
    }

    private long addToValue(int pos, long incr) {
        long oldValue = this.value[pos];
        this.value[pos] = oldValue + incr;
        return oldValue;
    }

    public long addTo(float k, long incr) {
        int pos;
        if (k == 0.0f) {
            if (this.containsNullKey) {
                return this.addToValue(this.n, incr);
            }
            pos = this.n;
            this.containsNullKey = true;
        } else {
            float[] key = this.key;
            pos = HashCommon.phiMix(this.strategy.hashCode(k)) & this.mask;
            float curr = key[pos];
            if (curr != 0.0f) {
                if (this.strategy.equals(curr, k)) {
                    return this.addToValue(pos, incr);
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0.0f) {
                    if (!this.strategy.equals(curr, k)) continue;
                    return this.addToValue(pos, incr);
                }
            }
            key[pos] = k;
        }
        this.value[pos] = this.defRetValue + incr;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final int shiftKeys(int pos) {
        float[] key = this.key;
        while (true) {
            float curr;
            int last = pos;
            pos = last + 1 & this.mask;
            while (true) {
                if ((curr = key[pos]) == 0.0f) {
                    key[last] = 0.0f;
                    return last;
                }
                int slot = HashCommon.phiMix(this.strategy.hashCode(curr)) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            key[last] = curr;
            this.value[last] = this.value[pos];
        }
    }

    @Override
    public long remove(float k) {
        if (k == 0.0f) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defRetValue;
        }
        float[] key = this.key;
        int pos = HashCommon.phiMix(this.strategy.hashCode(k)) & this.mask;
        float curr = key[pos];
        if (curr == 0.0f) {
            return this.defRetValue;
        }
        if (this.strategy.equals(curr, k)) {
            return this.removeEntry(pos);
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0.0f) continue;
            return this.defRetValue;
        } while (!this.strategy.equals(curr, k));
        return this.removeEntry(pos);
    }

    @Override
    public Long remove(Object ok) {
        float k = ((Float)ok).floatValue();
        if (k == 0.0f) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return null;
        }
        float[] key = this.key;
        int pos = HashCommon.phiMix(this.strategy.hashCode(k)) & this.mask;
        float curr = key[pos];
        if (curr == 0.0f) {
            return null;
        }
        if (this.strategy.equals(curr, k)) {
            return this.removeEntry(pos);
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0.0f) continue;
            return null;
        } while (!this.strategy.equals(curr, k));
        return this.removeEntry(pos);
    }

    public Long get(Float ok) {
        float k = ok.floatValue();
        if (k == 0.0f) {
            return this.containsNullKey ? Long.valueOf(this.value[this.n]) : null;
        }
        float[] key = this.key;
        int pos = HashCommon.phiMix(this.strategy.hashCode(k)) & this.mask;
        float curr = key[pos];
        if (curr == 0.0f) {
            return null;
        }
        if (this.strategy.equals(k, curr)) {
            return this.value[pos];
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0.0f) continue;
            return null;
        } while (!this.strategy.equals(k, curr));
        return this.value[pos];
    }

    @Override
    public long get(float k) {
        if (k == 0.0f) {
            return this.containsNullKey ? this.value[this.n] : this.defRetValue;
        }
        float[] key = this.key;
        int pos = HashCommon.phiMix(this.strategy.hashCode(k)) & this.mask;
        float curr = key[pos];
        if (curr == 0.0f) {
            return this.defRetValue;
        }
        if (this.strategy.equals(k, curr)) {
            return this.value[pos];
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0.0f) continue;
            return this.defRetValue;
        } while (!this.strategy.equals(k, curr));
        return this.value[pos];
    }

    @Override
    public boolean containsKey(float k) {
        if (k == 0.0f) {
            return this.containsNullKey;
        }
        float[] key = this.key;
        int pos = HashCommon.phiMix(this.strategy.hashCode(k)) & this.mask;
        float curr = key[pos];
        if (curr == 0.0f) {
            return false;
        }
        if (this.strategy.equals(k, curr)) {
            return true;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0.0f) continue;
            return false;
        } while (!this.strategy.equals(k, curr));
        return true;
    }

    @Override
    public boolean containsValue(long v) {
        long[] value = this.value;
        float[] key = this.key;
        if (this.containsNullKey && value[this.n] == v) {
            return true;
        }
        int i = this.n;
        while (i-- != 0) {
            if (key[i] == 0.0f || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, 0.0f);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Float2LongMap.FastEntrySet float2LongEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public FloatSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public LongCollection values() {
        if (this.values == null) {
            this.values = new AbstractLongCollection(){

                @Override
                public LongIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Float2LongOpenCustomHashMap.this.size;
                }

                @Override
                public boolean contains(long v) {
                    return Float2LongOpenCustomHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Float2LongOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        float[] key = this.key;
        long[] value = this.value;
        int mask = newN - 1;
        float[] newKey = new float[newN + 1];
        long[] newValue = new long[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (key[--i] == 0.0f) {
            }
            int pos = HashCommon.phiMix(this.strategy.hashCode(key[i])) & mask;
            if (newKey[pos] != 0.0f) {
                while (newKey[pos = pos + 1 & mask] != 0.0f) {
                }
            }
            newKey[pos] = key[i];
            newValue[pos] = value[i];
        }
        newValue[newN] = value[this.n];
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    public Float2LongOpenCustomHashMap clone() {
        Float2LongOpenCustomHashMap c;
        try {
            c = (Float2LongOpenCustomHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.containsNullKey = this.containsNullKey;
        c.key = (float[])this.key.clone();
        c.value = (long[])this.value.clone();
        c.strategy = this.strategy;
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.realSize();
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (this.key[i] == 0.0f) {
                ++i;
            }
            t = this.strategy.hashCode(this.key[i]);
            h += (t ^= HashCommon.long2int(this.value[i]));
            ++i;
        }
        if (this.containsNullKey) {
            h += HashCommon.long2int(this.value[this.n]);
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        float[] key = this.key;
        long[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeFloat(key[e]);
            s.writeLong(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new float[this.n + 1];
        float[] key = this.key;
        this.value = new long[this.n + 1];
        long[] value = this.value;
        int i = this.size;
        while (i-- != 0) {
            int pos;
            float k = s.readFloat();
            long v = s.readLong();
            if (k == 0.0f) {
                pos = this.n;
                this.containsNullKey = true;
            } else {
                pos = HashCommon.phiMix(this.strategy.hashCode(k)) & this.mask;
                while (key[pos] != 0.0f) {
                    pos = pos + 1 & this.mask;
                }
                key[pos] = k;
            }
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements LongIterator {
        @Override
        public long nextLong() {
            return Float2LongOpenCustomHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Long next() {
            return Float2LongOpenCustomHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractFloatSet {
        private KeySet() {
        }

        @Override
        public FloatIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Float2LongOpenCustomHashMap.this.size;
        }

        @Override
        public boolean contains(float k) {
            return Float2LongOpenCustomHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(float k) {
            int oldSize = Float2LongOpenCustomHashMap.this.size;
            Float2LongOpenCustomHashMap.this.remove(k);
            return Float2LongOpenCustomHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Float2LongOpenCustomHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements FloatIterator {
        @Override
        public float nextFloat() {
            return Float2LongOpenCustomHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Float next() {
            return Float.valueOf(Float2LongOpenCustomHashMap.this.key[this.nextEntry()]);
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Float2LongMap.Entry>
    implements Float2LongMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Float2LongMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Float2LongMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            float k = ((Float)e.getKey()).floatValue();
            if (k == 0.0f) {
                return Float2LongOpenCustomHashMap.this.containsNullKey && Float2LongOpenCustomHashMap.this.value[Float2LongOpenCustomHashMap.this.n] == (Long)e.getValue();
            }
            float[] key = Float2LongOpenCustomHashMap.this.key;
            int pos = HashCommon.phiMix(Float2LongOpenCustomHashMap.this.strategy.hashCode(k)) & Float2LongOpenCustomHashMap.this.mask;
            float curr = key[pos];
            if (curr == 0.0f) {
                return false;
            }
            if (Float2LongOpenCustomHashMap.this.strategy.equals(k, curr)) {
                return Float2LongOpenCustomHashMap.this.value[pos] == (Long)e.getValue();
            }
            do {
                if ((curr = key[pos = pos + 1 & Float2LongOpenCustomHashMap.this.mask]) != 0.0f) continue;
                return false;
            } while (!Float2LongOpenCustomHashMap.this.strategy.equals(k, curr));
            return Float2LongOpenCustomHashMap.this.value[pos] == (Long)e.getValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            float k = ((Float)e.getKey()).floatValue();
            long v = (Long)e.getValue();
            if (k == 0.0f) {
                if (Float2LongOpenCustomHashMap.this.containsNullKey && Float2LongOpenCustomHashMap.this.value[Float2LongOpenCustomHashMap.this.n] == v) {
                    Float2LongOpenCustomHashMap.this.removeNullEntry();
                    return true;
                }
                return false;
            }
            float[] key = Float2LongOpenCustomHashMap.this.key;
            int pos = HashCommon.phiMix(Float2LongOpenCustomHashMap.this.strategy.hashCode(k)) & Float2LongOpenCustomHashMap.this.mask;
            float curr = key[pos];
            if (curr == 0.0f) {
                return false;
            }
            if (Float2LongOpenCustomHashMap.this.strategy.equals(curr, k)) {
                if (Float2LongOpenCustomHashMap.this.value[pos] == v) {
                    Float2LongOpenCustomHashMap.this.removeEntry(pos);
                    return true;
                }
                return false;
            }
            do {
                if ((curr = key[pos = pos + 1 & Float2LongOpenCustomHashMap.this.mask]) != 0.0f) continue;
                return false;
            } while (!Float2LongOpenCustomHashMap.this.strategy.equals(curr, k) || Float2LongOpenCustomHashMap.this.value[pos] != v);
            Float2LongOpenCustomHashMap.this.removeEntry(pos);
            return true;
        }

        @Override
        public int size() {
            return Float2LongOpenCustomHashMap.this.size;
        }

        @Override
        public void clear() {
            Float2LongOpenCustomHashMap.this.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Float2LongMap.Entry> {
        final AbstractFloat2LongMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractFloat2LongMap.BasicEntry(0.0f, 0L);
        }

        @Override
        public AbstractFloat2LongMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Float2LongOpenCustomHashMap.this.key[e];
            this.entry.value = Float2LongOpenCustomHashMap.this.value[e];
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Float2LongMap.Entry> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public Float2LongMap.Entry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;
        boolean mustReturnNullKey;
        FloatArrayList wrapped;

        private MapIterator() {
            this.pos = Float2LongOpenCustomHashMap.this.n;
            this.last = -1;
            this.c = Float2LongOpenCustomHashMap.this.size;
            this.mustReturnNullKey = Float2LongOpenCustomHashMap.this.containsNullKey;
            float[] key = Float2LongOpenCustomHashMap.this.key;
            if (Float2LongOpenCustomHashMap.this.realSize() != 0) {
                while (key[--this.pos] == 0.0f) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNullKey) {
                this.mustReturnNullKey = false;
                this.last = Float2LongOpenCustomHashMap.this.n;
                return this.last;
            }
            if (this.pos < 0) {
                this.last = --this.pos;
                float k = this.wrapped.getFloat(-this.pos - 2);
                int pos = HashCommon.phiMix(Float2LongOpenCustomHashMap.this.strategy.hashCode(k)) & Float2LongOpenCustomHashMap.this.mask;
                while (Float2LongOpenCustomHashMap.this.key[pos] != 0.0f) {
                    if (Float2LongOpenCustomHashMap.this.strategy.equals(Float2LongOpenCustomHashMap.this.key[pos], k)) {
                        return pos;
                    }
                    pos = pos + 1 & Float2LongOpenCustomHashMap.this.mask;
                }
            }
            this.last = this.pos;
            if (this.c != 0) {
                float[] key = Float2LongOpenCustomHashMap.this.key;
                while (this.pos-- != 0 && key[this.pos] == 0.0f) {
                }
            }
            return this.last;
        }

        protected final int shiftKeys(int pos) {
            float[] key = Float2LongOpenCustomHashMap.this.key;
            while (true) {
                float curr;
                int last = pos;
                pos = last + 1 & Float2LongOpenCustomHashMap.this.mask;
                while (true) {
                    if ((curr = key[pos]) == 0.0f) {
                        key[last] = 0.0f;
                        return last;
                    }
                    int slot = HashCommon.phiMix(Float2LongOpenCustomHashMap.this.strategy.hashCode(curr)) & Float2LongOpenCustomHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Float2LongOpenCustomHashMap.this.mask;
                }
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new FloatArrayList();
                    }
                    this.wrapped.add(curr);
                }
                key[last] = curr;
                Float2LongOpenCustomHashMap.this.value[last] = Float2LongOpenCustomHashMap.this.value[pos];
            }
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.last == Float2LongOpenCustomHashMap.this.n) {
                Float2LongOpenCustomHashMap.this.containsNullKey = false;
                --Float2LongOpenCustomHashMap.this.size;
                this.last = -1;
                return;
            }
            if (this.pos < -1) {
                Float2LongOpenCustomHashMap.this.remove(this.wrapped.getFloat(-this.pos - 2));
                this.last = -1;
                return;
            }
            --Float2LongOpenCustomHashMap.this.size;
            if (this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextEntry();
            }
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Float2LongMap.Entry,
    Map.Entry<Float, Long> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Float getKey() {
            return Float.valueOf(Float2LongOpenCustomHashMap.this.key[this.index]);
        }

        @Override
        public float getFloatKey() {
            return Float2LongOpenCustomHashMap.this.key[this.index];
        }

        @Override
        public Long getValue() {
            return Float2LongOpenCustomHashMap.this.value[this.index];
        }

        @Override
        public long getLongValue() {
            return Float2LongOpenCustomHashMap.this.value[this.index];
        }

        @Override
        public long setValue(long v) {
            long oldValue = Float2LongOpenCustomHashMap.this.value[this.index];
            Float2LongOpenCustomHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Long setValue(Long v) {
            return this.setValue((long)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Float2LongOpenCustomHashMap.this.strategy.equals(Float2LongOpenCustomHashMap.this.key[this.index], ((Float)e.getKey()).floatValue()) && Float2LongOpenCustomHashMap.this.value[this.index] == (Long)e.getValue();
        }

        @Override
        public int hashCode() {
            return Float2LongOpenCustomHashMap.this.strategy.hashCode(Float2LongOpenCustomHashMap.this.key[this.index]) ^ HashCommon.long2int(Float2LongOpenCustomHashMap.this.value[this.index]);
        }

        public String toString() {
            return Float2LongOpenCustomHashMap.this.key[this.index] + "=>" + Float2LongOpenCustomHashMap.this.value[this.index];
        }
    }
}

