/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2BooleanMap;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2BooleanSortedMap;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSortedSet;
import it.unimi.dsi.fastutil.doubles.Double2BooleanMap;
import it.unimi.dsi.fastutil.doubles.Double2BooleanSortedMap;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Double2BooleanLinkedOpenHashMap
extends AbstractDouble2BooleanSortedMap
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient double[] key;
    protected transient boolean[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient long[] link;
    protected transient int n;
    protected transient int maxFill;
    protected int size;
    protected final float f;
    protected volatile transient Double2BooleanSortedMap.FastSortedEntrySet entries;
    protected volatile transient DoubleSortedSet keys;
    protected volatile transient BooleanCollection values;

    public Double2BooleanLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new double[this.n + 1];
        this.value = new boolean[this.n + 1];
        this.link = new long[this.n + 1];
    }

    public Double2BooleanLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Double2BooleanLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Double2BooleanLinkedOpenHashMap(Map<? extends Double, ? extends Boolean> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2BooleanLinkedOpenHashMap(Map<? extends Double, ? extends Boolean> m) {
        this(m, 0.75f);
    }

    public Double2BooleanLinkedOpenHashMap(Double2BooleanMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2BooleanLinkedOpenHashMap(Double2BooleanMap m) {
        this(m, 0.75f);
    }

    public Double2BooleanLinkedOpenHashMap(double[] k, boolean[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Double2BooleanLinkedOpenHashMap(double[] k, boolean[] v) {
        this(k, v, 0.75f);
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    private void ensureCapacity(int capacity) {
        int needed = HashCommon.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private void tryCapacity(long capacity) {
        int needed = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private boolean setValue(int pos, boolean v) {
        boolean oldValue = this.value[pos];
        this.value[pos] = v;
        return oldValue;
    }

    private boolean removeEntry(int pos) {
        boolean oldValue = this.value[pos];
        this.fixPointers(pos);
        --this.size;
        this.shiftKeys(pos);
        return oldValue;
    }

    private boolean removeNullEntry() {
        this.containsNullKey = false;
        boolean oldValue = this.value[this.n];
        this.fixPointers(this.n);
        --this.size;
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Boolean> m) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(m.size());
        } else {
            this.tryCapacity(this.size() + m.size());
        }
        super.putAll(m);
    }

    private int insert(double k, boolean v) {
        int pos;
        if (k == 0.0) {
            if (this.containsNullKey) {
                return this.n;
            }
            this.containsNullKey = true;
            pos = this.n;
        } else {
            double[] key = this.key;
            pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(k)) & this.mask;
            double curr = key[pos];
            if (curr != 0.0) {
                if (Double.doubleToLongBits(curr) == Double.doubleToLongBits(k)) {
                    return pos;
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0.0) {
                    if (Double.doubleToLongBits(curr) != Double.doubleToLongBits(k)) continue;
                    return pos;
                }
            }
            key[pos] = k;
        }
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return -1;
    }

    @Override
    public boolean put(double k, boolean v) {
        int pos = this.insert(k, v);
        if (pos < 0) {
            return this.defRetValue;
        }
        boolean oldValue = this.value[pos];
        this.value[pos] = v;
        return oldValue;
    }

    @Override
    public Boolean put(Double ok, Boolean ov) {
        boolean v = ov;
        int pos = this.insert(ok, v);
        if (pos < 0) {
            return null;
        }
        boolean oldValue = this.value[pos];
        this.value[pos] = v;
        return oldValue;
    }

    protected final int shiftKeys(int pos) {
        double[] key = this.key;
        while (true) {
            double curr;
            int last = pos;
            pos = last + 1 & this.mask;
            while (true) {
                if ((curr = key[pos]) == 0.0) {
                    key[last] = 0.0;
                    return last;
                }
                int slot = (int)HashCommon.phiMix(Double.doubleToRawLongBits(curr)) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            key[last] = curr;
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
    }

    @Override
    public boolean remove(double k) {
        if (k == 0.0) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defRetValue;
        }
        double[] key = this.key;
        int pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (curr == 0.0) {
            return this.defRetValue;
        }
        if (Double.doubleToLongBits(curr) == Double.doubleToLongBits(k)) {
            return this.removeEntry(pos);
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0.0) continue;
            return this.defRetValue;
        } while (Double.doubleToLongBits(curr) != Double.doubleToLongBits(k));
        return this.removeEntry(pos);
    }

    @Override
    public Boolean remove(Object ok) {
        double k = (Double)ok;
        if (k == 0.0) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return null;
        }
        double[] key = this.key;
        int pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (curr == 0.0) {
            return null;
        }
        if (Double.doubleToLongBits(curr) == Double.doubleToLongBits(k)) {
            return this.removeEntry(pos);
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0.0) continue;
            return null;
        } while (Double.doubleToLongBits(curr) != Double.doubleToLongBits(k));
        return this.removeEntry(pos);
    }

    public boolean removeFirstBoolean() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        --this.size;
        int pos = this.first;
        this.first = (int)this.link[pos];
        if (0 <= this.first) {
            int n = this.first;
            this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
        }
        boolean v = this.value[pos];
        if (pos == this.n) {
            this.containsNullKey = false;
        } else {
            this.shiftKeys(pos);
        }
        return v;
    }

    public boolean removeLastBoolean() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        --this.size;
        int pos = this.last;
        this.last = (int)(this.link[pos] >>> 32);
        if (0 <= this.last) {
            int n = this.last;
            this.link[n] = this.link[n] | 0xFFFFFFFFL;
        }
        boolean v = this.value[pos];
        if (pos == this.n) {
            this.containsNullKey = false;
        } else {
            this.shiftKeys(pos);
        }
        return v;
    }

    private void moveIndexToFirst(int i) {
        if (this.size == 1 || this.first == i) {
            return;
        }
        if (this.last == i) {
            int n = this.last = (int)(this.link[i] >>> 32);
            this.link[n] = this.link[n] | 0xFFFFFFFFL;
        } else {
            long linki = this.link[i];
            int prev = (int)(linki >>> 32);
            int next = (int)linki;
            int n = prev;
            this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.first;
        this.link[n] = this.link[n] ^ (this.link[this.first] ^ ((long)i & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[i] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
        this.first = i;
    }

    private void moveIndexToLast(int i) {
        if (this.size == 1 || this.last == i) {
            return;
        }
        if (this.first == i) {
            int n = this.first = (int)this.link[i];
            this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
        } else {
            long linki = this.link[i];
            int prev = (int)(linki >>> 32);
            int next = (int)linki;
            int n = prev;
            this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.last;
        this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)i & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        this.link[i] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
        this.last = i;
    }

    public boolean getAndMoveToFirst(double k) {
        if (k == 0.0) {
            if (this.containsNullKey) {
                this.moveIndexToFirst(this.n);
                return this.value[this.n];
            }
            return this.defRetValue;
        }
        double[] key = this.key;
        int pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (curr == 0.0) {
            return this.defRetValue;
        }
        if (Double.doubleToLongBits(k) == Double.doubleToLongBits(curr)) {
            this.moveIndexToFirst(pos);
            return this.value[pos];
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0.0) continue;
            return this.defRetValue;
        } while (Double.doubleToLongBits(k) != Double.doubleToLongBits(curr));
        this.moveIndexToFirst(pos);
        return this.value[pos];
    }

    public boolean getAndMoveToLast(double k) {
        if (k == 0.0) {
            if (this.containsNullKey) {
                this.moveIndexToLast(this.n);
                return this.value[this.n];
            }
            return this.defRetValue;
        }
        double[] key = this.key;
        int pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (curr == 0.0) {
            return this.defRetValue;
        }
        if (Double.doubleToLongBits(k) == Double.doubleToLongBits(curr)) {
            this.moveIndexToLast(pos);
            return this.value[pos];
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0.0) continue;
            return this.defRetValue;
        } while (Double.doubleToLongBits(k) != Double.doubleToLongBits(curr));
        this.moveIndexToLast(pos);
        return this.value[pos];
    }

    public boolean putAndMoveToFirst(double k, boolean v) {
        int pos;
        if (k == 0.0) {
            if (this.containsNullKey) {
                this.moveIndexToFirst(this.n);
                return this.setValue(this.n, v);
            }
            this.containsNullKey = true;
            pos = this.n;
        } else {
            double[] key = this.key;
            pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(k)) & this.mask;
            double curr = key[pos];
            if (curr != 0.0) {
                if (Double.doubleToLongBits(curr) == Double.doubleToLongBits(k)) {
                    this.moveIndexToFirst(pos);
                    return this.setValue(pos, v);
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0.0) {
                    if (Double.doubleToLongBits(curr) != Double.doubleToLongBits(k)) continue;
                    this.moveIndexToFirst(pos);
                    return this.setValue(pos, v);
                }
            }
            key[pos] = k;
        }
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.first;
            this.link[n] = this.link[n] ^ (this.link[this.first] ^ ((long)pos & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[pos] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
            this.first = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    public boolean putAndMoveToLast(double k, boolean v) {
        int pos;
        if (k == 0.0) {
            if (this.containsNullKey) {
                this.moveIndexToLast(this.n);
                return this.setValue(this.n, v);
            }
            this.containsNullKey = true;
            pos = this.n;
        } else {
            double[] key = this.key;
            pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(k)) & this.mask;
            double curr = key[pos];
            if (curr != 0.0) {
                if (Double.doubleToLongBits(curr) == Double.doubleToLongBits(k)) {
                    this.moveIndexToLast(pos);
                    return this.setValue(pos, v);
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0.0) {
                    if (Double.doubleToLongBits(curr) != Double.doubleToLongBits(k)) continue;
                    this.moveIndexToLast(pos);
                    return this.setValue(pos, v);
                }
            }
            key[pos] = k;
        }
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    public Boolean get(Double ok) {
        double k = ok;
        if (k == 0.0) {
            return this.containsNullKey ? Boolean.valueOf(this.value[this.n]) : null;
        }
        double[] key = this.key;
        int pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (curr == 0.0) {
            return null;
        }
        if (Double.doubleToLongBits(k) == Double.doubleToLongBits(curr)) {
            return this.value[pos];
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0.0) continue;
            return null;
        } while (Double.doubleToLongBits(k) != Double.doubleToLongBits(curr));
        return this.value[pos];
    }

    @Override
    public boolean get(double k) {
        if (k == 0.0) {
            return this.containsNullKey ? this.value[this.n] : this.defRetValue;
        }
        double[] key = this.key;
        int pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (curr == 0.0) {
            return this.defRetValue;
        }
        if (Double.doubleToLongBits(k) == Double.doubleToLongBits(curr)) {
            return this.value[pos];
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0.0) continue;
            return this.defRetValue;
        } while (Double.doubleToLongBits(k) != Double.doubleToLongBits(curr));
        return this.value[pos];
    }

    @Override
    public boolean containsKey(double k) {
        if (k == 0.0) {
            return this.containsNullKey;
        }
        double[] key = this.key;
        int pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (curr == 0.0) {
            return false;
        }
        if (Double.doubleToLongBits(k) == Double.doubleToLongBits(curr)) {
            return true;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0.0) continue;
            return false;
        } while (Double.doubleToLongBits(k) != Double.doubleToLongBits(curr));
        return true;
    }

    @Override
    public boolean containsValue(boolean v) {
        boolean[] value = this.value;
        double[] key = this.key;
        if (this.containsNullKey && value[this.n] == v) {
            return true;
        }
        int i = this.n;
        while (i-- != 0) {
            if (key[i] == 0.0 || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, 0.0);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            this.first = (int)this.link[i];
            if (0 <= this.first) {
                int n = this.first;
                this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.last == i) {
            this.last = (int)(this.link[i] >>> 32);
            if (0 <= this.last) {
                int n = this.last;
                this.link[n] = this.link[n] | 0xFFFFFFFFL;
            }
            return;
        }
        long linki = this.link[i];
        int prev = (int)(linki >>> 32);
        int next = (int)linki;
        int n = prev;
        this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n2 = next;
        this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    protected void fixPointers(int s, int d) {
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = -1L;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = (int)this.link[s];
            this.link[n] = this.link[n] ^ (this.link[(int)this.link[s]] ^ ((long)d & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = (int)(this.link[s] >>> 32);
            this.link[n] = this.link[n] ^ (this.link[(int)(this.link[s] >>> 32)] ^ (long)d & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[d] = this.link[s];
            return;
        }
        long links = this.link[s];
        int prev = (int)(links >>> 32);
        int next = (int)links;
        int n = prev;
        this.link[n] = this.link[n] ^ (this.link[prev] ^ (long)d & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n2 = next;
        this.link[n2] = this.link[n2] ^ (this.link[next] ^ ((long)d & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[d] = links;
    }

    @Override
    public double firstDoubleKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public double lastDoubleKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public DoubleComparator comparator() {
        return null;
    }

    @Override
    public Double2BooleanSortedMap tailMap(double from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double2BooleanSortedMap headMap(double to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double2BooleanSortedMap subMap(double from, double to) {
        throw new UnsupportedOperationException();
    }

    public Double2BooleanSortedMap.FastSortedEntrySet double2BooleanEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public DoubleSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public BooleanCollection values() {
        if (this.values == null) {
            this.values = new AbstractBooleanCollection(){

                @Override
                public BooleanIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Double2BooleanLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(boolean v) {
                    return Double2BooleanLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Double2BooleanLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        double[] key = this.key;
        boolean[] value = this.value;
        int mask = newN - 1;
        double[] newKey = new double[newN + 1];
        boolean[] newValue = new boolean[newN + 1];
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        long[] link = this.link;
        long[] newLink = new long[newN + 1];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            int pos;
            if (key[i] == 0.0) {
                pos = newN;
            } else {
                pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(key[i])) & mask;
                while (newKey[pos] != 0.0) {
                    pos = pos + 1 & mask;
                }
                newKey[pos] = key[i];
            }
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ (newLink[newPrev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos;
                newLink[n2] = newLink[n2] ^ (newLink[pos] ^ ((long)newPrev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1L;
            }
            int t = i;
            i = (int)link[i];
            prev = t;
        }
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = newLink[n] | 0xFFFFFFFFL;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    public Double2BooleanLinkedOpenHashMap clone() {
        Double2BooleanLinkedOpenHashMap c;
        try {
            c = (Double2BooleanLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.containsNullKey = this.containsNullKey;
        c.key = (double[])this.key.clone();
        c.value = (boolean[])this.value.clone();
        c.link = (long[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.realSize();
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (this.key[i] == 0.0) {
                ++i;
            }
            t = HashCommon.double2int(this.key[i]);
            h += (t ^= this.value[i] ? 1231 : 1237);
            ++i;
        }
        if (this.containsNullKey) {
            h += this.value[this.n] ? 1231 : 1237;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        double[] key = this.key;
        boolean[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeDouble(key[e]);
            s.writeBoolean(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new double[this.n + 1];
        double[] key = this.key;
        this.value = new boolean[this.n + 1];
        boolean[] value = this.value;
        this.link = new long[this.n + 1];
        long[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        while (i-- != 0) {
            int pos;
            double k = s.readDouble();
            boolean v = s.readBoolean();
            if (k == 0.0) {
                pos = this.n;
                this.containsNullKey = true;
            } else {
                pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(k)) & this.mask;
                while (key[pos] != 0.0) {
                    pos = pos + 1 & this.mask;
                }
                key[pos] = k;
            }
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ (link[prev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos;
                link[n2] = link[n2] ^ (link[pos] ^ ((long)prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            int n = pos;
            link[n] = link[n] | 0xFFFFFFFF00000000L;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = link[n] | 0xFFFFFFFFL;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements BooleanListIterator {
        @Override
        public boolean previousBoolean() {
            return Double2BooleanLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public Boolean previous() {
            return Double2BooleanLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public void set(Boolean ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Boolean ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(boolean v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(boolean v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean nextBoolean() {
            return Double2BooleanLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Boolean next() {
            return Double2BooleanLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractDoubleSortedSet {
        private KeySet() {
        }

        @Override
        public DoubleListIterator iterator(double from) {
            return new KeyIterator(from);
        }

        @Override
        public DoubleListIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Double2BooleanLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(double k) {
            return Double2BooleanLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(double k) {
            int oldSize = Double2BooleanLinkedOpenHashMap.this.size;
            Double2BooleanLinkedOpenHashMap.this.remove(k);
            return Double2BooleanLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Double2BooleanLinkedOpenHashMap.this.clear();
        }

        @Override
        public double firstDouble() {
            if (Double2BooleanLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Double2BooleanLinkedOpenHashMap.this.key[Double2BooleanLinkedOpenHashMap.this.first];
        }

        @Override
        public double lastDouble() {
            if (Double2BooleanLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Double2BooleanLinkedOpenHashMap.this.key[Double2BooleanLinkedOpenHashMap.this.last];
        }

        @Override
        public DoubleComparator comparator() {
            return null;
        }

        @Override
        public final DoubleSortedSet tailSet(double from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final DoubleSortedSet headSet(double to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final DoubleSortedSet subSet(double from, double to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements DoubleListIterator {
        public KeyIterator(double k) {
            super(k);
        }

        @Override
        public double previousDouble() {
            return Double2BooleanLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double previous() {
            return Double2BooleanLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(Double ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public double nextDouble() {
            return Double2BooleanLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Double next() {
            return Double2BooleanLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Double2BooleanMap.Entry>
    implements Double2BooleanSortedMap.FastSortedEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Double2BooleanMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Double2BooleanMap.Entry> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Double2BooleanMap.Entry> subSet(Double2BooleanMap.Entry fromElement, Double2BooleanMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Double2BooleanMap.Entry> headSet(Double2BooleanMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Double2BooleanMap.Entry> tailSet(Double2BooleanMap.Entry fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double2BooleanMap.Entry first() {
            if (Double2BooleanLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Double2BooleanLinkedOpenHashMap.this.first);
        }

        @Override
        public Double2BooleanMap.Entry last() {
            if (Double2BooleanLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Double2BooleanLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            double k = (Double)e.getKey();
            if (k == 0.0) {
                return Double2BooleanLinkedOpenHashMap.this.containsNullKey && Double2BooleanLinkedOpenHashMap.this.value[Double2BooleanLinkedOpenHashMap.this.n] == (Boolean)e.getValue();
            }
            double[] key = Double2BooleanLinkedOpenHashMap.this.key;
            int pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(k)) & Double2BooleanLinkedOpenHashMap.this.mask;
            double curr = key[pos];
            if (curr == 0.0) {
                return false;
            }
            if (Double.doubleToLongBits(k) == Double.doubleToLongBits(curr)) {
                return Double2BooleanLinkedOpenHashMap.this.value[pos] == (Boolean)e.getValue();
            }
            do {
                if ((curr = key[pos = pos + 1 & Double2BooleanLinkedOpenHashMap.this.mask]) != 0.0) continue;
                return false;
            } while (Double.doubleToLongBits(k) != Double.doubleToLongBits(curr));
            return Double2BooleanLinkedOpenHashMap.this.value[pos] == (Boolean)e.getValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            double k = (Double)e.getKey();
            boolean v = (Boolean)e.getValue();
            if (k == 0.0) {
                if (Double2BooleanLinkedOpenHashMap.this.containsNullKey && Double2BooleanLinkedOpenHashMap.this.value[Double2BooleanLinkedOpenHashMap.this.n] == v) {
                    Double2BooleanLinkedOpenHashMap.this.removeNullEntry();
                    return true;
                }
                return false;
            }
            double[] key = Double2BooleanLinkedOpenHashMap.this.key;
            int pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(k)) & Double2BooleanLinkedOpenHashMap.this.mask;
            double curr = key[pos];
            if (curr == 0.0) {
                return false;
            }
            if (Double.doubleToLongBits(curr) == Double.doubleToLongBits(k)) {
                if (Double2BooleanLinkedOpenHashMap.this.value[pos] == v) {
                    Double2BooleanLinkedOpenHashMap.this.removeEntry(pos);
                    return true;
                }
                return false;
            }
            do {
                if ((curr = key[pos = pos + 1 & Double2BooleanLinkedOpenHashMap.this.mask]) != 0.0) continue;
                return false;
            } while (Double.doubleToLongBits(curr) != Double.doubleToLongBits(k) || Double2BooleanLinkedOpenHashMap.this.value[pos] != v);
            Double2BooleanLinkedOpenHashMap.this.removeEntry(pos);
            return true;
        }

        @Override
        public int size() {
            return Double2BooleanLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Double2BooleanLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Double2BooleanMap.Entry> iterator(Double2BooleanMap.Entry from) {
            return new EntryIterator((Double)from.getKey());
        }

        public ObjectBidirectionalIterator<Double2BooleanMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Double2BooleanMap.Entry> fastIterator(Double2BooleanMap.Entry from) {
            return new FastEntryIterator((Double)from.getKey());
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Double2BooleanMap.Entry> {
        final AbstractDouble2BooleanMap.BasicEntry entry;

        public FastEntryIterator() {
            this.entry = new AbstractDouble2BooleanMap.BasicEntry(0.0, false);
        }

        public FastEntryIterator(double from) {
            super(from);
            this.entry = new AbstractDouble2BooleanMap.BasicEntry(0.0, false);
        }

        @Override
        public AbstractDouble2BooleanMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Double2BooleanLinkedOpenHashMap.this.key[e];
            this.entry.value = Double2BooleanLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractDouble2BooleanMap.BasicEntry previous() {
            int e = this.previousEntry();
            this.entry.key = Double2BooleanLinkedOpenHashMap.this.key[e];
            this.entry.value = Double2BooleanLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Double2BooleanMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double2BooleanMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Double2BooleanMap.Entry> {
        private MapEntry entry;

        public EntryIterator() {
        }

        public EntryIterator(double from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public MapEntry previous() {
            this.entry = new MapEntry(this.previousEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }

        @Override
        public void set(Double2BooleanMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double2BooleanMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = -1;

        private MapIterator() {
            this.next = Double2BooleanLinkedOpenHashMap.this.first;
            this.index = 0;
        }

        private MapIterator(double from) {
            if (from == 0.0) {
                if (Double2BooleanLinkedOpenHashMap.this.containsNullKey) {
                    this.next = (int)Double2BooleanLinkedOpenHashMap.this.link[Double2BooleanLinkedOpenHashMap.this.n];
                    this.prev = Double2BooleanLinkedOpenHashMap.this.n;
                    return;
                }
                throw new NoSuchElementException("The key " + from + " does not belong to this map.");
            }
            if (Double.doubleToLongBits(Double2BooleanLinkedOpenHashMap.this.key[Double2BooleanLinkedOpenHashMap.this.last]) == Double.doubleToLongBits(from)) {
                this.prev = Double2BooleanLinkedOpenHashMap.this.last;
                this.index = Double2BooleanLinkedOpenHashMap.this.size;
                return;
            }
            int pos = (int)HashCommon.phiMix(Double.doubleToRawLongBits(from)) & Double2BooleanLinkedOpenHashMap.this.mask;
            while (Double2BooleanLinkedOpenHashMap.this.key[pos] != 0.0) {
                if (Double.doubleToLongBits(Double2BooleanLinkedOpenHashMap.this.key[pos]) == Double.doubleToLongBits(from)) {
                    this.next = (int)Double2BooleanLinkedOpenHashMap.this.link[pos];
                    this.prev = pos;
                    return;
                }
                pos = pos + 1 & Double2BooleanLinkedOpenHashMap.this.mask;
            }
            throw new NoSuchElementException("The key " + from + " does not belong to this map.");
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        private final void ensureIndexKnown() {
            if (this.index >= 0) {
                return;
            }
            if (this.prev == -1) {
                this.index = 0;
                return;
            }
            if (this.next == -1) {
                this.index = Double2BooleanLinkedOpenHashMap.this.size;
                return;
            }
            int pos = Double2BooleanLinkedOpenHashMap.this.first;
            this.index = 1;
            while (pos != this.prev) {
                pos = (int)Double2BooleanLinkedOpenHashMap.this.link[pos];
                ++this.index;
            }
        }

        public int nextIndex() {
            this.ensureIndexKnown();
            return this.index;
        }

        public int previousIndex() {
            this.ensureIndexKnown();
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Double2BooleanLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = (int)Double2BooleanLinkedOpenHashMap.this.link[this.curr];
            this.prev = this.curr;
            if (this.index >= 0) {
                ++this.index;
            }
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = (int)(Double2BooleanLinkedOpenHashMap.this.link[this.curr] >>> 32);
            this.next = this.curr;
            if (this.index >= 0) {
                --this.index;
            }
            return this.curr;
        }

        public void remove() {
            this.ensureIndexKnown();
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = (int)(Double2BooleanLinkedOpenHashMap.this.link[this.curr] >>> 32);
            } else {
                this.next = (int)Double2BooleanLinkedOpenHashMap.this.link[this.curr];
            }
            --Double2BooleanLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Double2BooleanLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Double2BooleanLinkedOpenHashMap.this.link[n] = Double2BooleanLinkedOpenHashMap.this.link[n] ^ (Double2BooleanLinkedOpenHashMap.this.link[this.prev] ^ (long)this.next & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.next == -1) {
                Double2BooleanLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Double2BooleanLinkedOpenHashMap.this.link[n] = Double2BooleanLinkedOpenHashMap.this.link[n] ^ (Double2BooleanLinkedOpenHashMap.this.link[this.next] ^ ((long)this.prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            int pos = this.curr;
            this.curr = -1;
            if (pos != Double2BooleanLinkedOpenHashMap.this.n) {
                double[] key = Double2BooleanLinkedOpenHashMap.this.key;
                while (true) {
                    double curr;
                    int last = pos;
                    pos = last + 1 & Double2BooleanLinkedOpenHashMap.this.mask;
                    while (true) {
                        if ((curr = key[pos]) == 0.0) {
                            key[last] = 0.0;
                            return;
                        }
                        int slot = (int)HashCommon.phiMix(Double.doubleToRawLongBits(curr)) & Double2BooleanLinkedOpenHashMap.this.mask;
                        if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                        pos = pos + 1 & Double2BooleanLinkedOpenHashMap.this.mask;
                    }
                    key[last] = curr;
                    Double2BooleanLinkedOpenHashMap.this.value[last] = Double2BooleanLinkedOpenHashMap.this.value[pos];
                    if (this.next == pos) {
                        this.next = last;
                    }
                    if (this.prev == pos) {
                        this.prev = last;
                    }
                    Double2BooleanLinkedOpenHashMap.this.fixPointers(pos, last);
                }
            }
            Double2BooleanLinkedOpenHashMap.this.containsNullKey = false;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Double2BooleanMap.Entry,
    Map.Entry<Double, Boolean> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Double getKey() {
            return Double2BooleanLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public double getDoubleKey() {
            return Double2BooleanLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Boolean getValue() {
            return Double2BooleanLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public boolean getBooleanValue() {
            return Double2BooleanLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public boolean setValue(boolean v) {
            boolean oldValue = Double2BooleanLinkedOpenHashMap.this.value[this.index];
            Double2BooleanLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Boolean setValue(Boolean v) {
            return this.setValue((boolean)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Double.doubleToLongBits(Double2BooleanLinkedOpenHashMap.this.key[this.index]) == Double.doubleToLongBits((Double)e.getKey()) && Double2BooleanLinkedOpenHashMap.this.value[this.index] == (Boolean)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(Double2BooleanLinkedOpenHashMap.this.key[this.index]) ^ (Double2BooleanLinkedOpenHashMap.this.value[this.index] ? 1231 : 1237);
        }

        public String toString() {
            return Double2BooleanLinkedOpenHashMap.this.key[this.index] + "=>" + Double2BooleanLinkedOpenHashMap.this.value[this.index];
        }
    }
}

