/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.AbstractFloatComparator;
import it.unimi.dsi.fastutil.floats.FloatComparator;

public class FloatComparators {
    public static final FloatComparator NATURAL_COMPARATOR = new AbstractFloatComparator(){

        @Override
        public final int compare(float a, float b) {
            return a < b ? -1 : (a == b ? 0 : 1);
        }
    };
    public static final FloatComparator OPPOSITE_COMPARATOR = new AbstractFloatComparator(){

        @Override
        public final int compare(float a, float b) {
            return b < a ? -1 : (b == a ? 0 : 1);
        }
    };

    private FloatComparators() {
    }

    public static FloatComparator oppositeComparator(final FloatComparator c) {
        return new AbstractFloatComparator(){
            private final FloatComparator comparator;
            {
                this.comparator = c;
            }

            @Override
            public final int compare(float a, float b) {
                return -this.comparator.compare(a, b);
            }
        };
    }
}

