/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.shorts.AbstractShortPriorityQueue;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import java.util.NoSuchElementException;

public class ShortArrayFIFOQueue
extends AbstractShortPriorityQueue {
    public static final int INITIAL_CAPACITY = 16;
    protected short[] array = ShortArrays.EMPTY_ARRAY;
    protected int length;
    protected int start;
    protected int end;

    public ShortArrayFIFOQueue(int capacity) {
        if (capacity > 0) {
            this.array = new short[capacity];
        }
        this.length = this.array.length;
    }

    public ShortArrayFIFOQueue() {
        this(16);
    }

    @Override
    public ShortComparator comparator() {
        return null;
    }

    @Override
    public short dequeueShort() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        short t = this.array[this.start];
        if (++this.start == this.length) {
            this.start = 0;
        }
        return t;
    }

    public short dequeueLastShort() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        if (this.end == 0) {
            this.end = this.length;
        }
        short t = this.array[--this.end];
        return t;
    }

    private final void expand() {
        short[] newArray = ShortArrays.grow(this.array, this.length + 1, 0);
        System.arraycopy(this.array, this.start, newArray, 0, this.length - this.start);
        System.arraycopy(this.array, 0, newArray, this.length - this.start, this.end);
        this.start = 0;
        this.end = this.length;
        this.array = newArray;
        this.length = newArray.length;
    }

    @Override
    public void enqueue(short x) {
        this.array[this.end++] = x;
        if (this.end == this.length) {
            this.end = 0;
        }
        if (this.end == this.start) {
            this.expand();
        }
    }

    public void enqueueFirst(short x) {
        if (this.start == 0) {
            this.start = this.length;
        }
        this.array[--this.start] = x;
        if (this.end == this.start) {
            this.expand();
        }
    }

    @Override
    public short firstShort() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        return this.array[this.start];
    }

    @Override
    public short lastShort() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        return this.array[(this.end == 0 ? this.length : this.end) - 1];
    }

    @Override
    public void clear() {
        this.end = 0;
        this.start = 0;
    }

    public void trim() {
        int size = this.size();
        short[] newArray = new short[size + 1];
        if (this.start <= this.end) {
            System.arraycopy(this.array, this.start, newArray, 0, this.end - this.start);
        } else {
            System.arraycopy(this.array, this.start, newArray, 0, this.length - this.start);
            System.arraycopy(this.array, 0, newArray, this.length - this.start, this.end);
        }
        this.start = 0;
        this.end = size;
        this.length = this.end + 1;
        this.array = newArray;
    }

    @Override
    public int size() {
        int apparentLength = this.end - this.start;
        return apparentLength >= 0 ? apparentLength : this.length + apparentLength;
    }
}

