/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractIntBigListIterator;
import it.unimi.dsi.fastutil.ints.IntBigListIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class IntBigListIterators {
    public static final EmptyBigListIterator EMPTY_BIG_LIST_ITERATOR = new EmptyBigListIterator();

    private IntBigListIterators() {
    }

    public static IntBigListIterator singleton(int element) {
        return new SingletonBigListIterator(element);
    }

    public static IntBigListIterator unmodifiable(IntBigListIterator i) {
        return new UnmodifiableBigListIterator(i);
    }

    public static IntBigListIterator asBigListIterator(IntListIterator i) {
        return new BigListIteratorListIterator(i);
    }

    public static class BigListIteratorListIterator
    extends AbstractIntBigListIterator {
        protected final IntListIterator i;

        protected BigListIteratorListIterator(IntListIterator i) {
            this.i = i;
        }

        private int intDisplacement(long n) {
            if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("This big iterator is restricted to 32-bit displacements");
            }
            return (int)n;
        }

        public void set(int ok) {
            this.i.set(ok);
        }

        public void add(int ok) {
            this.i.add(ok);
        }

        public int back(int n) {
            return this.i.back(n);
        }

        public long back(long n) {
            return this.i.back(this.intDisplacement(n));
        }

        public void remove() {
            this.i.remove();
        }

        public int skip(int n) {
            return this.i.skip(n);
        }

        public long skip(long n) {
            return this.i.skip(this.intDisplacement(n));
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public int nextInt() {
            return this.i.nextInt();
        }

        public int previousInt() {
            return this.i.previousInt();
        }

        public long nextIndex() {
            return this.i.nextIndex();
        }

        public long previousIndex() {
            return this.i.previousIndex();
        }
    }

    public static class UnmodifiableBigListIterator
    extends AbstractIntBigListIterator {
        protected final IntBigListIterator i;

        public UnmodifiableBigListIterator(IntBigListIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public int nextInt() {
            return this.i.nextInt();
        }

        public int previousInt() {
            return this.i.previousInt();
        }

        public long nextIndex() {
            return this.i.nextIndex();
        }

        public long previousIndex() {
            return this.i.previousIndex();
        }

        public Integer next() {
            return (Integer)this.i.next();
        }

        public Integer previous() {
            return (Integer)this.i.previous();
        }
    }

    private static class SingletonBigListIterator
    extends AbstractIntBigListIterator {
        private final int element;
        private int curr;

        public SingletonBigListIterator(int element) {
            this.element = element;
        }

        public boolean hasNext() {
            return this.curr == 0;
        }

        public boolean hasPrevious() {
            return this.curr == 1;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = 1;
            return this.element;
        }

        public int previousInt() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = 0;
            return this.element;
        }

        public long nextIndex() {
            return this.curr;
        }

        public long previousIndex() {
            return this.curr - 1;
        }
    }

    public static class EmptyBigListIterator
    extends AbstractIntBigListIterator
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptyBigListIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public int nextInt() {
            throw new NoSuchElementException();
        }

        public int previousInt() {
            throw new NoSuchElementException();
        }

        public long nextIndex() {
            return 0L;
        }

        public long previousIndex() {
            return -1L;
        }

        public long skip(long n) {
            return 0L;
        }

        public long back(long n) {
            return 0L;
        }

        public Object clone() {
            return EMPTY_BIG_LIST_ITERATOR;
        }

        private Object readResolve() {
            return EMPTY_BIG_LIST_ITERATOR;
        }
    }
}

