/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class IntSortedSets {
    public static final EmptySet EMPTY_SET = new EmptySet();

    private IntSortedSets() {
    }

    public static IntSortedSet singleton(int element) {
        return new Singleton(element);
    }

    public static IntSortedSet singleton(int element, IntComparator comparator) {
        return new Singleton(element, comparator);
    }

    public static IntSortedSet singleton(Object element) {
        return new Singleton((int)((Integer)element));
    }

    public static IntSortedSet singleton(Object element, IntComparator comparator) {
        return new Singleton((Integer)element, comparator);
    }

    public static IntSortedSet synchronize(IntSortedSet s) {
        return new SynchronizedSortedSet(s);
    }

    public static IntSortedSet synchronize(IntSortedSet s, Object sync) {
        return new SynchronizedSortedSet(s, sync);
    }

    public static IntSortedSet unmodifiable(IntSortedSet s) {
        return new UnmodifiableSortedSet(s);
    }

    public static class UnmodifiableSortedSet
    extends IntSets.UnmodifiableSet
    implements IntSortedSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final IntSortedSet sortedSet;

        protected UnmodifiableSortedSet(IntSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        public IntComparator comparator() {
            return this.sortedSet.comparator();
        }

        public IntSortedSet subSet(int from, int to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from, to));
        }

        public IntSortedSet headSet(int to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        public IntSortedSet tailSet(int from) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from));
        }

        public IntBidirectionalIterator iterator() {
            return IntIterators.unmodifiable(this.sortedSet.iterator());
        }

        public IntBidirectionalIterator iterator(int from) {
            return IntIterators.unmodifiable(this.sortedSet.iterator(from));
        }

        @Deprecated
        public IntBidirectionalIterator intIterator() {
            return this.iterator();
        }

        public int firstInt() {
            return this.sortedSet.firstInt();
        }

        public int lastInt() {
            return this.sortedSet.lastInt();
        }

        public Integer first() {
            return (Integer)this.sortedSet.first();
        }

        public Integer last() {
            return (Integer)this.sortedSet.last();
        }

        public IntSortedSet subSet(Integer from, Integer to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from, to));
        }

        public IntSortedSet headSet(Integer to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        public IntSortedSet tailSet(Integer from) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from));
        }
    }

    public static class SynchronizedSortedSet
    extends IntSets.SynchronizedSet
    implements IntSortedSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final IntSortedSet sortedSet;

        protected SynchronizedSortedSet(IntSortedSet s, Object sync) {
            super(s, sync);
            this.sortedSet = s;
        }

        protected SynchronizedSortedSet(IntSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IntComparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.comparator();
            }
        }

        public IntSortedSet subSet(int from, int to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from, to), this.sync);
        }

        public IntSortedSet headSet(int to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        public IntSortedSet tailSet(int from) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from), this.sync);
        }

        public IntBidirectionalIterator iterator() {
            return this.sortedSet.iterator();
        }

        public IntBidirectionalIterator iterator(int from) {
            return this.sortedSet.iterator(from);
        }

        @Deprecated
        public IntBidirectionalIterator intIterator() {
            return this.sortedSet.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int firstInt() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.firstInt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastInt() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.lastInt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer first() {
            Object object = this.sync;
            synchronized (object) {
                return (Integer)this.sortedSet.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer last() {
            Object object = this.sync;
            synchronized (object) {
                return (Integer)this.sortedSet.last();
            }
        }

        public IntSortedSet subSet(Integer from, Integer to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from, to), this.sync);
        }

        public IntSortedSet headSet(Integer to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        public IntSortedSet tailSet(Integer from) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from), this.sync);
        }
    }

    public static class Singleton
    extends IntSets.Singleton
    implements IntSortedSet,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        final IntComparator comparator;

        private Singleton(int element, IntComparator comparator) {
            super(element);
            this.comparator = comparator;
        }

        private Singleton(int element) {
            this(element, (IntComparator)null);
        }

        final int compare(int k1, int k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        @Deprecated
        public IntBidirectionalIterator intIterator() {
            return this.iterator();
        }

        public IntBidirectionalIterator iterator(int from) {
            IntBidirectionalIterator i = this.iterator();
            if (this.compare(this.element, from) <= 0) {
                i.next();
            }
            return i;
        }

        public IntComparator comparator() {
            return this.comparator;
        }

        public IntSortedSet subSet(int from, int to) {
            if (this.compare(from, this.element) <= 0 && this.compare(this.element, to) < 0) {
                return this;
            }
            return EMPTY_SET;
        }

        public IntSortedSet headSet(int to) {
            if (this.compare(this.element, to) < 0) {
                return this;
            }
            return EMPTY_SET;
        }

        public IntSortedSet tailSet(int from) {
            if (this.compare(from, this.element) <= 0) {
                return this;
            }
            return EMPTY_SET;
        }

        public int firstInt() {
            return this.element;
        }

        public int lastInt() {
            return this.element;
        }

        public Integer first() {
            return this.element;
        }

        public Integer last() {
            return this.element;
        }

        public IntSortedSet subSet(Integer from, Integer to) {
            return this.subSet((int)from, (int)to);
        }

        public IntSortedSet headSet(Integer to) {
            return this.headSet((int)to);
        }

        public IntSortedSet tailSet(Integer from) {
            return this.tailSet((int)from);
        }
    }

    public static class EmptySet
    extends IntSets.EmptySet
    implements IntSortedSet,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySet() {
        }

        public boolean remove(int ok) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public IntBidirectionalIterator intIterator() {
            return this.iterator();
        }

        public IntBidirectionalIterator iterator(int from) {
            return IntIterators.EMPTY_ITERATOR;
        }

        public IntSortedSet subSet(int from, int to) {
            return EMPTY_SET;
        }

        public IntSortedSet headSet(int from) {
            return EMPTY_SET;
        }

        public IntSortedSet tailSet(int to) {
            return EMPTY_SET;
        }

        public int firstInt() {
            throw new NoSuchElementException();
        }

        public int lastInt() {
            throw new NoSuchElementException();
        }

        public IntComparator comparator() {
            return null;
        }

        public IntSortedSet subSet(Integer from, Integer to) {
            return EMPTY_SET;
        }

        public IntSortedSet headSet(Integer from) {
            return EMPTY_SET;
        }

        public IntSortedSet tailSet(Integer to) {
            return EMPTY_SET;
        }

        public Integer first() {
            throw new NoSuchElementException();
        }

        public Integer last() {
            throw new NoSuchElementException();
        }

        public Object clone() {
            return EMPTY_SET;
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }
}

