/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.ints.AbstractInt2BooleanMap;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Int2BooleanOpenHashMap
extends AbstractInt2BooleanMap
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient int[] key;
    protected transient boolean[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Int2BooleanMap.FastEntrySet entries;
    protected volatile transient IntSet keys;
    protected volatile transient BooleanCollection values;

    public Int2BooleanOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new int[this.n];
        this.value = new boolean[this.n];
        this.used = new boolean[this.n];
    }

    public Int2BooleanOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Int2BooleanOpenHashMap() {
        this(16, 0.75f);
    }

    public Int2BooleanOpenHashMap(Map<? extends Integer, ? extends Boolean> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Int2BooleanOpenHashMap(Map<? extends Integer, ? extends Boolean> m) {
        this(m, 0.75f);
    }

    public Int2BooleanOpenHashMap(Int2BooleanMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Int2BooleanOpenHashMap(Int2BooleanMap m) {
        this(m, 0.75f);
    }

    public Int2BooleanOpenHashMap(int[] k, boolean[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Int2BooleanOpenHashMap(int[] k, boolean[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public boolean put(int k, boolean v) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                boolean oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Boolean put(Integer ok, Boolean ov) {
        boolean v = ov;
        int k = ok;
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                Boolean oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.key[pos]) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
        return last;
    }

    @Override
    public boolean remove(int k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                boolean v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Boolean remove(Object ok) {
        int k = (Integer)ok;
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                boolean v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public Boolean get(Integer ok) {
        int k = ok;
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public boolean get(int k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(int k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(boolean v) {
        boolean[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Int2BooleanMap.FastEntrySet int2BooleanEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public IntSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public BooleanCollection values() {
        if (this.values == null) {
            this.values = new AbstractBooleanCollection(){

                public BooleanIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Int2BooleanOpenHashMap.this.size;
                }

                public boolean contains(boolean v) {
                    return Int2BooleanOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Int2BooleanOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        int[] key = this.key;
        boolean[] value = this.value;
        int newMask = newN - 1;
        int[] newKey = new int[newN];
        boolean[] newValue = new boolean[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            int k = key[i];
            int pos = HashCommon.murmurHash3(k) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Int2BooleanOpenHashMap clone() {
        Int2BooleanOpenHashMap c;
        try {
            c = (Int2BooleanOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (int[])this.key.clone();
        c.value = (boolean[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = this.key[i];
            h += (t ^= this.value[i] ? 1231 : 1237);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int[] key = this.key;
        boolean[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeInt(key[e]);
            s.writeBoolean(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new int[this.n];
        int[] key = this.key;
        this.value = new boolean[this.n];
        boolean[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            int k = s.readInt();
            boolean v = s.readBoolean();
            pos = HashCommon.murmurHash3(k) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements BooleanIterator {
        public boolean nextBoolean() {
            return Int2BooleanOpenHashMap.this.value[this.nextEntry()];
        }

        public Boolean next() {
            return Int2BooleanOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractIntSet {
        private KeySet() {
        }

        public IntIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Int2BooleanOpenHashMap.this.size;
        }

        public boolean contains(int k) {
            return Int2BooleanOpenHashMap.this.containsKey(k);
        }

        public boolean remove(int k) {
            int oldSize = Int2BooleanOpenHashMap.this.size;
            Int2BooleanOpenHashMap.this.remove(k);
            return Int2BooleanOpenHashMap.this.size != oldSize;
        }

        public void clear() {
            Int2BooleanOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements IntIterator {
        public int nextInt() {
            return Int2BooleanOpenHashMap.this.key[this.nextEntry()];
        }

        public Integer next() {
            return Int2BooleanOpenHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSet<Int2BooleanMap.Entry>
    implements Int2BooleanMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Int2BooleanMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Int2BooleanMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int k = (Integer)e.getKey();
            int pos = HashCommon.murmurHash3(k) & Int2BooleanOpenHashMap.this.mask;
            while (Int2BooleanOpenHashMap.this.used[pos]) {
                if (Int2BooleanOpenHashMap.this.key[pos] == k) {
                    return Int2BooleanOpenHashMap.this.value[pos] == (Boolean)e.getValue();
                }
                pos = pos + 1 & Int2BooleanOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int k = (Integer)e.getKey();
            int pos = HashCommon.murmurHash3(k) & Int2BooleanOpenHashMap.this.mask;
            while (Int2BooleanOpenHashMap.this.used[pos]) {
                if (Int2BooleanOpenHashMap.this.key[pos] == k) {
                    Int2BooleanOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Int2BooleanOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Int2BooleanOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Int2BooleanOpenHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Int2BooleanMap.Entry> {
        final AbstractInt2BooleanMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractInt2BooleanMap.BasicEntry(0, false);
        }

        @Override
        public AbstractInt2BooleanMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Int2BooleanOpenHashMap.this.key[e];
            this.entry.value = Int2BooleanOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Int2BooleanMap.Entry> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public Int2BooleanMap.Entry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;

        private MapIterator() {
            this.pos = Int2BooleanOpenHashMap.this.n;
            this.last = -1;
            this.c = Int2BooleanOpenHashMap.this.size;
            boolean[] used = Int2BooleanOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                boolean[] used = Int2BooleanOpenHashMap.this.used;
                while (!used[this.pos = this.pos - 1 & Int2BooleanOpenHashMap.this.mask]) {
                }
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            --Int2BooleanOpenHashMap.this.size;
            if (Int2BooleanOpenHashMap.this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextEntry();
            }
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Int2BooleanMap.Entry,
    Map.Entry<Integer, Boolean> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Integer getKey() {
            return Int2BooleanOpenHashMap.this.key[this.index];
        }

        @Override
        public int getIntKey() {
            return Int2BooleanOpenHashMap.this.key[this.index];
        }

        @Override
        public Boolean getValue() {
            return Int2BooleanOpenHashMap.this.value[this.index];
        }

        @Override
        public boolean getBooleanValue() {
            return Int2BooleanOpenHashMap.this.value[this.index];
        }

        @Override
        public boolean setValue(boolean v) {
            boolean oldValue = Int2BooleanOpenHashMap.this.value[this.index];
            Int2BooleanOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Boolean setValue(Boolean v) {
            return this.setValue((boolean)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Int2BooleanOpenHashMap.this.key[this.index] == (Integer)e.getKey() && Int2BooleanOpenHashMap.this.value[this.index] == (Boolean)e.getValue();
        }

        @Override
        public int hashCode() {
            return Int2BooleanOpenHashMap.this.key[this.index] ^ (Int2BooleanOpenHashMap.this.value[this.index] ? 1231 : 1237);
        }

        public String toString() {
            return Int2BooleanOpenHashMap.this.key[this.index] + "=>" + Int2BooleanOpenHashMap.this.value[this.index];
        }
    }
}

