/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObject2ByteMap;
import it.unimi.dsi.fastutil.objects.AbstractObject2ByteSortedMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import it.unimi.dsi.fastutil.objects.Object2ByteSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Object2ByteLinkedOpenHashMap<K>
extends AbstractObject2ByteSortedMap<K>
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient K[] key;
    protected transient byte[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Object2ByteSortedMap.FastSortedEntrySet<K> entries;
    protected volatile transient ObjectSortedSet<K> keys;
    protected volatile transient ByteCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;

    public Object2ByteLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new Object[this.n];
        this.value = new byte[this.n];
        this.used = new boolean[this.n];
        this.link = new int[this.n];
    }

    public Object2ByteLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Object2ByteLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Object2ByteLinkedOpenHashMap(Map<? extends K, ? extends Byte> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Object2ByteLinkedOpenHashMap(Map<? extends K, ? extends Byte> m) {
        this(m, 0.75f);
    }

    public Object2ByteLinkedOpenHashMap(Object2ByteMap<K> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Object2ByteLinkedOpenHashMap(Object2ByteMap<K> m) {
        this(m, 0.75f);
    }

    public Object2ByteLinkedOpenHashMap(K[] k, byte[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Object2ByteLinkedOpenHashMap(K[] k, byte[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public byte put(K k, byte v) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k == null ? this.key[pos] == null : k.equals(this.key[pos])) {
                byte oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Byte put(K ok, Byte ov) {
        byte v = ov;
        K k = ok;
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k == null ? this.key[pos] == null : k.equals(this.key[pos])) {
                Byte oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    public byte add(K k, byte incr) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k == null ? this.key[pos] == null : k.equals(this.key[pos])) {
                byte oldValue = this.value[pos];
                int n = pos;
                this.value[n] = (byte)(this.value[n] + incr);
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = (byte)(this.defRetValue + incr);
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (this.key[pos] == null ? 142593372 : HashCommon.murmurHash3(this.key[pos].hashCode())) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
        this.key[last] = null;
    }

    @Override
    public byte removeByte(Object k) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k == null ? this.key[pos] == null : k.equals(this.key[pos])) {
                --this.size;
                this.fixPointers(pos);
                byte v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Byte remove(Object ok) {
        Object k = ok;
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k == null ? this.key[pos] == null : k.equals(this.key[pos])) {
                --this.size;
                this.fixPointers(pos);
                byte v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public byte getByte(Object k) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k == null ? this.key[pos] == null : k.equals(this.key[pos])) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(Object k) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k == null ? this.key[pos] == null : k.equals(this.key[pos])) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(byte v) {
        byte[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        ObjectArrays.fill(this.key, null);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        int next;
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    protected void fixPointers(int s, int d) {
        int next;
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = 0;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != s) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (s ^ d);
        int n2 = this.link[s] ^ j;
        this.link[n2] = this.link[n2] ^ (s ^ d);
        this.link[d] = this.link[s];
    }

    @Override
    public K firstKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public K lastKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public Object2ByteSortedMap<K> tailMap(K from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object2ByteSortedMap<K> headMap(K to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object2ByteSortedMap<K> subMap(K from, K to) {
        throw new UnsupportedOperationException();
    }

    public Object2ByteSortedMap.FastSortedEntrySet<K> object2ByteEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ObjectSortedSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ByteCollection values() {
        if (this.values == null) {
            this.values = new AbstractByteCollection(){

                public ByteIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Object2ByteLinkedOpenHashMap.this.size;
                }

                public boolean contains(byte v) {
                    return Object2ByteLinkedOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Object2ByteLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        K[] key = this.key;
        byte[] value = this.value;
        int newMask = newN - 1;
        Object[] newKey = new Object[newN];
        byte[] newValue = new byte[newN];
        boolean[] newUsed = new boolean[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            K k = key[i];
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ pos;
                newLink[pos] = newPrev;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1;
            }
            int t = i;
            i = link[i] ^ prev;
            prev = t;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Object2ByteLinkedOpenHashMap<K> clone() {
        Object2ByteLinkedOpenHashMap c;
        try {
            c = (Object2ByteLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (byte[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            if (this != this.key[i]) {
                t = this.key[i] == null ? 0 : this.key[i].hashCode();
            }
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        K[] key = this.key;
        byte[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeObject(key[e]);
            s.writeByte(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new Object[this.n];
        Object[] key = this.key;
        this.value = new byte[this.n];
        byte[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new int[this.n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            Object k = s.readObject();
            byte v = s.readByte();
            pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ pos;
                link[pos] = prev;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            link[pos] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = ~link[n];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ByteListIterator {
        public byte previousByte() {
            return Object2ByteLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public Byte previous() {
            return Object2ByteLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public void set(Byte ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Byte ok) {
            throw new UnsupportedOperationException();
        }

        public void set(byte v) {
            throw new UnsupportedOperationException();
        }

        public void add(byte v) {
            throw new UnsupportedOperationException();
        }

        public byte nextByte() {
            return Object2ByteLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        public Byte next() {
            return Object2ByteLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends AbstractObjectSortedSet<K> {
        private KeySet() {
        }

        @Override
        public ObjectBidirectionalIterator<K> iterator(K from) {
            return new KeyIterator(from);
        }

        @Override
        public ObjectBidirectionalIterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Object2ByteLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(Object k) {
            return Object2ByteLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(Object k) {
            int oldSize = Object2ByteLinkedOpenHashMap.this.size;
            Object2ByteLinkedOpenHashMap.this.remove(k);
            return Object2ByteLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Object2ByteLinkedOpenHashMap.this.clear();
        }

        @Override
        public K first() {
            if (Object2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Object2ByteLinkedOpenHashMap.this.key[Object2ByteLinkedOpenHashMap.this.first];
        }

        @Override
        public K last() {
            if (Object2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Object2ByteLinkedOpenHashMap.this.key[Object2ByteLinkedOpenHashMap.this.last];
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public final ObjectSortedSet<K> tailSet(K from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ObjectSortedSet<K> headSet(K to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ObjectSortedSet<K> subSet(K from, K to) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyIterator
    extends MapIterator
    implements ObjectListIterator<K> {
        public KeyIterator(K k) {
            super(k);
        }

        @Override
        public K previous() {
            return Object2ByteLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(K k) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public K next() {
            return Object2ByteLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSortedSet<Object2ByteMap.Entry<K>>
    implements Object2ByteSortedMap.FastSortedEntrySet<K> {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Object2ByteMap.Entry<K>> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Object2ByteMap.Entry<K>> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Object2ByteMap.Entry<K>> subSet(Object2ByteMap.Entry<K> fromElement, Object2ByteMap.Entry<K> toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Object2ByteMap.Entry<K>> headSet(Object2ByteMap.Entry<K> toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Object2ByteMap.Entry<K>> tailSet(Object2ByteMap.Entry<K> fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object2ByteMap.Entry<K> first() {
            if (Object2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Object2ByteLinkedOpenHashMap.this.first);
        }

        @Override
        public Object2ByteMap.Entry<K> last() {
            if (Object2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Object2ByteLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & Object2ByteLinkedOpenHashMap.this.mask;
            while (Object2ByteLinkedOpenHashMap.this.used[pos]) {
                if (k == null ? Object2ByteLinkedOpenHashMap.this.key[pos] == null : k.equals(Object2ByteLinkedOpenHashMap.this.key[pos])) {
                    return Object2ByteLinkedOpenHashMap.this.value[pos] == (Byte)e.getValue();
                }
                pos = pos + 1 & Object2ByteLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & Object2ByteLinkedOpenHashMap.this.mask;
            while (Object2ByteLinkedOpenHashMap.this.used[pos]) {
                if (k == null ? Object2ByteLinkedOpenHashMap.this.key[pos] == null : k.equals(Object2ByteLinkedOpenHashMap.this.key[pos])) {
                    Object2ByteLinkedOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Object2ByteLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Object2ByteLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Object2ByteLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Object2ByteMap.Entry<K>> iterator(Object2ByteMap.Entry<K> from) {
            return new EntryIterator(from.getKey());
        }

        @Override
        public ObjectBidirectionalIterator<Object2ByteMap.Entry<K>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Object2ByteMap.Entry<K>> fastIterator(Object2ByteMap.Entry<K> from) {
            return new FastEntryIterator(from.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Object2ByteMap.Entry<K>> {
        final AbstractObject2ByteMap.BasicEntry<K> entry;

        public FastEntryIterator() {
            this.entry = new AbstractObject2ByteMap.BasicEntry<Object>(null, 0);
        }

        public FastEntryIterator(K from) {
            super(from);
            this.entry = new AbstractObject2ByteMap.BasicEntry<Object>(null, 0);
        }

        @Override
        public AbstractObject2ByteMap.BasicEntry<K> next() {
            int e = this.nextEntry();
            this.entry.key = Object2ByteLinkedOpenHashMap.this.key[e];
            this.entry.value = Object2ByteLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractObject2ByteMap.BasicEntry<K> previous() {
            int e = this.previousEntry();
            this.entry.key = Object2ByteLinkedOpenHashMap.this.key[e];
            this.entry.value = Object2ByteLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Object2ByteMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object2ByteMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Object2ByteMap.Entry<K>> {
        public EntryIterator() {
        }

        public EntryIterator(K from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Object2ByteMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object2ByteMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        private MapIterator() {
            this.next = Object2ByteLinkedOpenHashMap.this.first;
        }

        private MapIterator(K from) {
            if (Object2ByteLinkedOpenHashMap.this.key[Object2ByteLinkedOpenHashMap.this.last] == null ? from == null : Object2ByteLinkedOpenHashMap.this.key[Object2ByteLinkedOpenHashMap.this.last].equals(from)) {
                this.prev = Object2ByteLinkedOpenHashMap.this.last;
                this.index = Object2ByteLinkedOpenHashMap.this.size;
            } else {
                int e;
                if (!Object2ByteLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Object2ByteLinkedOpenHashMap.this.first;
                while (!(Object2ByteLinkedOpenHashMap.this.key[e = this.nextEntry()] == null ? from == null : Object2ByteLinkedOpenHashMap.this.key[e].equals(from))) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Object2ByteLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Object2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Object2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Object2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Object2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Object2ByteLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Object2ByteLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Object2ByteLinkedOpenHashMap.this.link[n] = Object2ByteLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Object2ByteLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Object2ByteLinkedOpenHashMap.this.link[n] = Object2ByteLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Object2ByteLinkedOpenHashMap.this.mask;
                while (Object2ByteLinkedOpenHashMap.this.used[pos]) {
                    int slot = (Object2ByteLinkedOpenHashMap.this.key[pos] == null ? 142593372 : HashCommon.murmurHash3(Object2ByteLinkedOpenHashMap.this.key[pos].hashCode())) & Object2ByteLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Object2ByteLinkedOpenHashMap.this.mask;
                }
                if (!Object2ByteLinkedOpenHashMap.this.used[pos]) break;
                Object2ByteLinkedOpenHashMap.this.key[last] = Object2ByteLinkedOpenHashMap.this.key[pos];
                Object2ByteLinkedOpenHashMap.this.value[last] = Object2ByteLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Object2ByteLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Object2ByteLinkedOpenHashMap.this.used[last] = false;
            Object2ByteLinkedOpenHashMap.this.key[last] = null;
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Object2ByteMap.Entry<K>,
    Map.Entry<K, Byte> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public K getKey() {
            return Object2ByteLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Byte getValue() {
            return Object2ByteLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public byte getByteValue() {
            return Object2ByteLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public byte setValue(byte v) {
            byte oldValue = Object2ByteLinkedOpenHashMap.this.value[this.index];
            Object2ByteLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Byte setValue(Byte v) {
            return this.setValue((byte)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (Object2ByteLinkedOpenHashMap.this.key[this.index] == null ? e.getKey() == null : Object2ByteLinkedOpenHashMap.this.key[this.index].equals(e.getKey())) && Object2ByteLinkedOpenHashMap.this.value[this.index] == (Byte)e.getValue();
        }

        @Override
        public int hashCode() {
            return (Object2ByteLinkedOpenHashMap.this.key[this.index] == null ? 0 : Object2ByteLinkedOpenHashMap.this.key[this.index].hashCode()) ^ Object2ByteLinkedOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Object2ByteLinkedOpenHashMap.this.key[this.index] + "=>" + Object2ByteLinkedOpenHashMap.this.value[this.index];
        }
    }
}

