/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.longs.AbstractLongListIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongSortedSet;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongHash;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongLinkedOpenCustomHashSet
extends AbstractLongSortedSet
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient long[] key;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    protected LongHash.Strategy strategy;

    public LongLinkedOpenCustomHashSet(int expected, float f, LongHash.Strategy strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new long[this.n];
        this.used = new boolean[this.n];
        this.link = new int[this.n];
    }

    public LongLinkedOpenCustomHashSet(int expected, LongHash.Strategy strategy) {
        this(expected, 0.75f, strategy);
    }

    public LongLinkedOpenCustomHashSet(LongHash.Strategy strategy) {
        this(16, 0.75f, strategy);
    }

    public LongLinkedOpenCustomHashSet(Collection<? extends Long> c, float f, LongHash.Strategy strategy) {
        this(c.size(), f, strategy);
        this.addAll(c);
    }

    public LongLinkedOpenCustomHashSet(Collection<? extends Long> c, LongHash.Strategy strategy) {
        this(c, 0.75f, strategy);
    }

    public LongLinkedOpenCustomHashSet(LongCollection c, float f, LongHash.Strategy strategy) {
        this(c.size(), f, strategy);
        this.addAll(c);
    }

    public LongLinkedOpenCustomHashSet(LongCollection c, LongHash.Strategy strategy) {
        this(c, 0.75f, strategy);
    }

    public LongLinkedOpenCustomHashSet(LongIterator i, float f, LongHash.Strategy strategy) {
        this(16, f, strategy);
        while (i.hasNext()) {
            this.add(i.nextLong());
        }
    }

    public LongLinkedOpenCustomHashSet(LongIterator i, LongHash.Strategy strategy) {
        this(i, 0.75f, strategy);
    }

    public LongLinkedOpenCustomHashSet(Iterator<?> i, float f, LongHash.Strategy strategy) {
        this(LongIterators.asLongIterator(i), f, strategy);
    }

    public LongLinkedOpenCustomHashSet(Iterator<?> i, LongHash.Strategy strategy) {
        this(LongIterators.asLongIterator(i), strategy);
    }

    public LongLinkedOpenCustomHashSet(long[] a, int offset, int length, float f, LongHash.Strategy strategy) {
        this(length < 0 ? 0 : length, f, strategy);
        LongArrays.ensureOffsetLength(a, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a[offset + i]);
        }
    }

    public LongLinkedOpenCustomHashSet(long[] a, int offset, int length, LongHash.Strategy strategy) {
        this(a, offset, length, 0.75f, strategy);
    }

    public LongLinkedOpenCustomHashSet(long[] a, float f, LongHash.Strategy strategy) {
        this(a, 0, a.length, f, strategy);
    }

    public LongLinkedOpenCustomHashSet(long[] a, LongHash.Strategy strategy) {
        this(a, 0.75f, strategy);
    }

    public LongHash.Strategy strategy() {
        return this.strategy;
    }

    @Override
    public boolean add(long k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k)) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(k, this.key[pos])) {
                return false;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.strategy.hashCode(this.key[pos])) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
    }

    @Override
    public boolean remove(long k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k)) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(k, this.key[pos])) {
                --this.size;
                this.fixPointers(pos);
                this.shiftKeys(pos);
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean contains(long k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k)) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(k, this.key[pos])) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return this.used[pos];
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        int next;
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    protected void fixPointers(int s, int d) {
        int next;
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = 0;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != s) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (s ^ d);
        int n2 = this.link[s] ^ j;
        this.link[n2] = this.link[n2] ^ (s ^ d);
        this.link[d] = this.link[s];
    }

    @Override
    public long firstLong() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public long lastLong() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public LongSortedSet tailSet(long from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LongSortedSet headSet(long to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LongSortedSet subSet(long from, long to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LongComparator comparator() {
        return null;
    }

    @Override
    public LongBidirectionalIterator iterator(long from) {
        return new SetIterator(from);
    }

    @Override
    public LongBidirectionalIterator iterator() {
        return new SetIterator();
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        long[] key = this.key;
        int newMask = newN - 1;
        long[] newKey = new long[newN];
        boolean[] newUsed = new boolean[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            long k = key[i];
            int pos = HashCommon.murmurHash3(this.strategy.hashCode(k)) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ pos;
                newLink[pos] = newPrev;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1;
            }
            int t = i;
            i = link[i] ^ prev;
            prev = t;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public LongLinkedOpenCustomHashSet clone() {
        LongLinkedOpenCustomHashSet c;
        try {
            c = (LongLinkedOpenCustomHashSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (long[])this.key.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (int[])this.link.clone();
        c.strategy = this.strategy;
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.size;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            h += this.strategy.hashCode(this.key[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        LongBidirectionalIterator i = this.iterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            s.writeLong(i.nextLong());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new long[this.n];
        long[] key = this.key;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new int[this.n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            long k = s.readLong();
            pos = HashCommon.murmurHash3(this.strategy.hashCode(k)) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ pos;
                link[pos] = prev;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            link[pos] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = ~link[n];
        }
    }

    private void checkTable() {
    }

    private class SetIterator
    extends AbstractLongListIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        SetIterator() {
            this.next = LongLinkedOpenCustomHashSet.this.first;
        }

        SetIterator(long from) {
            if (LongLinkedOpenCustomHashSet.this.strategy.equals(LongLinkedOpenCustomHashSet.this.key[LongLinkedOpenCustomHashSet.this.last], from)) {
                this.prev = LongLinkedOpenCustomHashSet.this.last;
                this.index = LongLinkedOpenCustomHashSet.this.size;
            } else {
                long k;
                if (!LongLinkedOpenCustomHashSet.this.contains(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = LongLinkedOpenCustomHashSet.this.first;
                while (!LongLinkedOpenCustomHashSet.this.strategy.equals(k = this.nextLong(), from)) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = LongLinkedOpenCustomHashSet.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return LongLinkedOpenCustomHashSet.this.key[this.curr];
        }

        public long previousLong() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = LongLinkedOpenCustomHashSet.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return LongLinkedOpenCustomHashSet.this.key[this.curr];
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = LongLinkedOpenCustomHashSet.this.link[this.curr] ^ this.next;
            } else {
                this.next = LongLinkedOpenCustomHashSet.this.link[this.curr] ^ this.prev;
            }
            --LongLinkedOpenCustomHashSet.this.size;
            if (this.prev == -1) {
                LongLinkedOpenCustomHashSet.this.first = this.next;
            } else {
                int n = this.prev;
                LongLinkedOpenCustomHashSet.this.link[n] = LongLinkedOpenCustomHashSet.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                LongLinkedOpenCustomHashSet.this.last = this.prev;
            } else {
                int n = this.next;
                LongLinkedOpenCustomHashSet.this.link[n] = LongLinkedOpenCustomHashSet.this.link[n] ^ (this.curr ^ this.prev);
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & LongLinkedOpenCustomHashSet.this.mask;
                while (LongLinkedOpenCustomHashSet.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(LongLinkedOpenCustomHashSet.this.strategy.hashCode(LongLinkedOpenCustomHashSet.this.key[pos])) & LongLinkedOpenCustomHashSet.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & LongLinkedOpenCustomHashSet.this.mask;
                }
                if (!LongLinkedOpenCustomHashSet.this.used[pos]) break;
                LongLinkedOpenCustomHashSet.this.key[last] = LongLinkedOpenCustomHashSet.this.key[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                LongLinkedOpenCustomHashSet.this.fixPointers(pos, last);
            }
            LongLinkedOpenCustomHashSet.this.used[last] = false;
            this.curr = -1;
        }
    }
}

