/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.booleans.AbstractBooleanBigListIterator;
import it.unimi.dsi.fastutil.booleans.BooleanBigListIterator;
import it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class BooleanBigListIterators {
    public static final EmptyBigListIterator EMPTY_BIG_LIST_ITERATOR = new EmptyBigListIterator();

    private BooleanBigListIterators() {
    }

    public static BooleanBigListIterator singleton(boolean element) {
        return new SingletonBigListIterator(element);
    }

    public static BooleanBigListIterator unmodifiable(BooleanBigListIterator i) {
        return new UnmodifiableBigListIterator(i);
    }

    public static BooleanBigListIterator asBigListIterator(BooleanListIterator i) {
        return new BigListIteratorListIterator(i);
    }

    public static class BigListIteratorListIterator
    extends AbstractBooleanBigListIterator {
        protected final BooleanListIterator i;

        protected BigListIteratorListIterator(BooleanListIterator i) {
            this.i = i;
        }

        private int intDisplacement(long n) {
            if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("This big iterator is restricted to 32-bit displacements");
            }
            return (int)n;
        }

        public void set(boolean ok) {
            this.i.set(ok);
        }

        public void add(boolean ok) {
            this.i.add(ok);
        }

        public int back(int n) {
            return this.i.back(n);
        }

        public long back(long n) {
            return this.i.back(this.intDisplacement(n));
        }

        public void remove() {
            this.i.remove();
        }

        public int skip(int n) {
            return this.i.skip(n);
        }

        public long skip(long n) {
            return this.i.skip(this.intDisplacement(n));
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public boolean nextBoolean() {
            return this.i.nextBoolean();
        }

        public boolean previousBoolean() {
            return this.i.previousBoolean();
        }

        public long nextIndex() {
            return this.i.nextIndex();
        }

        public long previousIndex() {
            return this.i.previousIndex();
        }
    }

    public static class UnmodifiableBigListIterator
    extends AbstractBooleanBigListIterator {
        protected final BooleanBigListIterator i;

        public UnmodifiableBigListIterator(BooleanBigListIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public boolean nextBoolean() {
            return this.i.nextBoolean();
        }

        public boolean previousBoolean() {
            return this.i.previousBoolean();
        }

        public long nextIndex() {
            return this.i.nextIndex();
        }

        public long previousIndex() {
            return this.i.previousIndex();
        }

        public Boolean next() {
            return (Boolean)this.i.next();
        }

        public Boolean previous() {
            return (Boolean)this.i.previous();
        }
    }

    private static class SingletonBigListIterator
    extends AbstractBooleanBigListIterator {
        private final boolean element;
        private int curr;

        public SingletonBigListIterator(boolean element) {
            this.element = element;
        }

        public boolean hasNext() {
            return this.curr == 0;
        }

        public boolean hasPrevious() {
            return this.curr == 1;
        }

        public boolean nextBoolean() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = 1;
            return this.element;
        }

        public boolean previousBoolean() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = 0;
            return this.element;
        }

        public long nextIndex() {
            return this.curr;
        }

        public long previousIndex() {
            return this.curr - 1;
        }
    }

    public static class EmptyBigListIterator
    extends AbstractBooleanBigListIterator
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptyBigListIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public boolean nextBoolean() {
            throw new NoSuchElementException();
        }

        public boolean previousBoolean() {
            throw new NoSuchElementException();
        }

        public long nextIndex() {
            return 0L;
        }

        public long previousIndex() {
            return -1L;
        }

        public long skip(long n) {
            return 0L;
        }

        public long back(long n) {
            return 0L;
        }

        public Object clone() {
            return EMPTY_BIG_LIST_ITERATOR;
        }

        private Object readResolve() {
            return EMPTY_BIG_LIST_ITERATOR;
        }
    }
}

