/* Generic definitions */




/* Assertions (useful to generate conditional code) */
/* Current type and class (and size, if applicable) */
/* Value methods */
/* Interfaces (keys) */
/* Interfaces (values) */
/* Abstract implementations (keys) */
/* Abstract implementations (values) */
/* Static containers (keys) */
/* Static containers (values) */
/* Implementations */
/* Synchronized wrappers */
/* Unmodifiable wrappers */
/* Other wrappers */
/* Methods (keys) */
/* Methods (values) */
/* Methods (keys/values) */
/* Methods that have special names depending on keys (but the special names depend on values) */
/* Equality */
/* Object/Reference-only definitions (keys) */
/* Object/Reference-only definitions (values) */
/* Primitive-type-only definitions (values) */
/*		 
 * Copyright (C) 2002-2011 Sebastiano Vigna 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License. 
 */
package it.unimi.dsi.fastutil.objects;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import static it.unimi.dsi.fastutil.HashCommon.arraySize;
import static it.unimi.dsi.fastutil.HashCommon.maxFill;
import java.util.Map;
import java.util.NoSuchElementException;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Comparator;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;





import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
/**  A type-specific linked hash map with with a fast, small-footprint implementation.
 *
 * <P>Instances of this class use a hash table to represent a map. The table is
 * enlarged as needed by doubling its size when new entries are created, but it is <em>never</em> made
 * smaller (even on a {@link #clear()}). A family of {@linkplain #trim() trimming
 * methods} lets you control the size of the table; this is particularly useful
 * if you reuse instances of this class.
 *
 * <P>Iterators created by this map will enumerate pairs in the same order in which they
 * have been added to the set (addition of pairs whose key is already present 
 * in the set doea not change the iteration order). Note that this order has nothing in common with the natural
 * order of the keys.
 *
 * <P>This class implements the interface of a sorted map, so to allow easy
 * access of the iteration order: for instance, you can get the first key
 * in iteration order with {@link #firstKey()} without having to create an
 * iterator; however, this class partially violates the {@link java.util.SortedMap}
 * contract because all submap methods throw an exception and {@link
 * #comparator()} returns always <code>null</code>.
 *
 * <P>The iterators provided by the views of this class using are type-specific
 * {@linkplain java.util.ListIterator list iterators}. However, creation of an
 * iterator using a starting point is going to be very expensive, as the chosen
 * starting point must be linearly searched for, unless it is {@link #lastKey()},
 * in which case the iterator is created in constant time.
 *
 * <P>Note that deletions in a linked map are very expensive, as they usually
 * require scanning the list until the element to be removed and the elements
 * shifted because of the removal are found.
 *
 * <p><strong>Warning:</strong> The implementation of this class has significantly
 * changed in <code>fastutil</code> 6.1.0. Please read the
 * comments about this issue in the section &ldquo;Faster Hash Tables&rdquo; of the <a href="../../../../../overview-summary.html">overview</a>.
 *
 * @see Hash
 * @see HashCommon
 */
public class Object2ShortLinkedOpenCustomHashMap <K> extends AbstractObject2ShortSortedMap <K> implements java.io.Serializable, Cloneable, Hash {
    public static final long serialVersionUID = 0L;
 private static final boolean ASSERTS = false;
 /** The array of keys. */
 protected transient K key[];
 /** The array of values. */
 protected transient short value[];
 /** The array telling whether a position is used. */
 protected transient boolean used[];
 /** The acceptable load factor. */
 protected final float f;
 /** The current table size. */
 protected transient int n;
 /** Threshold after which we rehash. It must be the table size times {@link #f}. */
 protected transient int maxFill;
 /** The mask for wrapping a position counter. */
 protected transient int mask;
 /** Number of entries in the set. */
 protected int size;
 /** Cached set of entries. */
 protected transient volatile FastSortedEntrySet <K> entries;
 /** Cached set of keys. */
 protected transient volatile ObjectSortedSet <K> keys;
 /** Cached collection of values. */
 protected transient volatile ShortCollection values;
 /** The index of the first entry in iteration order. It is valid iff {@link #size} is nonzero; otherwise, it contains -1. */
 protected transient int first = -1;
 /** The index of the last entry in iteration order. It is valid iff {@link #size} is nonzero; otherwise, it contains -1. */
 protected transient int last = -1;
 /** For each entry, the next and the previous entry in iteration order
	exclusive-or'd together. It is valid only on {@link Hash#OCCUPIED}
	entries. The first and the last entry contain the actual successor and
	predecessor, respectively, exclusived-or'd with -1. */
 protected transient int link[];
 /** The hash strategy of this custom map. */
 protected Strategy <K> strategy;
 /** Creates a new hash map.
	 *
	 * <p>The actual table size will be the least power of two greater than <code>expected</code>/<code>f</code>.
	 *
	 * @param expected the expected number of elements in the hash set. 
	 * @param f the load factor.
	 * @param strategy the strategy.
	 */
 @SuppressWarnings("unchecked")
 public Object2ShortLinkedOpenCustomHashMap( final int expected, final float f, final Strategy<K> strategy ) {
  this.strategy = strategy;
  if ( f <= 0 || f > 1 ) throw new IllegalArgumentException( "Load factor must be greater than 0 and smaller than or equal to 1" );
  if ( expected < 0 ) throw new IllegalArgumentException( "The expected number of elements must be nonnegative" );
  this.f = f;
  n = arraySize( expected, f );
  mask = n - 1;
  maxFill = maxFill( n, f );
  key = (K[]) new Object[ n ];
  value = new short[ n ];
  used = new boolean[ n ];
  link = new int[ n ];
 }
 /** Creates a new hash map with {@link Hash#DEFAULT_LOAD_FACTOR} as load factor.
	 *
	 * @param expected the expected number of elements in the hash map.
	 * @param strategy the strategy.
	 */
 public Object2ShortLinkedOpenCustomHashMap( final int expected, final Strategy <K> strategy ) {
  this( expected, DEFAULT_LOAD_FACTOR, strategy );
 }
 /** Creates a new hash map with initial expected {@link Hash#DEFAULT_INITIAL_SIZE} entries
	 * and {@link Hash#DEFAULT_LOAD_FACTOR} as load factor.
	 * @param strategy the strategy.
	 */
 public Object2ShortLinkedOpenCustomHashMap( final Strategy<K> strategy ) {
  this( DEFAULT_INITIAL_SIZE, DEFAULT_LOAD_FACTOR, strategy );
 }
 /** Creates a new hash map copying a given one.
	 *
	 * @param m a {@link Map} to be copied into the new hash map. 
	 * @param f the load factor.
	 * @param strategy the strategy.
	 */
 public Object2ShortLinkedOpenCustomHashMap( final Map<? extends K, ? extends Short> m, final float f, final Strategy<K> strategy ) {
  this( m.size(), f, strategy );
  putAll( m );
 }
 /** Creates a new hash map with {@link Hash#DEFAULT_LOAD_FACTOR} as load factor copying a given one.
	 *
	 * @param m a {@link Map} to be copied into the new hash map. 
	 * @param strategy the strategy.
	 */
 public Object2ShortLinkedOpenCustomHashMap( final Map<? extends K, ? extends Short> m, final Strategy<K> strategy ) {
  this( m, DEFAULT_LOAD_FACTOR, strategy );
 }
 /** Creates a new hash map copying a given type-specific one.
	 *
	 * @param m a type-specific map to be copied into the new hash map. 
	 * @param f the load factor.
	 * @param strategy the strategy.
	 */
 public Object2ShortLinkedOpenCustomHashMap( final Object2ShortMap <K> m, final float f, final Strategy<K> strategy ) {
  this( m.size(), f, strategy );
  putAll( m );
 }
 /** Creates a new hash map with {@link Hash#DEFAULT_LOAD_FACTOR} as load factor copying a given type-specific one.
	 *
	 * @param m a type-specific map to be copied into the new hash map. 
	 * @param strategy the strategy.
	 */
 public Object2ShortLinkedOpenCustomHashMap( final Object2ShortMap <K> m, final Strategy <K> strategy ) {
  this( m, DEFAULT_LOAD_FACTOR, strategy );
 }
 /** Creates a new hash map using the elements of two parallel arrays.
	 *
	 * @param k the array of keys of the new hash map.
	 * @param v the array of corresponding values in the new hash map.
	 * @param f the load factor.
	 * @param strategy the strategy.
	 * @throws IllegalArgumentException if <code>k</code> and <code>v</code> have different lengths.
	 */
 public Object2ShortLinkedOpenCustomHashMap( final K[] k, final short v[], final float f, final Strategy<K> strategy ) {
  this( k.length, f, strategy );
  if ( k.length != v.length ) throw new IllegalArgumentException( "The key array and the value array have different lengths (" + k.length + " and " + v.length + ")" );
  for( int i = 0; i < k.length; i++ ) this.put( k[ i ], v[ i ] );
 }
 /** Creates a new hash map with {@link Hash#DEFAULT_LOAD_FACTOR} as load factor using the elements of two parallel arrays.
	 *
	 * @param k the array of keys of the new hash map.
	 * @param v the array of corresponding values in the new hash map.
	 * @param strategy the strategy.
	 * @throws IllegalArgumentException if <code>k</code> and <code>v</code> have different lengths.
	 */
 public Object2ShortLinkedOpenCustomHashMap( final K[] k, final short v[], final Strategy<K> strategy ) {
  this( k, v, DEFAULT_LOAD_FACTOR, strategy );
 }
 /** Returns the hashing strategy.
	 *
	 * @return the hashing strategy of this custom hash map.
	 */
 public Strategy<K> strategy() {
  return strategy;
 }
 /*
	 * The following methods implements some basic building blocks used by
	 * all accessors. They are (and should be maintained) identical to those used in OpenHashSet.drv.
	 */
 public short put(final K k, final short v) {
  // The starting point.
  int pos = ( it.unimi.dsi.fastutil.HashCommon.murmurHash3( strategy.hashCode(k) ) ) & mask;
  // There's always an unused entry.
  while( used[ pos ] ) {
   if ( ( strategy.equals( (k), (key[ pos ]) ) ) ) {
    final short oldValue = value[ pos ];
    value[ pos ] = v;
    return oldValue;
   }
   pos = ( pos + 1 ) & mask;
  }
  used[ pos ] = true;
  key[ pos ] = k;
  value[ pos ] = v;
  if ( size == 0 ) {
   first = last = pos;
   link[ pos ] = 0;
  }
  else {
   link[ last ] ^= pos ^ -1;
   link[ pos ] = last ^ -1;
   last = pos;
  }
  if ( ++size >= maxFill ) rehash( arraySize( size + 1, f ) );
  if ( ASSERTS ) checkTable();
  return defRetValue;
 }
 public Short put( final K ok, final Short ov ) {
  final short v = ((ov).shortValue());
  final K k = (ok);
  // The starting point.
  int pos = ( it.unimi.dsi.fastutil.HashCommon.murmurHash3( strategy.hashCode(k) ) ) & mask;
  // There's always an unused entry.
  while( used[ pos ] ) {
   if ( ( strategy.equals( (k), (key[ pos ]) ) ) ) {
    final Short oldValue = (Short.valueOf(value[ pos ]));
    value[ pos ] = v;
    return oldValue;
   }
   pos = ( pos + 1 ) & mask;
  }
  used[ pos ] = true;
  key[ pos ] = k;
  value[ pos ] = v;
  if ( size == 0 ) {
   first = last = pos;
   link[ pos ] = 0;
  }
  else {
   link[ last ] ^= pos ^ -1;
   link[ pos ] = last ^ -1;
   last = pos;
  }
  if ( ++size >= maxFill ) rehash( arraySize( size + 1, f ) );
  if ( ASSERTS ) checkTable();
  return (null);
 }
 /** Shifts left entries with the specified hash code, starting at the specified position,
	 * and empties the resulting free entry.
	 *
	 * @param pos a starting position.
	 */
 protected final void shiftKeys( int pos ) {
  // Shift entries with the same hash.
  int last, slot;
  for(;;) {
   pos = ( ( last = pos ) + 1 ) & mask;
   while( used[ pos ] ) {
    slot = ( it.unimi.dsi.fastutil.HashCommon.murmurHash3( strategy.hashCode(key[ pos ]) ) ) & mask;
    if ( last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos ) break;
    pos = ( pos + 1 ) & mask;
   }
   if ( ! used[ pos ] ) break;
   key[ last ] = key[ pos ];
   value[ last ] = value[ pos ];
   fixPointers( pos, last );
  }
  used[ last ] = false;
  key[ last ] = null;
 }
 @SuppressWarnings("unchecked")
 public short removeShort( final Object k ) {
  // The starting point.
  int pos = ( it.unimi.dsi.fastutil.HashCommon.murmurHash3( strategy.hashCode((K) k) ) ) & mask;
  // There's always an unused entry.
  while( used[ pos ] ) {
   if ( ( strategy.equals( ((K) k), (key[ pos ]) ) ) ) {
    size--;
    fixPointers( pos );
    final short v = value[ pos ];
    shiftKeys( pos );
    return v;
   }
   pos = ( pos + 1 ) & mask;
  }
  return defRetValue;
 }
 @SuppressWarnings("unchecked")
 public Short remove( final Object ok ) {
  final K k = (K) (ok);
  // The starting point.
  int pos = ( it.unimi.dsi.fastutil.HashCommon.murmurHash3( strategy.hashCode(k) ) ) & mask;
  // There's always an unused entry.
  while( used[ pos ] ) {
   if ( ( strategy.equals( (k), (key[ pos ]) ) ) ) {
    size--;
    fixPointers( pos );
    final short v = value[ pos ];
    shiftKeys( pos );
    return (Short.valueOf(v));
   }
   pos = ( pos + 1 ) & mask;
  }
  return (null);
 }
 @SuppressWarnings("unchecked")
 public short getShort( final Object k ) {
  // The starting point.
  int pos = ( it.unimi.dsi.fastutil.HashCommon.murmurHash3( strategy.hashCode((K) k) ) ) & mask;
  // There's always an unused entry.
  while( used[ pos ] ) {
   if ( ( strategy.equals( ((K) k), (key[ pos ]) ) ) ) return value[ pos ];
   pos = ( pos + 1 ) & mask;
  }
  return defRetValue;
 }
 @SuppressWarnings("unchecked")
 public boolean containsKey( final Object k ) {
  // The starting point.
  int pos = ( it.unimi.dsi.fastutil.HashCommon.murmurHash3( strategy.hashCode((K) k) ) ) & mask;
  // There's always an unused entry.
  while( used[ pos ] ) {
   if ( ( strategy.equals( ((K) k), (key[ pos ]) ) ) ) return true;
   pos = ( pos + 1 ) & mask;
  }
  return false;
 }
 public boolean containsValue( final short v ) {
  final short value[] = this.value;
  final boolean used[] = this.used;
  for( int i = n; i-- != 0; ) if ( used[ i ] && ( (value[ i ]) == (v) ) ) return true;
  return false;
 }
 /* Removes all elements from this map.
	 *
	 * <P>To increase object reuse, this method does not change the table size.
	 * If you want to reduce the table size, you must use {@link #trim()}.
	 *
	 */
 public void clear() {
  if ( size == 0 ) return;
  size = 0;
  BooleanArrays.fill( used, false );
  // We null all object entries so that the garbage collector can do its work.
  ObjectArrays.fill( key, null );
  first = last = -1;
 }
 public int size() {
  return size;
 }
 public boolean isEmpty() {
  return size == 0;
 }
 /** A no-op for backward compatibility.
	 * 
	 * @param growthFactor unused.
	 * @deprecated Since <code>fastutil</code> 6.1.0, hash tables are doubled when they are too full.
	 */
 @Deprecated
 public void growthFactor( int growthFactor ) {}
 /** Gets the growth factor (2).
	 *
	 * @return the growth factor of this set, which is fixed (2).
	 * @see #growthFactor(int)
	 * @deprecated Since <code>fastutil</code> 6.1.0, hash tables are doubled when they are too full.
	 */
 @Deprecated
 public int growthFactor() {
  return 16;
 }
 /** The entry class for a hash map does not record key and value, but
	 * rather the position in the hash table of the corresponding entry. This
	 * is necessary so that calls to {@link java.util.Map.Entry#setValue(Object)} are reflected in
	 * the map */
 private final class MapEntry implements Object2ShortMap.Entry <K>, Map.Entry<K, Short> {
  private int index;
  MapEntry( final int index ) {
   this.index = index;
  }
  public K getKey() {
   return (key[ index ]);
  }
  public Short getValue() {
   return (Short.valueOf(value[ index ]));
  }
  public short getShortValue() {
   return value[ index ];
  }
  public short setValue( final short v ) {
   final short oldValue = value[ index ];
   value[ index ] = v;
   return oldValue;
  }
  public Short setValue( final Short v ) {
   return (Short.valueOf(setValue( ((v).shortValue()) )));
  }
  @SuppressWarnings("unchecked")
  public boolean equals( final Object o ) {
   if (!(o instanceof Map.Entry)) return false;
   Map.Entry<K, Short> e = (Map.Entry<K, Short>)o;
   return ( strategy.equals( (key[ index ]), ((e.getKey())) ) ) && ( (value[ index ]) == (((e.getValue()).shortValue())) );
  }
  public int hashCode() {
   return ( strategy.hashCode(key[ index ]) ) ^ (value[ index ]);
  }
  public String toString() {
   return key[ index ] + "=>" + value[ index ];
  }
 }
 /** Modifies the {@link #link} vector so that the given entry is removed.
	 *
	 * <P>If the given entry is the first or the last one, this method will complete
	 * in constant time; otherwise, it will have to search for the given entry.
	 *
	 * @param i the index of an entry. 
	 */
 protected void fixPointers( final int i ) {
  if ( size == 0 ) {
   first = last = -1;
   return;
  }
  if ( first == i ) {
   first = link[ i ] ^ -1;
   link[ first ] ^= i ^ -1;
   return;
  }
  if ( last == i ) {
   last = link[ i ] ^ -1;
   link[ last ] ^= i ^ -1;
   return;
  }
  int j = first, prev = -1, next;
  while( ( next = link[ j ] ^ prev ) != i ) {
   prev = j;
   j = next;
  }
  link[ j ] ^= link[ i ] ^ i ^ j;
  link[ link[ i ] ^ j ] ^= i ^ j;
 }
 /** Modifies the {@link #link} vector for a shift from s to d.
	 *
	 * <P>If the given entry is the first or the last one, this method will complete
	 * in constant time; otherwise, it will have to search for the given entry.
	 *
	 * @param s the source position.
	 * @param d the destination position.
	 */
 protected void fixPointers( int s, int d ) {
  if ( size == 1 ) {
   first = last = d;
   link[ d ] = 0;
   return;
  }
  if ( first == s ) {
   first = d;
   link[ link[ s ] ^ -1 ] ^= s ^ d;
   link[ d ] = link[ s ];
   return;
  }
  if ( last == s ) {
   last = d;
   link[ link[ s ] ^ -1 ] ^= s ^ d;
   link[ d ] = link[ s ];
   return;
  }
  int j = first, prev = -1, next;
  while( ( next = link[ j ] ^ prev ) != s ) {
   prev = j;
   j = next;
  }
  link[ j ] ^= s ^ d;
  link[ link[ s ] ^ j ] ^= s ^ d;
  link[ d ] = link[ s ];
 }
 /** Returns the first key of this map in iteration order.
	 *
	 * @return the first key in iteration order.
	 */
 public K firstKey() {
  if ( size == 0 ) throw new NoSuchElementException();
  return key[ first ];
 }
 /** Returns the last key of this map in iteration order.
	 *
	 * @return the last key in iteration order.
	 */
 public K lastKey() {
  if ( size == 0 ) throw new NoSuchElementException();
  return key[ last ];
 }
 public Comparator <? super K> comparator() { return null; }
 public Object2ShortSortedMap <K> tailMap( K from ) { throw new UnsupportedOperationException(); }
 public Object2ShortSortedMap <K> headMap( K to ) { throw new UnsupportedOperationException(); }
 public Object2ShortSortedMap <K> subMap( K from, K to ) { throw new UnsupportedOperationException(); }
 /** A list iterator over a linked map.
	 *
	 * <P>This class provides a list iterator over a linked hash map. The empty constructor runs in 
	 * constant time. The one-argument constructor needs to search for the given key, but it is 
	 * optimized for the case of {@link java.util.SortedMap#lastKey()}, in which case runs in constant time, too.
	 */
 private class MapIterator {
  /** The entry that will be returned by the next call to {@link java.util.ListIterator#previous()} (or <code>null</code> if no previous entry exists). */
  int prev = -1;
  /** The entry that will be returned by the next call to {@link java.util.ListIterator#next()} (or <code>null</code> if no next entry exists). */
  int next = -1;
  /** The last entry that was returned (or -1 if we did not iterate or used {@link java.util.Iterator#remove()}). */
  int curr = -1;
  /** The current index (in the sense of a {@link java.util.ListIterator}). Note that this value is not meaningful when this iterator has been created using the nonempty constructor.*/
  int index = 0;
  private MapIterator() {
   next = first;
  }
  private MapIterator( final K from ) {
   if ( ( strategy.equals( (key[ last ]), (from) ) ) ) {
    prev = last;
    index = size;
   }
   else {
    if ( ! Object2ShortLinkedOpenCustomHashMap.this.containsKey( from ) ) throw new IllegalArgumentException( "The key " + from + " does not belong to this set." );
    next = first;
    int e;
    do e = nextEntry(); while( ! ( strategy.equals( (key[ e ]), (from) ) ) );
    curr = -1;
   }
  }
  public boolean hasNext() { return next != -1; }
  public boolean hasPrevious() { return prev != -1; }
  public int nextIndex() {
   return index;
  }
  public int previousIndex() {
   return index - 1;
  }
  public int nextEntry() {
   if ( ! hasNext() ) return size();
   curr = next;
   next = link[ curr ] ^ prev;
   prev = curr;
   index++;
   return curr;
  }
  public int previousEntry() {
   if ( ! hasPrevious() ) return -1;
   curr = prev;
   prev = link[ curr ] ^ next;
   next = curr;
   index--;
   return curr;
  }
  @SuppressWarnings("unchecked")
  public void remove() {
   if ( curr == -1 ) throw new IllegalStateException();
   if ( curr == prev ) {
    /* If the last operation was a next(), we are removing an entry that preceeds
				   the current index, and thus we must decrement it. */
    index--;
    prev = link[ curr ] ^ next;
   }
   else next = link[ curr ] ^ prev; // curr == next
   size--;
   /* Now we manually fix the pointers. Because of our knowledge of next
			   and prev, this is going to be faster than calling fixPointers(). */
   if ( prev == -1 ) first = next;
   else link[ prev ] ^= curr ^ next;
   if ( next == -1 ) last = prev;
   else link[ next ] ^= curr ^ prev;
   int last, slot, pos = curr;
   // We have to horribly duplicated the shiftKeys() code because we need to update next/prev.			
   for(;;) {
    pos = ( ( last = pos ) + 1 ) & mask;
    while( used[ pos ] ) {
     slot = ( it.unimi.dsi.fastutil.HashCommon.murmurHash3( strategy.hashCode(key[ pos ]) ) ) & mask;
     if ( last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos ) break;
     pos = ( pos + 1 ) & mask;
    }
    if ( ! used[ pos ] ) break;
    key[ last ] = key[ pos ];
    value[ last ] = value[ pos ];
    if ( next == pos ) next = last;
    if ( prev == pos ) prev = last;
    fixPointers( pos, last );
   }
   used[ last ] = false;
   key[ last ] = null;
   curr = -1;
  }
  public int skip( final int n ) {
   int i = n;
   while( i-- != 0 && hasNext() ) nextEntry();
   return n - i - 1;
  }
  public int back( final int n ) {
   int i = n;
   while( i-- != 0 && hasPrevious() ) previousEntry();
   return n - i - 1;
  }
 }
 private class EntryIterator extends MapIterator implements ObjectListIterator<Object2ShortMap.Entry <K> > {
  public EntryIterator() {}
  public EntryIterator( K from ) {
   super( from );
  }
  public MapEntry next() {
   return new MapEntry( nextEntry() );
  }
  public MapEntry previous() {
   return new MapEntry( previousEntry() );
  }
  public void set( Object2ShortMap.Entry <K> ok ) { throw new UnsupportedOperationException(); }
  public void add( Object2ShortMap.Entry <K> ok ) { throw new UnsupportedOperationException(); }
 }
 private class FastEntryIterator extends MapIterator implements ObjectListIterator<Object2ShortMap.Entry <K> > {
  final BasicEntry <K> entry = new BasicEntry <K> ( (null), ((short)0) );
  public FastEntryIterator() {}
  public FastEntryIterator( K from ) {
   super( from );
  }
  public BasicEntry <K> next() {
   final int e = nextEntry();
   entry.key = key[ e ];
   entry.value = value[ e ];
   return entry;
  }
  public BasicEntry <K> previous() {
   final int e = previousEntry();
   entry.key = key[ e ];
   entry.value = value[ e ];
   return entry;
  }
  public void set( Object2ShortMap.Entry <K> ok ) { throw new UnsupportedOperationException(); }
  public void add( Object2ShortMap.Entry <K> ok ) { throw new UnsupportedOperationException(); }
 }
 private final class MapEntrySet extends AbstractObjectSortedSet<Object2ShortMap.Entry <K> > implements FastSortedEntrySet <K> {
  public ObjectBidirectionalIterator<Object2ShortMap.Entry <K> > iterator() {
   return new EntryIterator();
  }
  public Comparator<? super Object2ShortMap.Entry <K> > comparator() { return null; }
  public ObjectSortedSet<Object2ShortMap.Entry <K> > subSet( Object2ShortMap.Entry <K> fromElement, Object2ShortMap.Entry <K> toElement) { throw new UnsupportedOperationException(); }
  public ObjectSortedSet<Object2ShortMap.Entry <K> > headSet( Object2ShortMap.Entry <K> toElement ) { throw new UnsupportedOperationException(); }
  public ObjectSortedSet<Object2ShortMap.Entry <K> > tailSet( Object2ShortMap.Entry <K> fromElement ) { throw new UnsupportedOperationException(); }
  public Object2ShortMap.Entry <K> first() {
   if ( size == 0 ) throw new NoSuchElementException();
   return new MapEntry( Object2ShortLinkedOpenCustomHashMap.this.first );
  }
  public Object2ShortMap.Entry <K> last() {
   if ( size == 0 ) throw new NoSuchElementException();
   return new MapEntry( Object2ShortLinkedOpenCustomHashMap.this.last );
  }
  @SuppressWarnings("unchecked")
  public boolean contains( final Object o ) {
   if ( !( o instanceof Map.Entry ) ) return false;
   final Map.Entry<K, Short> e = (Map.Entry<K, Short>)o;
   final K k = (e.getKey());
   // The starting point.
   int pos = ( it.unimi.dsi.fastutil.HashCommon.murmurHash3( strategy.hashCode(k) ) ) & mask;
   // There's always an unused entry.
   while( used[ pos ] ) {
    if ( ( strategy.equals( (k), (key[ pos ]) ) ) ) return ( (value[ pos ]) == (((e.getValue()).shortValue())) );
    pos = ( pos + 1 ) & mask;
   }
   return false;
  }
  @SuppressWarnings("unchecked")
  public boolean remove( final Object o ) {
   if ( !( o instanceof Map.Entry ) ) return false;
   final Map.Entry<K, Short> e = (Map.Entry<K, Short>)o;
   final K k = (e.getKey());
   // The starting point.
   int pos = ( it.unimi.dsi.fastutil.HashCommon.murmurHash3( strategy.hashCode(k) ) ) & mask;
   // There's always an unused entry.
   while( used[ pos ] ) {
    if ( ( strategy.equals( (k), (key[ pos ]) ) ) ) {
     Object2ShortLinkedOpenCustomHashMap.this.remove( e.getKey() );
     return true;
    }
    pos = ( pos + 1 ) & mask;
   }
   return false;
  }
  public int size() {
   return size;
  }
  public void clear() {
   Object2ShortLinkedOpenCustomHashMap.this.clear();
  }
  public ObjectBidirectionalIterator<Object2ShortMap.Entry <K> > iterator( final Object2ShortMap.Entry <K> from ) {
   return new EntryIterator( (from.getKey()) );
  }
  public ObjectBidirectionalIterator<Object2ShortMap.Entry <K> > fastIterator() {
   return new FastEntryIterator();
  }
  public ObjectBidirectionalIterator<Object2ShortMap.Entry <K> > fastIterator( final Object2ShortMap.Entry <K> from ) {
   return new FastEntryIterator( (from.getKey()) );
  }
 }
 public FastSortedEntrySet <K> object2ShortEntrySet() {
  if ( entries == null ) entries = new MapEntrySet();
  return entries;
 }
 /** An iterator on keys.
	 *
	 * <P>We simply override the {@link java.util.ListIterator#next()}/{@link java.util.ListIterator#previous()} methods
	 * (and possibly their type-specific counterparts) so that they return keys
	 * instead of entries.
	 */
 private final class KeyIterator extends MapIterator implements ObjectListIterator <K> {
  public KeyIterator( final K k ) { super( k ); }
  public K previous() { return key[ previousEntry() ]; }
  public void set( K k ) { throw new UnsupportedOperationException(); }
  public void add( K k ) { throw new UnsupportedOperationException(); }
  public KeyIterator() { super(); }
  public K next() { return key[ nextEntry() ]; }
 }
 private final class KeySet extends AbstractObjectSortedSet <K> {
  public ObjectBidirectionalIterator <K> iterator( final K from ) {
   return new KeyIterator( from );
  }
  public ObjectBidirectionalIterator <K> iterator() {
   return new KeyIterator();
  }
  public int size() {
   return size;
  }
  public boolean contains( Object k ) {
   return containsKey( k );
  }
  public boolean remove( Object k ) {
   final int oldSize = size;
   Object2ShortLinkedOpenCustomHashMap.this.remove( k );
   return size != oldSize;
  }
  public void clear() {
   Object2ShortLinkedOpenCustomHashMap.this.clear();
  }
  public K first() {
   if ( size == 0 ) throw new NoSuchElementException();
   return key[ first ];
  }
  public K last() {
   if ( size == 0 ) throw new NoSuchElementException();
   return key[ last ];
  }
  public Comparator <? super K> comparator() { return null; }
  final public ObjectSortedSet <K> tailSet( K from ) { throw new UnsupportedOperationException(); }
  final public ObjectSortedSet <K> headSet( K to ) { throw new UnsupportedOperationException(); }
  final public ObjectSortedSet <K> subSet( K from, K to ) { throw new UnsupportedOperationException(); }
 }
 public ObjectSortedSet <K> keySet() {
  if ( keys == null ) keys = new KeySet();
  return keys;
 }
 /** An iterator on values.
	 *
	 * <P>We simply override the {@link java.util.ListIterator#next()}/{@link java.util.ListIterator#previous()} methods
	 * (and possibly their type-specific counterparts) so that they return values
	 * instead of entries.
	 */
 private final class ValueIterator extends MapIterator implements ShortListIterator {
  public short previousShort() { return value[ previousEntry() ]; }
  public Short previous() { return (Short.valueOf(value[ previousEntry() ])); }
  public void set( Short ok ) { throw new UnsupportedOperationException(); }
  public void add( Short ok ) { throw new UnsupportedOperationException(); }
  public void set( short v ) { throw new UnsupportedOperationException(); }
  public void add( short v ) { throw new UnsupportedOperationException(); }
  public ValueIterator() { super(); }
  public short nextShort() { return value[ nextEntry() ]; }
  public Short next() { return (Short.valueOf(value[ nextEntry() ])); }
 }
 public ShortCollection values() {
  if ( values == null ) values = new AbstractShortCollection () {
    public ShortIterator iterator() {
     return new ValueIterator();
    }
    public int size() {
     return size;
    }
    public boolean contains( short v ) {
     return containsValue( v );
    }
    public void clear() {
     Object2ShortLinkedOpenCustomHashMap.this.clear();
    }
   };
  return values;
 }
 /** A no-op for backward compatibility. The kind of tables implemented by
	 * this class never need rehashing.
	 *
	 * <P>If you need to reduce the table size to fit exactly
	 * this set, use {@link #trim()}.
	 *
	 * @return true.
	 * @see #trim()
	 * @deprecated A no-op.
	 */
 @Deprecated
 public boolean rehash() {
  return true;
 }
 /** Rehashes the map, making the table as small as possible.
	 * 
	 * <P>This method rehashes the table to the smallest size satisfying the
	 * load factor. It can be used when the set will not be changed anymore, so
	 * to optimize access speed and size.
	 *
	 * <P>If the table size is already the minimum possible, this method
	 * does nothing. 
	 *
	 * @return true if there was enough memory to trim the map.
	 * @see #trim(int)
	 */
 public boolean trim() {
  final int l = arraySize( size, f );
  if ( l >= n ) return true;
  try {
   rehash( l );
  }
  catch(OutOfMemoryError cantDoIt) { return false; }
  return true;
 }
 /** Rehashes this map if the table is too large.
	 * 
	 * <P>Let <var>N</var> be the smallest table size that can hold
	 * <code>max(n,{@link #size()})</code> entries, still satisfying the load factor. If the current
	 * table size is smaller than or equal to <var>N</var>, this method does
	 * nothing. Otherwise, it rehashes this map in a table of size
	 * <var>N</var>.
	 *
	 * <P>This method is useful when reusing maps.  {@linkplain #clear() Clearing a
	 * map} leaves the table size untouched. If you are reusing a map
	 * many times, you can call this method with a typical
	 * size to avoid keeping around a very large table just
	 * because of a few large transient maps.
	 *
	 * @param n the threshold for the trimming.
	 * @return true if there was enough memory to trim the map.
	 * @see #trim()
	 */
 public boolean trim( final int n ) {
  final int l = HashCommon.nextPowerOfTwo( (int)Math.ceil( n / f ) );
  if ( this.n <= l ) return true;
  try {
   rehash( l );
  }
  catch( OutOfMemoryError cantDoIt ) { return false; }
  return true;
 }
 /** Resizes the map.
	 *
	 * <P>This method implements the basic rehashing strategy, and may be
	 * overriden by subclasses implementing different rehashing strategies (e.g.,
	 * disk-based rehashing). However, you should not override this method
	 * unless you understand the internal workings of this class.
	 *
	 * @param newN the new size
	 */
 @SuppressWarnings("unchecked")
 protected void rehash( final int newN ) {
  int i = first, prev = -1, newPrev = -1, t, pos;
  K k;
  final K key[] = this.key;
  final short value[] = this.value;
  final int newMask = newN - 1;
  final K newKey[] = (K[]) new Object[ newN ];
  final short newValue[] = new short[newN];
  final boolean newUsed[] = new boolean[ newN ];
  final int link[] = this.link;
  final int newLink[] = new int[ newN ];
  first = -1;
  for( int j = size; j-- != 0; ) {
   k = key[ i ];
   pos = ( it.unimi.dsi.fastutil.HashCommon.murmurHash3( strategy.hashCode(k) ) ) & newMask;
   while ( newUsed[ pos ] ) pos = ( pos + 1 ) & newMask;
   newUsed[ pos ] = true;
   newKey[ pos ] = k;
   newValue[ pos ] = value[ i ];
   if ( prev != -1 ) {
    newLink[ newPrev ] ^= pos;
    newLink[ pos ] = newPrev;
    newPrev = pos;
   }
   else {
    newPrev = first = pos;
    newLink[ pos ] = -1;
   }
   t = i;
   i = link[ i ] ^ prev;
   prev = t;
  }
  n = newN;
  mask = newMask;
  maxFill = maxFill( n, f );
  this.key = newKey;
  this.value = newValue;
  this.used = newUsed;
  this.link = newLink;
  this.last = newPrev;
  if ( newPrev != -1 ) newLink[ newPrev ] ^= -1;
 }
 /** Returns a deep copy of this map. 
	 *
	 * <P>This method performs a deep copy of this hash map; the data stored in the
	 * map, however, is not cloned. Note that this makes a difference only for object keys.
	 *
	 *  @return a deep copy of this map.
	 */
 @SuppressWarnings("unchecked")
 public Object2ShortLinkedOpenCustomHashMap <K> clone() {
  Object2ShortLinkedOpenCustomHashMap <K> c;
  try {
   c = (Object2ShortLinkedOpenCustomHashMap <K>)super.clone();
  }
  catch(CloneNotSupportedException cantHappen) {
   throw new InternalError();
  }
  c.keys = null;
  c.values = null;
  c.entries = null;
  c.key = key.clone();
  c.value = value.clone();
  c.used = used.clone();
  c.link = link.clone();
  c.strategy = strategy;
  return c;
 }
 /** Returns a hash code for this map.
	 *
	 * This method overrides the generic method provided by the superclass. 
	 * Since <code>equals()</code> is not overriden, it is important
	 * that the value returned by this method is the same value as
	 * the one returned by the overriden method.
	 *
	 * @return a hash code for this map.
	 */
 public int hashCode() {
  int h = 0;
  for( int j = size, i = 0, t = 0; j-- != 0; ) {
   while( ! used[ i ] ) i++;
   if ( this != key[ i ] )
    t = ( strategy.hashCode(key[ i ]) );
    t ^= (value[ i ]);
   h += t;
   i++;
  }
  return h;
 }
 private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException {
  final K key[] = this.key;
  final short value[] = this.value;
  final MapIterator i = new MapIterator();
  s.defaultWriteObject();
  for( int j = size, e; j-- != 0; ) {
   e = i.nextEntry();
   s.writeObject( key[ e ] );
   s.writeShort( value[ e ] );
  }
 }
 @SuppressWarnings("unchecked")
 private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException {
  s.defaultReadObject();
  n = arraySize( size, f );
  maxFill = maxFill( n, f );
  mask = n - 1;
  final K key[] = this.key = (K[]) new Object[ n ];
  final short value[] = this.value = new short[ n ];
  final boolean used[] = this.used = new boolean[ n ];
  final int link[] = this.link = new int[ n ];
  int prev = -1;
  first = last = -1;
  K k;
  short v;
  for( int i = size, pos = 0; i-- != 0; ) {
   k = (K) s.readObject();
   v = s.readShort();
   pos = ( it.unimi.dsi.fastutil.HashCommon.murmurHash3( strategy.hashCode(k) ) ) & mask;
   while ( used[ pos ] ) pos = ( pos + 1 ) & mask;
   used[ pos ] = true;
   key[ pos ] = k;
   value[ pos ] = v;
   if ( first != -1 ) {
    link[ prev ] ^= pos;
    link[ pos ] = prev;
    prev = pos;
   }
   else {
    prev = first = pos;
    link[ pos ] = -1;
   }
  }
  last = prev;
  if ( prev != -1 ) link[ prev ] ^= -1;
  if ( ASSERTS ) checkTable();
 }
 private void checkTable() {}
}
