/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import java.io.Serializable;
import java.util.Arrays;

public class DoubleBigArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final double[][] EMPTY_BIG_ARRAY = new double[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    private DoubleBigArrays() {
    }

    public static double get(double[][] array, long index) {
        return array[BigArrays.segment(index)][BigArrays.displacement(index)];
    }

    public static void set(double[][] array, long index, double value) {
        array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value;
    }

    public static void swap(double[][] array, long first, long second) {
        double t = array[BigArrays.segment(first)][BigArrays.displacement(first)];
        array[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array[BigArrays.segment(second)][BigArrays.displacement(second)];
        array[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    public static void add(double[][] array, long index, double incr) {
        double[] dArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        dArray[n] = dArray[n] + incr;
    }

    public static void mul(double[][] array, long index, double factor) {
        double[] dArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        dArray[n] = dArray[n] * factor;
    }

    public static void incr(double[][] array, long index) {
        double[] dArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        dArray[n] = dArray[n] + 1.0;
    }

    public static void decr(double[][] array, long index) {
        double[] dArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        dArray[n] = dArray[n] - 1.0;
    }

    public static long length(double[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array[length - 1].length;
    }

    public static void copy(double[][] srcArray, long srcPos, double[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                int l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static void copyFromBig(double[][] srcArray, long srcPos, double[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static void copyToBig(double[] srcArray, int srcPos, double[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static double[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
        double[][] base = new double[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = 0; i < baseLength - 1; ++i) {
                base[i] = new double[0x8000000];
            }
            base[baseLength - 1] = new double[residual];
        } else {
            for (int i = 0; i < baseLength; ++i) {
                base[i] = new double[0x8000000];
            }
        }
        return base;
    }

    public static double[][] wrap(double[] array) {
        if (array.length == 0) {
            return EMPTY_BIG_ARRAY;
        }
        if (array.length <= 0x8000000) {
            return new double[][]{array};
        }
        double[][] bigArray = DoubleBigArrays.newBigArray(array.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static double[][] ensureCapacity(double[][] array, long length) {
        return DoubleBigArrays.ensureCapacity(array, length, DoubleBigArrays.length(array));
    }

    public static double[][] ensureCapacity(double[][] array, long length, long preserve) {
        long oldLength = DoubleBigArrays.length(array);
        if (length > oldLength) {
            int valid = array.length - (array.length == 0 || array.length > 0 && array[array.length - 1].length == 0x8000000 ? 0 : 1);
            int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
            double[][] base = (double[][])Arrays.copyOf(array, baseLength);
            int residual = (int)(length & 0x7FFFFFFL);
            if (residual != 0) {
                for (int i = valid; i < baseLength - 1; ++i) {
                    base[i] = new double[0x8000000];
                }
                base[baseLength - 1] = new double[residual];
            } else {
                for (int i = valid; i < baseLength; ++i) {
                    base[i] = new double[0x8000000];
                }
            }
            if (preserve - (long)valid * 0x8000000L > 0L) {
                DoubleBigArrays.copy(array, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
            }
            return base;
        }
        return array;
    }

    public static double[][] grow(double[][] array, long length) {
        long oldLength = DoubleBigArrays.length(array);
        return length > oldLength ? DoubleBigArrays.grow(array, length, oldLength) : array;
    }

    public static double[][] grow(double[][] array, long length, long preserve) {
        long oldLength = DoubleBigArrays.length(array);
        return length > oldLength ? DoubleBigArrays.ensureCapacity(array, Math.max(106039L * oldLength >>> 16, length), preserve) : array;
    }

    public static double[][] trim(double[][] array, long length) {
        long oldLength = DoubleBigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
        double[][] base = (double[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = DoubleArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static double[][] setLength(double[][] array, long length) {
        long oldLength = DoubleBigArrays.length(array);
        if (length == oldLength) {
            return array;
        }
        if (length < oldLength) {
            return DoubleBigArrays.trim(array, length);
        }
        return DoubleBigArrays.ensureCapacity(array, length);
    }

    public static double[][] copy(double[][] array, long offset, long length) {
        DoubleBigArrays.ensureOffsetLength(array, offset, length);
        double[][] a = DoubleBigArrays.newBigArray(length);
        DoubleBigArrays.copy(array, offset, a, 0L, length);
        return a;
    }

    public static double[][] copy(double[][] array) {
        double[][] base = (double[][])array.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (double[])array[i].clone();
        }
        return base;
    }

    public static void fill(double[][] array, double value) {
        int i = array.length;
        while (i-- != 0) {
            DoubleArrays.fill(array[i], value);
        }
    }

    public static void fill(double[][] array, long from, long to, double value) {
        long length = DoubleBigArrays.length(array);
        BigArrays.ensureFromTo(length, from, to);
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            DoubleArrays.fill(array[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            DoubleArrays.fill(array[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            DoubleArrays.fill(array[toSegment], value);
        }
        DoubleArrays.fill(array[fromSegment], fromDispl, 0x8000000, value);
    }

    public static boolean equals(double[][] a1, double[][] a2) {
        if (DoubleBigArrays.length(a1) != DoubleBigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            double[] t = a1[i];
            double[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (t[j] == u[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(double[][] a) {
        if (a == null) {
            return "null";
        }
        long last = DoubleBigArrays.length(a) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(DoubleBigArrays.get(a, i)));
            if (i == last) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void ensureFromTo(double[][] a, long from, long to) {
        BigArrays.ensureFromTo(DoubleBigArrays.length(a), from, to);
    }

    public static void ensureOffsetLength(double[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(DoubleBigArrays.length(a), offset, length);
    }

    private static void vecSwap(double[][] x, long a, long b, long n) {
        int i = 0;
        while ((long)i < n) {
            DoubleBigArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static long med3(double[][] x, long a, long b, long c, DoubleComparator comp) {
        int ab = comp.compare(DoubleBigArrays.get(x, a), DoubleBigArrays.get(x, b));
        int ac = comp.compare(DoubleBigArrays.get(x, a), DoubleBigArrays.get(x, c));
        int bc = comp.compare(DoubleBigArrays.get(x, b), DoubleBigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void quickSort(double[][] x, long from, long to, DoubleComparator comp) {
        long c;
        long a;
        long len = to - from;
        if (len < 7L) {
            for (long i = from; i < to; ++i) {
                for (long j = i; j > from && comp.compare(DoubleBigArrays.get(x, j - 1L), DoubleBigArrays.get(x, j)) > 0; --j) {
                    DoubleBigArrays.swap(x, j, j - 1L);
                }
            }
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = DoubleBigArrays.med3(x, l, l + s, l + 2L * s, comp);
                m = DoubleBigArrays.med3(x, m - s, m, m + s, comp);
                n = DoubleBigArrays.med3(x, n - 2L * s, n - s, n, comp);
            }
            m = DoubleBigArrays.med3(x, l, m, n, comp);
        }
        double v = DoubleBigArrays.get(x, m);
        long b = a = from;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(DoubleBigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    DoubleBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(DoubleBigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    DoubleBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            DoubleBigArrays.swap(x, b++, c--);
        }
        long n = to;
        long s = Math.min(a - from, b - a);
        DoubleBigArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1L);
        DoubleBigArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            DoubleBigArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1L) {
            DoubleBigArrays.quickSort(x, n - s, n, comp);
        }
    }

    private static long med3(double[][] x, long a, long b, long c) {
        int bc;
        int ac;
        int ab;
        int n = DoubleBigArrays.get(x, a) < DoubleBigArrays.get(x, b) ? -1 : (ab = DoubleBigArrays.get(x, a) == DoubleBigArrays.get(x, b) ? 0 : 1);
        int n2 = DoubleBigArrays.get(x, a) < DoubleBigArrays.get(x, c) ? -1 : (ac = DoubleBigArrays.get(x, a) == DoubleBigArrays.get(x, c) ? 0 : 1);
        int n3 = DoubleBigArrays.get(x, b) < DoubleBigArrays.get(x, c) ? -1 : (bc = DoubleBigArrays.get(x, b) == DoubleBigArrays.get(x, c) ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void quickSort(double[][] x, DoubleComparator comp) {
        DoubleBigArrays.quickSort(x, 0L, DoubleBigArrays.length(x), comp);
    }

    public static void quickSort(double[][] x, long from, long to) {
        long c;
        long a;
        long len = to - from;
        if (len < 7L) {
            for (long i = from; i < to; ++i) {
                for (long j = i; j > from && (DoubleBigArrays.get(x, j - 1L) < DoubleBigArrays.get(x, j) ? -1 : (DoubleBigArrays.get(x, j - 1L) == DoubleBigArrays.get(x, j) ? 0 : 1)) > 0; --j) {
                    DoubleBigArrays.swap(x, j, j - 1L);
                }
            }
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = DoubleBigArrays.med3(x, l, l + s, l + 2L * s);
                m = DoubleBigArrays.med3(x, m - s, m, m + s);
                n = DoubleBigArrays.med3(x, n - 2L * s, n - s, n);
            }
            m = DoubleBigArrays.med3(x, l, m, n);
        }
        double v = DoubleBigArrays.get(x, m);
        long b = a = from;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b <= c && (DoubleBigArrays.get(x, b) < v ? -1 : (comparison = DoubleBigArrays.get(x, b) == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    DoubleBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (DoubleBigArrays.get(x, c) < v ? -1 : (comparison = DoubleBigArrays.get(x, c) == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    DoubleBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            DoubleBigArrays.swap(x, b++, c--);
        }
        long n = to;
        long s = Math.min(a - from, b - a);
        DoubleBigArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1L);
        DoubleBigArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            DoubleBigArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1L) {
            DoubleBigArrays.quickSort(x, n - s, n);
        }
    }

    public static void quickSort(double[][] x) {
        DoubleBigArrays.quickSort(x, 0L, DoubleBigArrays.length(x));
    }

    public static long binarySearch(double[][] a, long from, long to, double key) {
        while (from <= to) {
            long mid = from + to >>> 1;
            double midVal = DoubleBigArrays.get(a, mid);
            if (midVal < key) {
                from = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(double[][] a, double key) {
        return DoubleBigArrays.binarySearch(a, 0L, DoubleBigArrays.length(a), key);
    }

    public static long binarySearch(double[][] a, long from, long to, double key, DoubleComparator c) {
        while (from <= to) {
            long mid = from + to >>> 1;
            double midVal = DoubleBigArrays.get(a, mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(double[][] a, double key, DoubleComparator c) {
        return DoubleBigArrays.binarySearch(a, 0L, DoubleBigArrays.length(a), key, c);
    }

    private static final class BigArrayHashStrategy
    implements Hash.Strategy<double[][]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(double[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        @Override
        public boolean equals(double[][] a, double[][] b) {
            return DoubleBigArrays.equals(a, b);
        }
    }
}

