/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.floats.AbstractFloat2IntMap;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2IntMap;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

public class Float2IntOpenHashMap
extends AbstractFloat2IntMap
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient float[] key;
    protected transient int[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Float2IntMap.FastEntrySet entries;
    protected volatile transient FloatSet keys;
    protected volatile transient IntCollection values;

    public Float2IntOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new float[this.n];
        this.value = new int[this.n];
        this.used = new boolean[this.n];
    }

    public Float2IntOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Float2IntOpenHashMap() {
        this(16, 0.75f);
    }

    public Float2IntOpenHashMap(Map<? extends Float, ? extends Integer> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Float2IntOpenHashMap(Map<? extends Float, ? extends Integer> m) {
        this(m, 0.75f);
    }

    public Float2IntOpenHashMap(Float2IntMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Float2IntOpenHashMap(Float2IntMap m) {
        this(m, 0.75f);
    }

    public Float2IntOpenHashMap(float[] k, int[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Float2IntOpenHashMap(float[] k, int[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public int put(float k, int v) {
        float[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            int oldValue = this.value[pos];
            this.value[pos] = v;
            return oldValue;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Integer put(Float ok, Integer ov) {
        int v = ov;
        float k = ok.floatValue();
        float[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            Integer oldValue = this.value[pos];
            this.value[pos] = v;
            return oldValue;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return null;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(HashCommon.float2int(this.key[pos])) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
    }

    @Override
    public int remove(float k) {
        float[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return this.defRetValue;
        }
        --this.size;
        int v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    @Override
    public Integer remove(Object ok) {
        float k = ((Float)ok).floatValue();
        float[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return null;
        }
        --this.size;
        int v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    public Integer get(Float ok) {
        float k = ok.floatValue();
        float[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos] ? Integer.valueOf(this.value[pos]) : null;
    }

    @Override
    public int get(float k) {
        float[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos] ? this.value[pos] : this.defRetValue;
    }

    @Override
    public boolean containsKey(float k) {
        float[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos];
    }

    @Override
    public boolean containsValue(int v) {
        int[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Float2IntMap.FastEntrySet float2IntEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public FloatSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public IntCollection values() {
        if (this.values == null) {
            this.values = new AbstractIntCollection(){

                @Override
                public IntIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Float2IntOpenHashMap.this.size;
                }

                @Override
                public boolean contains(int v) {
                    return Float2IntOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Float2IntOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        float[] key = this.key;
        int[] value = this.value;
        int newMask = newN - 1;
        float[] newKey = new float[newN];
        int[] newValue = new int[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            float k = key[i];
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Float2IntOpenHashMap clone() {
        Float2IntOpenHashMap c;
        try {
            c = (Float2IntOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (float[])this.key.clone();
        c.value = (int[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = HashCommon.float2int(this.key[i]);
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        float[] key = this.key;
        int[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeFloat(key[e]);
            s.writeInt(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new float[this.n];
        float[] key = this.key;
        this.value = new int[this.n];
        int[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            float k = s.readFloat();
            int v = s.readInt();
            pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements IntIterator {
        @Override
        public int nextInt() {
            return Float2IntOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Integer next() {
            return Float2IntOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractFloatSet {
        private KeySet() {
        }

        @Override
        public FloatIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Float2IntOpenHashMap.this.size;
        }

        @Override
        public boolean contains(float k) {
            return Float2IntOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(float k) {
            int oldSize = Float2IntOpenHashMap.this.size;
            Float2IntOpenHashMap.this.remove(k);
            return Float2IntOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Float2IntOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements FloatIterator {
        @Override
        public float nextFloat() {
            return Float2IntOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Float next() {
            return Float.valueOf(Float2IntOpenHashMap.this.key[this.nextEntry()]);
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Float2IntMap.Entry>
    implements Float2IntMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Float2IntMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Float2IntMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            float k = ((Float)e.getKey()).floatValue();
            float[] key = Float2IntOpenHashMap.this.key;
            boolean[] used = Float2IntOpenHashMap.this.used;
            int mask = Float2IntOpenHashMap.this.mask;
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
            while (used[pos] && k != key[pos]) {
                pos = pos + 1 & mask;
            }
            return used[pos] && Float2IntOpenHashMap.this.value[pos] == (Integer)e.getValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            float k = ((Float)e.getKey()).floatValue();
            float[] key = Float2IntOpenHashMap.this.key;
            boolean[] used = Float2IntOpenHashMap.this.used;
            int mask = Float2IntOpenHashMap.this.mask;
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
            while (used[pos] && k != key[pos]) {
                pos = pos + 1 & mask;
            }
            if (used[pos]) {
                Float2IntOpenHashMap.this.remove(e.getKey());
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return Float2IntOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Float2IntOpenHashMap.this.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Float2IntMap.Entry> {
        final AbstractFloat2IntMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractFloat2IntMap.BasicEntry(0.0f, 0);
        }

        @Override
        public AbstractFloat2IntMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Float2IntOpenHashMap.this.key[e];
            this.entry.value = Float2IntOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Float2IntMap.Entry> {
        private EntryIterator() {
        }

        @Override
        public Float2IntMap.Entry next() {
            return new MapEntry(this.nextEntry());
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;

        private MapIterator() {
            this.pos = Float2IntOpenHashMap.this.n;
            this.last = -1;
            this.c = Float2IntOpenHashMap.this.size;
            boolean[] used = Float2IntOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                boolean[] used = Float2IntOpenHashMap.this.used;
                while (!used[this.pos = this.pos - 1 & Float2IntOpenHashMap.this.mask]) {
                }
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Float2IntOpenHashMap.this.shiftKeys(this.last);
            --Float2IntOpenHashMap.this.size;
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Float2IntMap.Entry,
    Map.Entry<Float, Integer> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Float getKey() {
            return Float.valueOf(Float2IntOpenHashMap.this.key[this.index]);
        }

        @Override
        public float getFloatKey() {
            return Float2IntOpenHashMap.this.key[this.index];
        }

        @Override
        public Integer getValue() {
            return Float2IntOpenHashMap.this.value[this.index];
        }

        @Override
        public int getIntValue() {
            return Float2IntOpenHashMap.this.value[this.index];
        }

        @Override
        public int setValue(int v) {
            int oldValue = Float2IntOpenHashMap.this.value[this.index];
            Float2IntOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Integer setValue(Integer v) {
            return this.setValue((int)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Float2IntOpenHashMap.this.key[this.index] == ((Float)e.getKey()).floatValue() && Float2IntOpenHashMap.this.value[this.index] == (Integer)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(Float2IntOpenHashMap.this.key[this.index]) ^ Float2IntOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Float2IntOpenHashMap.this.key[this.index] + "=>" + Float2IntOpenHashMap.this.value[this.index];
        }
    }
}

