/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloat2DoubleMap;
import it.unimi.dsi.fastutil.floats.AbstractFloat2DoubleSortedMap;
import it.unimi.dsi.fastutil.floats.AbstractFloatSortedSet;
import it.unimi.dsi.fastutil.floats.Float2DoubleMap;
import it.unimi.dsi.fastutil.floats.Float2DoubleSortedMap;
import it.unimi.dsi.fastutil.floats.FloatBidirectionalIterator;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Float2DoubleLinkedOpenHashMap
extends AbstractFloat2DoubleSortedMap
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient float[] key;
    protected transient double[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Float2DoubleSortedMap.FastSortedEntrySet entries;
    protected volatile transient FloatSortedSet keys;
    protected volatile transient DoubleCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;

    public Float2DoubleLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new float[this.n];
        this.value = new double[this.n];
        this.used = new boolean[this.n];
        this.link = new int[this.n];
    }

    public Float2DoubleLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Float2DoubleLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Float2DoubleLinkedOpenHashMap(Map<? extends Float, ? extends Double> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Float2DoubleLinkedOpenHashMap(Map<? extends Float, ? extends Double> m) {
        this(m, 0.75f);
    }

    public Float2DoubleLinkedOpenHashMap(Float2DoubleMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Float2DoubleLinkedOpenHashMap(Float2DoubleMap m) {
        this(m, 0.75f);
    }

    public Float2DoubleLinkedOpenHashMap(float[] k, double[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Float2DoubleLinkedOpenHashMap(float[] k, double[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public double put(float k, double v) {
        float[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            double oldValue = this.value[pos];
            this.value[pos] = v;
            return oldValue;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Double put(Float ok, Double ov) {
        double v = ov;
        float k = ok.floatValue();
        float[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            Double oldValue = this.value[pos];
            this.value[pos] = v;
            return oldValue;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return null;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(HashCommon.float2int(this.key[pos])) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
    }

    @Override
    public double remove(float k) {
        float[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return this.defRetValue;
        }
        --this.size;
        this.fixPointers(pos);
        double v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    @Override
    public Double remove(Object ok) {
        float k = ((Float)ok).floatValue();
        float[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return null;
        }
        --this.size;
        this.fixPointers(pos);
        double v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    public Double get(Float ok) {
        float k = ok.floatValue();
        float[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos] ? Double.valueOf(this.value[pos]) : null;
    }

    @Override
    public double get(float k) {
        float[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos] ? this.value[pos] : this.defRetValue;
    }

    @Override
    public boolean containsKey(float k) {
        float[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos];
    }

    @Override
    public boolean containsValue(double v) {
        double[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        int next;
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    protected void fixPointers(int s, int d) {
        int next;
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = 0;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != s) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (s ^ d);
        int n2 = this.link[s] ^ j;
        this.link[n2] = this.link[n2] ^ (s ^ d);
        this.link[d] = this.link[s];
    }

    @Override
    public float firstFloatKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public float lastFloatKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public FloatComparator comparator() {
        return null;
    }

    @Override
    public Float2DoubleSortedMap tailMap(float from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float2DoubleSortedMap headMap(float to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float2DoubleSortedMap subMap(float from, float to) {
        throw new UnsupportedOperationException();
    }

    public Float2DoubleSortedMap.FastSortedEntrySet float2DoubleEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public FloatSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public DoubleCollection values() {
        if (this.values == null) {
            this.values = new AbstractDoubleCollection(){

                @Override
                public DoubleIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Float2DoubleLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(double v) {
                    return Float2DoubleLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Float2DoubleLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        float[] key = this.key;
        double[] value = this.value;
        int newMask = newN - 1;
        float[] newKey = new float[newN];
        double[] newValue = new double[newN];
        boolean[] newUsed = new boolean[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            float k = key[i];
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ pos;
                newLink[pos] = newPrev;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1;
            }
            int t = i;
            i = link[i] ^ prev;
            prev = t;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Float2DoubleLinkedOpenHashMap clone() {
        Float2DoubleLinkedOpenHashMap c;
        try {
            c = (Float2DoubleLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (float[])this.key.clone();
        c.value = (double[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = HashCommon.float2int(this.key[i]);
            h += (t ^= HashCommon.double2int(this.value[i]));
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        float[] key = this.key;
        double[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeFloat(key[e]);
            s.writeDouble(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new float[this.n];
        float[] key = this.key;
        this.value = new double[this.n];
        double[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new int[this.n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            float k = s.readFloat();
            double v = s.readDouble();
            pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ pos;
                link[pos] = prev;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            link[pos] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = ~link[n];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements DoubleListIterator {
        @Override
        public double previousDouble() {
            return Float2DoubleLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public Double previous() {
            return Float2DoubleLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public void set(Double ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double nextDouble() {
            return Float2DoubleLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Double next() {
            return Float2DoubleLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractFloatSortedSet {
        private KeySet() {
        }

        @Override
        public FloatBidirectionalIterator iterator(float from) {
            return new KeyIterator(from);
        }

        @Override
        public FloatBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Float2DoubleLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(float k) {
            return Float2DoubleLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(float k) {
            int oldSize = Float2DoubleLinkedOpenHashMap.this.size;
            Float2DoubleLinkedOpenHashMap.this.remove(k);
            return Float2DoubleLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Float2DoubleLinkedOpenHashMap.this.clear();
        }

        @Override
        public float firstFloat() {
            if (Float2DoubleLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Float2DoubleLinkedOpenHashMap.this.key[Float2DoubleLinkedOpenHashMap.this.first];
        }

        @Override
        public float lastFloat() {
            if (Float2DoubleLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Float2DoubleLinkedOpenHashMap.this.key[Float2DoubleLinkedOpenHashMap.this.last];
        }

        @Override
        public FloatComparator comparator() {
            return null;
        }

        @Override
        public final FloatSortedSet tailSet(float from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final FloatSortedSet headSet(float to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final FloatSortedSet subSet(float from, float to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements FloatListIterator {
        public KeyIterator(float k) {
            super(k);
        }

        @Override
        public float previousFloat() {
            return Float2DoubleLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(float k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(float k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Float previous() {
            return Float.valueOf(Float2DoubleLinkedOpenHashMap.this.key[this.previousEntry()]);
        }

        @Override
        public void set(Float ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Float ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public float nextFloat() {
            return Float2DoubleLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Float next() {
            return Float.valueOf(Float2DoubleLinkedOpenHashMap.this.key[this.nextEntry()]);
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Float2DoubleMap.Entry>
    implements Float2DoubleSortedMap.FastSortedEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Float2DoubleMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Float2DoubleMap.Entry> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Float2DoubleMap.Entry> subSet(Float2DoubleMap.Entry fromElement, Float2DoubleMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Float2DoubleMap.Entry> headSet(Float2DoubleMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Float2DoubleMap.Entry> tailSet(Float2DoubleMap.Entry fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Float2DoubleMap.Entry first() {
            if (Float2DoubleLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Float2DoubleLinkedOpenHashMap.this.first);
        }

        @Override
        public Float2DoubleMap.Entry last() {
            if (Float2DoubleLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Float2DoubleLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            float k = ((Float)e.getKey()).floatValue();
            float[] key = Float2DoubleLinkedOpenHashMap.this.key;
            boolean[] used = Float2DoubleLinkedOpenHashMap.this.used;
            int mask = Float2DoubleLinkedOpenHashMap.this.mask;
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
            while (used[pos] && k != key[pos]) {
                pos = pos + 1 & mask;
            }
            return used[pos] && Float2DoubleLinkedOpenHashMap.this.value[pos] == (Double)e.getValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            float k = ((Float)e.getKey()).floatValue();
            float[] key = Float2DoubleLinkedOpenHashMap.this.key;
            boolean[] used = Float2DoubleLinkedOpenHashMap.this.used;
            int mask = Float2DoubleLinkedOpenHashMap.this.mask;
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & mask;
            while (used[pos] && k != key[pos]) {
                pos = pos + 1 & mask;
            }
            if (used[pos]) {
                Float2DoubleLinkedOpenHashMap.this.remove(e.getKey());
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return Float2DoubleLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Float2DoubleLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Float2DoubleMap.Entry> iterator(Float2DoubleMap.Entry from) {
            return new EntryIterator(((Float)from.getKey()).floatValue());
        }

        public ObjectBidirectionalIterator<Float2DoubleMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Float2DoubleMap.Entry> fastIterator(Float2DoubleMap.Entry from) {
            return new FastEntryIterator(((Float)from.getKey()).floatValue());
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Float2DoubleMap.Entry> {
        final AbstractFloat2DoubleMap.BasicEntry entry;

        public FastEntryIterator() {
            this.entry = new AbstractFloat2DoubleMap.BasicEntry(0.0f, 0.0);
        }

        public FastEntryIterator(float from) {
            super(from);
            this.entry = new AbstractFloat2DoubleMap.BasicEntry(0.0f, 0.0);
        }

        @Override
        public AbstractFloat2DoubleMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Float2DoubleLinkedOpenHashMap.this.key[e];
            this.entry.value = Float2DoubleLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractFloat2DoubleMap.BasicEntry previous() {
            int e = this.previousEntry();
            this.entry.key = Float2DoubleLinkedOpenHashMap.this.key[e];
            this.entry.value = Float2DoubleLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Float2DoubleMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Float2DoubleMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Float2DoubleMap.Entry> {
        public EntryIterator() {
        }

        public EntryIterator(float from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Float2DoubleMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Float2DoubleMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        private MapIterator() {
            this.next = Float2DoubleLinkedOpenHashMap.this.first;
        }

        private MapIterator(float from) {
            if (Float2DoubleLinkedOpenHashMap.this.key[Float2DoubleLinkedOpenHashMap.this.last] == from) {
                this.prev = Float2DoubleLinkedOpenHashMap.this.last;
                this.index = Float2DoubleLinkedOpenHashMap.this.size;
            } else {
                int e;
                if (!Float2DoubleLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Float2DoubleLinkedOpenHashMap.this.first;
                while (Float2DoubleLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Float2DoubleLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Float2DoubleLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Float2DoubleLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Float2DoubleLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Float2DoubleLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Float2DoubleLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Float2DoubleLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Float2DoubleLinkedOpenHashMap.this.link[n] = Float2DoubleLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Float2DoubleLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Float2DoubleLinkedOpenHashMap.this.link[n] = Float2DoubleLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Float2DoubleLinkedOpenHashMap.this.mask;
                while (Float2DoubleLinkedOpenHashMap.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(HashCommon.float2int(Float2DoubleLinkedOpenHashMap.this.key[pos])) & Float2DoubleLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Float2DoubleLinkedOpenHashMap.this.mask;
                }
                if (!Float2DoubleLinkedOpenHashMap.this.used[pos]) break;
                Float2DoubleLinkedOpenHashMap.this.key[last] = Float2DoubleLinkedOpenHashMap.this.key[pos];
                Float2DoubleLinkedOpenHashMap.this.value[last] = Float2DoubleLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Float2DoubleLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Float2DoubleLinkedOpenHashMap.this.used[last] = false;
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Float2DoubleMap.Entry,
    Map.Entry<Float, Double> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Float getKey() {
            return Float.valueOf(Float2DoubleLinkedOpenHashMap.this.key[this.index]);
        }

        @Override
        public float getFloatKey() {
            return Float2DoubleLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Double getValue() {
            return Float2DoubleLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public double getDoubleValue() {
            return Float2DoubleLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public double setValue(double v) {
            double oldValue = Float2DoubleLinkedOpenHashMap.this.value[this.index];
            Float2DoubleLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Double setValue(Double v) {
            return this.setValue((double)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Float2DoubleLinkedOpenHashMap.this.key[this.index] == ((Float)e.getKey()).floatValue() && Float2DoubleLinkedOpenHashMap.this.value[this.index] == (Double)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(Float2DoubleLinkedOpenHashMap.this.key[this.index]) ^ HashCommon.double2int(Float2DoubleLinkedOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Float2DoubleLinkedOpenHashMap.this.key[this.index] + "=>" + Float2DoubleLinkedOpenHashMap.this.value[this.index];
        }
    }
}

