/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleListIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSortedSet;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import it.unimi.dsi.fastutil.doubles.DoubleSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DoubleLinkedOpenHashSet
extends AbstractDoubleSortedSet
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient double[] key;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;

    public DoubleLinkedOpenHashSet(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new double[this.n];
        this.used = new boolean[this.n];
        this.link = new int[this.n];
    }

    public DoubleLinkedOpenHashSet(int expected) {
        this(expected, 0.75f);
    }

    public DoubleLinkedOpenHashSet() {
        this(16, 0.75f);
    }

    public DoubleLinkedOpenHashSet(Collection<? extends Double> c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public DoubleLinkedOpenHashSet(Collection<? extends Double> c) {
        this(c, 0.75f);
    }

    public DoubleLinkedOpenHashSet(DoubleCollection c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public DoubleLinkedOpenHashSet(DoubleCollection c) {
        this(c, 0.75f);
    }

    public DoubleLinkedOpenHashSet(DoubleIterator i, float f) {
        this(16, f);
        while (i.hasNext()) {
            this.add(i.nextDouble());
        }
    }

    public DoubleLinkedOpenHashSet(DoubleIterator i) {
        this(i, 0.75f);
    }

    public DoubleLinkedOpenHashSet(Iterator<?> i, float f) {
        this(DoubleIterators.asDoubleIterator(i), f);
    }

    public DoubleLinkedOpenHashSet(Iterator<?> i) {
        this(DoubleIterators.asDoubleIterator(i));
    }

    public DoubleLinkedOpenHashSet(double[] a, int offset, int length, float f) {
        this(length < 0 ? 0 : length, f);
        DoubleArrays.ensureOffsetLength(a, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a[offset + i]);
        }
    }

    public DoubleLinkedOpenHashSet(double[] a, int offset, int length) {
        this(a, offset, length, 0.75f);
    }

    public DoubleLinkedOpenHashSet(double[] a, float f) {
        this(a, 0, a.length, f);
    }

    public DoubleLinkedOpenHashSet(double[] a) {
        this(a, 0.75f);
    }

    @Override
    public boolean add(double k) {
        double[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            return false;
        }
        used[pos] = true;
        key[pos] = k;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return true;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(this.key[pos])) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
    }

    @Override
    public boolean remove(double k) {
        double[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return false;
        }
        --this.size;
        this.fixPointers(pos);
        this.shiftKeys(pos);
        return true;
    }

    @Override
    public boolean contains(double k) {
        double[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos];
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        int next;
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    protected void fixPointers(int s, int d) {
        int next;
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = 0;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != s) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (s ^ d);
        int n2 = this.link[s] ^ j;
        this.link[n2] = this.link[n2] ^ (s ^ d);
        this.link[d] = this.link[s];
    }

    @Override
    public double firstDouble() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public double lastDouble() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public DoubleSortedSet tailSet(double from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DoubleSortedSet headSet(double to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DoubleSortedSet subSet(double from, double to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DoubleComparator comparator() {
        return null;
    }

    @Override
    public DoubleBidirectionalIterator iterator(double from) {
        return new SetIterator(from);
    }

    @Override
    public DoubleBidirectionalIterator iterator() {
        return new SetIterator();
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        double[] key = this.key;
        int newMask = newN - 1;
        double[] newKey = new double[newN];
        boolean[] newUsed = new boolean[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            double k = key[i];
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ pos;
                newLink[pos] = newPrev;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1;
            }
            int t = i;
            i = link[i] ^ prev;
            prev = t;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public DoubleLinkedOpenHashSet clone() {
        DoubleLinkedOpenHashSet c;
        try {
            c = (DoubleLinkedOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (double[])this.key.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.size;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            h += HashCommon.double2int(this.key[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        DoubleBidirectionalIterator i = this.iterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            s.writeDouble(i.nextDouble());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new double[this.n];
        double[] key = this.key;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new int[this.n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            double k = s.readDouble();
            pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ pos;
                link[pos] = prev;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            link[pos] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = ~link[n];
        }
    }

    private void checkTable() {
    }

    private class SetIterator
    extends AbstractDoubleListIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        SetIterator() {
            this.next = DoubleLinkedOpenHashSet.this.first;
        }

        SetIterator(double from) {
            if (DoubleLinkedOpenHashSet.this.key[DoubleLinkedOpenHashSet.this.last] == from) {
                this.prev = DoubleLinkedOpenHashSet.this.last;
                this.index = DoubleLinkedOpenHashSet.this.size;
            } else {
                double k;
                if (!DoubleLinkedOpenHashSet.this.contains(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = DoubleLinkedOpenHashSet.this.first;
                while ((k = this.nextDouble()) != from) {
                }
                this.curr = -1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.prev != -1;
        }

        @Override
        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = DoubleLinkedOpenHashSet.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return DoubleLinkedOpenHashSet.this.key[this.curr];
        }

        @Override
        public double previousDouble() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = DoubleLinkedOpenHashSet.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return DoubleLinkedOpenHashSet.this.key[this.curr];
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = DoubleLinkedOpenHashSet.this.link[this.curr] ^ this.next;
            } else {
                this.next = DoubleLinkedOpenHashSet.this.link[this.curr] ^ this.prev;
            }
            --DoubleLinkedOpenHashSet.this.size;
            if (this.prev == -1) {
                DoubleLinkedOpenHashSet.this.first = this.next;
            } else {
                int n = this.prev;
                DoubleLinkedOpenHashSet.this.link[n] = DoubleLinkedOpenHashSet.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                DoubleLinkedOpenHashSet.this.last = this.prev;
            } else {
                int n = this.next;
                DoubleLinkedOpenHashSet.this.link[n] = DoubleLinkedOpenHashSet.this.link[n] ^ (this.curr ^ this.prev);
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & DoubleLinkedOpenHashSet.this.mask;
                while (DoubleLinkedOpenHashSet.this.used[pos]) {
                    int slot = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(DoubleLinkedOpenHashSet.this.key[pos])) & DoubleLinkedOpenHashSet.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & DoubleLinkedOpenHashSet.this.mask;
                }
                if (!DoubleLinkedOpenHashSet.this.used[pos]) break;
                DoubleLinkedOpenHashSet.this.key[last] = DoubleLinkedOpenHashSet.this.key[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                DoubleLinkedOpenHashSet.this.fixPointers(pos, last);
            }
            DoubleLinkedOpenHashSet.this.used[last] = false;
            this.curr = -1;
        }
    }
}

