/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.AbstractBytePriorityQueue;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import java.util.NoSuchElementException;

public class ByteArrayPriorityQueue
extends AbstractBytePriorityQueue {
    protected byte[] array = ByteArrays.EMPTY_ARRAY;
    protected int size;
    protected ByteComparator c;

    public ByteArrayPriorityQueue(int capacity, ByteComparator c) {
        if (capacity > 0) {
            this.array = new byte[capacity];
        }
        this.c = c;
    }

    public ByteArrayPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public ByteArrayPriorityQueue(ByteComparator c) {
        this(0, c);
    }

    public ByteArrayPriorityQueue() {
        this(0, null);
    }

    public ByteArrayPriorityQueue(byte[] a, int size, ByteComparator c) {
        this(c);
        this.array = a;
        this.size = size;
    }

    public ByteArrayPriorityQueue(byte[] a, ByteComparator c) {
        this(a, a.length, c);
    }

    public ByteArrayPriorityQueue(byte[] a, int size) {
        this(a, size, null);
    }

    public ByteArrayPriorityQueue(byte[] a) {
        this(a, a.length);
    }

    private int findFirst() {
        int i = this.size;
        int firstIndex = --i;
        byte first = this.array[firstIndex];
        if (this.c == null) {
            while (i-- != 0) {
                if (this.array[i] >= first) continue;
                firstIndex = i;
                first = this.array[firstIndex];
            }
        } else {
            while (i-- != 0) {
                if (this.c.compare(this.array[i], first) >= 0) continue;
                firstIndex = i;
                first = this.array[firstIndex];
            }
        }
        return firstIndex;
    }

    private void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void enqueue(byte x) {
        if (this.size == this.array.length) {
            this.array = ByteArrays.grow(this.array, this.size + 1);
        }
        this.array[this.size++] = x;
    }

    @Override
    public byte dequeueByte() {
        this.ensureNonEmpty();
        int first = this.findFirst();
        byte result = this.array[first];
        System.arraycopy(this.array, first + 1, this.array, first, --this.size - first);
        return result;
    }

    @Override
    public byte firstByte() {
        this.ensureNonEmpty();
        return this.array[this.findFirst()];
    }

    @Override
    public void changed() {
        this.ensureNonEmpty();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.array = ByteArrays.trim(this.array, this.size);
    }

    @Override
    public ByteComparator comparator() {
        return this.c;
    }
}

