/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.Util;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.stat.Ziggurat;
import it.unimi.dsi.util.XoRoShiRo128PlusRandom;
import java.io.Serializable;

public class IntParallelCounterArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;
    public static final int MAX_EXPONENT = 2;
    public static final int CHUNK_SHIFT = 30;
    public static final long CHUNK_SIZE = 0x40000000L;
    public static final long CHUNK_MASK = 0x3FFFFFFFL;
    protected final LongArrayBitVector[] bitVector;
    protected final LongBigList[] registers;
    protected final int m;
    protected final int log2m;
    protected final int mMinus1;
    protected final int registerSize;
    protected final int registerMask;
    protected final int nodeShift;
    private final Ziggurat ziggurat;
    protected double base;
    private final double logBase;
    private final int maxExponent;
    private final double[] maxz = new double[10000];
    private final long[] maxe = new long[10000];

    public static int log2NumberOfRegisters(double rsd) {
        return (int)Math.ceil(Fast.log2(1.0 / rsd * (1.0 / rsd)));
    }

    public static double relativeStandardDeviation(int log2m) {
        return 1.0 / Math.sqrt(1 << log2m);
    }

    public static int registerSize(long n) {
        return Math.max(4, (int)Math.ceil(Math.log(Math.log(n) / Math.log(2.0)) / Math.log(2.0)));
    }

    public IntParallelCounterArray(int arraySize, long n, double rsd, double floatingPointPrecision) {
        this(arraySize, n, IntParallelCounterArray.log2NumberOfRegisters(rsd), floatingPointPrecision);
    }

    public IntParallelCounterArray(int arraySize, long n, int log2m, double floatingPointPrecision) {
        this(arraySize, n, log2m, floatingPointPrecision, Util.randomSeed());
    }

    public IntParallelCounterArray(int arraySize, long n, int log2m, double floatingPointPrecision, long seed) {
        this.log2m = log2m;
        this.m = 1 << this.log2m;
        this.mMinus1 = this.m - 1;
        this.registerSize = (int)((double)IntParallelCounterArray.registerSize(n) + Math.ceil(-Fast.log2(floatingPointPrecision)));
        this.registerMask = (1 << this.registerSize) - 1;
        this.nodeShift = 30 - log2m;
        this.base = (1.0 + floatingPointPrecision) / (1.0 - floatingPointPrecision);
        this.logBase = Math.log(this.base);
        this.maxExponent = (int)Math.ceil(Math.log(2.0) / this.logBase);
        long sizeInRegisters = (long)arraySize * (long)this.m;
        int numVectors = (int)(sizeInRegisters + 0x3FFFFFFFL >>> 30);
        this.bitVector = new LongArrayBitVector[numVectors];
        this.registers = new LongBigList[numVectors];
        for (int i = 0; i < numVectors; ++i) {
            this.bitVector[i] = LongArrayBitVector.ofLength((long)this.registerSize * Math.min(0x40000000L, sizeInRegisters - ((long)i << 30)));
            this.registers[i] = this.bitVector[i].asLongBigList(this.registerSize);
        }
        this.ziggurat = new Ziggurat(new XoRoShiRo128PlusRandom(seed));
    }

    public void add(int k, int v) {
        int registerSize = this.registerSize;
        int chunk = (int)((long)k >>> this.nodeShift);
        long offset = ((long)k << this.log2m & 0x3FFFFFFFL) * (long)registerSize;
        long[] bits = this.bitVector[chunk].bits();
        int length = bits.length;
        int word = (int)(offset / 64L) - 1;
        long curr = 0L;
        int used = (int)(offset % 64L);
        for (int i = 0; i < this.m; ++i) {
            double z = this.ziggurat.nextDouble();
            this.maxz[i] = Math.max(this.maxz[i], 1.0 / z);
            long e = Math.max(0L, -Math.round(Math.log(z) / this.logBase) + (long)this.maxExponent) & (long)this.registerMask;
            this.maxe[i] = Math.max(this.maxe[i], e);
            if (used < 64 - registerSize) {
                curr |= e << used;
                used += registerSize;
                continue;
            }
            if (++word == length) {
                word = 0;
                bits = this.bitVector[++chunk].bits();
                length = bits.length;
            }
            bits[word] = curr | e << used;
            curr = e >>> 64 - used;
            used += registerSize - 64;
        }
    }

    public void printMins() {
        int i;
        for (i = 0; i < this.m; ++i) {
            System.out.print(this.maxe[i] + "\t");
        }
        System.err.println();
        for (i = 0; i < this.m; ++i) {
            System.out.print(1.0 / this.maxz[i] + "\t");
        }
        System.err.println();
        for (i = 0; i < this.m; ++i) {
            System.out.print(this.maxz[i] + "\t");
        }
        System.err.println();
    }

    public LongBigList[] registers() {
        return this.registers;
    }

    public double count(int k) {
        double s = 0.0;
        int registerSize = this.registerSize;
        int chunk = (int)((long)k >>> this.nodeShift);
        long offset = ((long)k << this.log2m & 0x3FFFFFFFL) * (long)registerSize;
        long[] bits = this.bitVector[chunk].bits();
        int length = bits.length;
        int word = (int)(offset / 64L);
        long curr = bits[word] >>> (int)(offset % 64L);
        int remaining = (int)(64L - offset % 64L);
        int mask = (1 << registerSize) - 1;
        for (int j = 0; j < this.m; ++j) {
            long r;
            if (remaining >= registerSize) {
                r = curr & (long)mask;
                curr >>>= registerSize;
                remaining -= registerSize;
            } else {
                if (++word == length) {
                    word = 0;
                    bits = this.bitVector[++chunk].bits();
                    length = bits.length;
                }
                r = (curr | bits[word] << remaining) & (long)mask;
                curr = bits[word] >>> registerSize - remaining;
                remaining += 64 - registerSize;
            }
            s += Math.pow(this.base, -r + (long)this.maxExponent);
        }
        return (double)this.m / s;
    }
}

