/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.lang;

import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.lang.MutableString;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ObjectParser
extends StringParser {
    private static final Object NO_CONTEXT = new Object();
    public static final String[] DEFAULT_FACTORY_METHODS = new String[]{"getInstance", "newInstance", "valueOf"};
    private final String[] packages;
    private final String[] factoryMethod;
    private final Class<?> type;
    private final Object context;

    public ObjectParser(Class<?> type, String[] packages, String[] factoryMethod) {
        this(NO_CONTEXT, type, packages, factoryMethod);
    }

    public ObjectParser(Class<?> type, String[] packages) {
        this(type, packages, DEFAULT_FACTORY_METHODS);
    }

    public ObjectParser(Class<?> type) {
        this(type, (String[])null);
    }

    public ObjectParser() {
        this(Object.class);
    }

    public ObjectParser(Object context, Class<?> type, String[] packages, String[] factoryMethod) {
        this.context = context;
        this.type = type;
        this.packages = packages;
        this.factoryMethod = factoryMethod;
    }

    public ObjectParser(Object context, Class<?> type, String[] packages) {
        this(context, type, packages, DEFAULT_FACTORY_METHODS);
    }

    public ObjectParser(Object context, Class<?> type) {
        this(context, type, null);
    }

    public ObjectParser(Object context) {
        this(context, Object.class);
    }

    public Object parse(String spec) throws ParseException {
        try {
            return ObjectParser.fromSpec(this.context, spec, this.type, this.packages, this.factoryMethod);
        }
        catch (Exception e) {
            throw new ParseException((Throwable)e);
        }
    }

    public static Object fromSpec(String spec) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IOException {
        return ObjectParser.fromSpec(NO_CONTEXT, spec, Object.class, null, DEFAULT_FACTORY_METHODS);
    }

    public static <S> S fromSpec(String spec, Class<S> type) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IOException {
        return ObjectParser.fromSpec(NO_CONTEXT, spec, type, null, DEFAULT_FACTORY_METHODS);
    }

    public static <S> S fromSpec(String spec, Class<S> type, String[] packages) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IOException {
        return ObjectParser.fromSpec(NO_CONTEXT, spec, type, packages, DEFAULT_FACTORY_METHODS);
    }

    public static Object fromSpec(Object context, String spec) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IOException {
        return ObjectParser.fromSpec(context, spec, Object.class, null, DEFAULT_FACTORY_METHODS);
    }

    public static <S> S fromSpec(Object context, String spec, Class<S> type) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IOException {
        return ObjectParser.fromSpec(context, spec, type, null, DEFAULT_FACTORY_METHODS);
    }

    public static <S> S fromSpec(Object context, String spec, Class<S> type, String[] packages) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IOException {
        return ObjectParser.fromSpec(context, spec, type, packages, DEFAULT_FACTORY_METHODS);
    }

    public static <S> S fromSpec(String spec, Class<S> type, String[] packages, String[] factoryMethod) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IOException {
        return ObjectParser.fromSpec(NO_CONTEXT, spec, type, packages, factoryMethod);
    }

    public static <S> S fromSpec(Object context, String spec, Class<S> type, String[] packages, String[] factoryMethod) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IOException {
        int i;
        String[] stringArgArray;
        Class[] argTypes;
        String className;
        Class<?> klass;
        int length;
        int endOfName;
        boolean contextualised;
        block59: {
            spec = spec.trim();
            boolean bl = contextualised = context != NO_CONTEXT;
            if (spec.startsWith("file:")) {
                return (S)BinIO.loadObject((CharSequence)spec.substring(5));
            }
            endOfName = spec.indexOf(40);
            length = spec.length();
            if (endOfName < 0) {
                endOfName = length;
            }
            klass = null;
            className = spec.substring(0, endOfName).trim();
            try {
                klass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                if (packages == null) break block59;
                for (String p : packages) {
                    try {
                        klass = Class.forName(p + "." + className);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (klass != null) break;
                }
            }
        }
        if (klass == null) {
            throw new ClassNotFoundException(className);
        }
        if (!type.isAssignableFrom(klass)) {
            throw new ClassCastException("Class " + klass.getSimpleName() + " is not assignable to " + type);
        }
        ObjectArrayList args = new ObjectArrayList();
        if (contextualised) {
            args.add(context);
        }
        if (endOfName < length) {
            MutableString arg = new MutableString();
            if (spec.charAt(length - 1) != ')') {
                throw new IllegalArgumentException("\")\" missing at the end of argument list");
            }
            int pos = endOfName;
            while (pos < length) {
                ++pos;
                while (pos < length && Character.isWhitespace(spec.charAt(pos))) {
                    ++pos;
                }
                if (pos == length || args.size() == 0 && pos == length - 1 && spec.charAt(pos) == ')') break;
                arg.setLength(0);
                boolean inQuotes = spec.charAt(pos) == '\"';
                if (inQuotes) {
                    ++pos;
                }
                boolean escaped = false;
                while (true) {
                    char c = spec.charAt(pos);
                    if (!inQuotes) {
                        if (c == ',' || pos == length - 1 && c == ')') break;
                        arg.append(c);
                    } else {
                        if (c == '\"' && !escaped) {
                            while (++pos < length && Character.isWhitespace(spec.charAt(pos))) {
                            }
                            if (pos != length && (spec.charAt(pos) == ')' || spec.charAt(pos) == ',')) break;
                            throw new IllegalArgumentException();
                        }
                        if (c == '\\' && !escaped) {
                            escaped = true;
                        } else {
                            arg.append(c);
                            escaped = false;
                        }
                    }
                    ++pos;
                }
                if (inQuotes) {
                    args.add((Object)arg.toString());
                    continue;
                }
                String string = arg.trim().toString();
                if ("null".equals(string)) {
                    args.add(null);
                    continue;
                }
                args.add((Object)string);
            }
        }
        Object[] argArray = args.toArray();
        if (contextualised) {
            argTypes = new Class[args.size()];
            stringArgArray = new String[args.size() - 1];
            argTypes[0] = Object.class;
            for (i = 1; i < argTypes.length; ++i) {
                argTypes[i] = String.class;
                stringArgArray[i - 1] = (String)args.get(i);
            }
        } else {
            argTypes = new Class[args.size()];
            stringArgArray = new String[args.size()];
            for (i = 0; i < argTypes.length; ++i) {
                argTypes[i] = String.class;
                stringArgArray[i] = (String)args.get(i);
            }
        }
        Method method = null;
        Object instance = null;
        if (factoryMethod != null && factoryMethod != DEFAULT_FACTORY_METHODS) {
            for (String f : factoryMethod) {
                try {
                    method = klass.getMethod(f, argTypes);
                    if (Modifier.isStatic(method.getModifiers())) {
                        instance = method.invoke(null, argArray);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (instance != null) {
                    return (S)instance;
                }
                try {
                    if (contextualised) {
                        method = klass.getMethod(f, Object.class, String[].class);
                        if (Modifier.isStatic(method.getModifiers())) {
                            instance = method.invoke(null, context, stringArgArray);
                        }
                    } else {
                        method = klass.getMethod(f, String[].class);
                        if (Modifier.isStatic(method.getModifiers())) {
                            instance = method.invoke(null, new Object[]{stringArgArray});
                        }
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (instance == null) continue;
                return (S)instance;
            }
        }
        try {
            Constructor<?> constructor = klass.getConstructor(argTypes);
            instance = constructor.newInstance(argArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (instance != null) {
            return (S)instance;
        }
        try {
            if (contextualised) {
                Constructor<?> constructor = klass.getConstructor(Object.class, String[].class);
                return (S)constructor.newInstance(context, stringArgArray);
            }
            Constructor<?> constructor = klass.getConstructor(String[].class);
            return (S)constructor.newInstance(new Object[]{stringArgArray});
        }
        catch (NoSuchMethodException e) {
            assert (factoryMethod == null || factoryMethod == DEFAULT_FACTORY_METHODS);
            if (factoryMethod == DEFAULT_FACTORY_METHODS) {
                for (String f : factoryMethod) {
                    try {
                        method = klass.getMethod(f, argTypes);
                        if (Modifier.isStatic(method.getModifiers())) {
                            instance = method.invoke(null, argArray);
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (instance != null) {
                        return (S)instance;
                    }
                    try {
                        if (contextualised) {
                            method = klass.getMethod(f, Object.class, String[].class);
                            if (Modifier.isStatic(method.getModifiers())) {
                                instance = method.invoke(null, context, stringArgArray);
                            }
                        } else {
                            method = klass.getMethod(f, String[].class);
                            if (Modifier.isStatic(method.getModifiers())) {
                                instance = method.invoke(null, new Object[]{stringArgArray});
                            }
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (instance == null) continue;
                    return (S)instance;
                }
            }
            throw new NoSuchMethodException(contextualised ? "No contextual constructor " + (factoryMethod != null ? "or factory method " : "") + "with " + stringArgArray.length + " strings as argument for class " + klass.getName() : "No constructor " + (factoryMethod != null ? "or factory method " : "") + " with " + stringArgArray.length + " strings as argument for class " + klass.getName());
        }
    }

    public static String toSpec(Object o) {
        Method toSpec = null;
        try {
            toSpec = o.getClass().getMethod("toSpec", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (toSpec != null) {
            try {
                return (String)toSpec.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return o.getClass().getName();
    }
}

