/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.compression.PrefixCoder;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;

public class PrefixCoderTransformationStrategy
implements TransformationStrategy<CharSequence> {
    private static final long serialVersionUID = 1L;
    protected final BitVector[] codeWord;
    protected final Char2IntOpenHashMap char2symbol;
    protected final boolean prefixFree;

    public PrefixCoderTransformationStrategy(PrefixCoder coder, Char2IntOpenHashMap char2symbol, boolean prefixFree) {
        this(coder.codeWords(), char2symbol, prefixFree);
    }

    protected PrefixCoderTransformationStrategy(PrefixCoderTransformationStrategy transformationStrategy) {
        this(transformationStrategy.codeWord, transformationStrategy.char2symbol, transformationStrategy.prefixFree);
    }

    protected PrefixCoderTransformationStrategy(BitVector[] codeWord, Char2IntOpenHashMap char2symbol, boolean prefixFree) {
        this.codeWord = codeWord;
        this.char2symbol = char2symbol;
        this.prefixFree = prefixFree;
    }

    public LongArrayBitVector toBitVector(CharSequence s) {
        BitVector[] codeWord = this.codeWord;
        Char2IntOpenHashMap char2symbol = this.char2symbol;
        int length = s.length();
        int numBits = (int)(this.prefixFree ? codeWord[0].length() : 0L);
        int i = length;
        while (i-- != 0) {
            numBits = (int)((long)numBits + codeWord[char2symbol.get(s.charAt(i))].length());
        }
        LongArrayBitVector result = LongArrayBitVector.getInstance(numBits);
        for (int i2 = 0; i2 < s.length(); ++i2) {
            result.append(codeWord[char2symbol.get(s.charAt(i2))]);
        }
        if (this.prefixFree) {
            result.append(codeWord[0]);
        }
        return result;
    }

    @Override
    public long length(CharSequence s) {
        BitVector[] codeWord = this.codeWord;
        Char2IntOpenHashMap char2symbol = this.char2symbol;
        int length = s.length();
        int numBits = (int)(this.prefixFree ? codeWord[0].length() : 0L);
        int i = length;
        while (i-- != 0) {
            numBits = (int)((long)numBits + codeWord[char2symbol.get(s.charAt(i))].length());
        }
        return numBits;
    }

    @Override
    public long numBits() {
        long numBits = 0L;
        int i = this.codeWord.length;
        while (i-- != 0) {
            numBits += this.codeWord[i].length();
        }
        return numBits;
    }

    public PrefixCoderTransformationStrategy copy() {
        return new PrefixCoderTransformationStrategy(this);
    }
}

