/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util.concurrent;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ReorderingBlockingQueue<E> {
    private final Object[] a;
    private final int mask;
    private int start;
    private long timeStamp;
    private int count;
    private final ReentrantLock lock;
    private final Condition nextObjectReady;
    private final Condition newSpaceAvailable;

    public ReorderingBlockingQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.a = new Object[HashCommon.nextPowerOfTwo((int)capacity)];
        this.mask = this.a.length - 1;
        this.lock = new ReentrantLock(false);
        this.nextObjectReady = this.lock.newCondition();
        this.newSpaceAvailable = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(E e, long timeStamp) throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (timeStamp - this.timeStamp > (long)this.mask) {
                this.newSpaceAvailable.await();
            }
            int timeOffset = (int)(timeStamp - this.timeStamp);
            assert (this.a[this.start + timeOffset & this.mask] == null) : this.a[this.start + timeOffset & this.mask];
            this.a[this.start + timeOffset & this.mask] = e;
            ++this.count;
            if (timeOffset == 0) {
                this.nextObjectReady.signal();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.a[this.start] == null) {
                this.nextObjectReady.await();
            }
            Object x = this.a[this.start];
            this.a[this.start] = null;
            this.start = this.start + 1 & this.mask;
            --this.count;
            ++this.timeStamp;
            this.newSpaceAvailable.signalAll();
            Object object = x;
            return (E)object;
        }
        finally {
            lock.unlock();
        }
    }

    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

