/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.Util;
import it.unimi.dsi.util.SplitMix64RandomGenerator;
import org.apache.commons.math3.random.AbstractRandomGenerator;

public class XorShift1024StarRandomGenerator
extends AbstractRandomGenerator {
    private static final double NORM_53 = (double)1.110223E-16f;
    private static final double NORM_24 = 5.960464477539063E-8;
    private final long[] s = new long[16];
    private int p;

    public XorShift1024StarRandomGenerator() {
        this(Util.randomSeed());
    }

    public XorShift1024StarRandomGenerator(long seed) {
        this.setSeed(seed);
    }

    public long nextLong() {
        long s0 = this.s[this.p];
        this.p = this.p + 1 & 0xF;
        long s1 = this.s[this.p];
        s1 ^= s1 << 31;
        this.s[this.p] = s1 ^ s0 ^ s1 >>> 11 ^ s0 >>> 30;
        return this.s[this.p] * 1181783497276652981L;
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    public long nextLong(long n) {
        long value;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException();
        }
        while ((bits = this.nextLong() >>> 1) - (value = bits % n) + (n - 1L) < 0L) {
        }
        return value;
    }

    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    public float nextFloat() {
        return (float)((double)(this.nextLong() >>> 40) * 5.960464477539063E-8);
    }

    public boolean nextBoolean() {
        return this.nextLong() < 0L;
    }

    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        int n = 0;
        while (i != 0) {
            n = Math.min(i, 8);
            long bits = this.nextLong();
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    public void setSeed(long seed) {
        this.p = 0;
        SplitMix64RandomGenerator r = new SplitMix64RandomGenerator(seed);
        int i = this.s.length;
        while (i-- != 0) {
            this.s[i] = r.nextLong();
        }
    }

    public void setState(long[] state, int p) {
        if (state.length != this.s.length) {
            throw new IllegalArgumentException("The argument array contains " + state.length + " longs instead of " + this.s.length);
        }
        System.arraycopy(state, 0, this.s, 0, this.s.length);
        this.p = p;
    }
}

