/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.io;

import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.objects.ObjectBigArrayBigList;
import it.unimi.dsi.fastutil.objects.ObjectBigList;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.SafelyCloseable;
import it.unimi.dsi.lang.MutableString;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;

public class FileLinesCollection
extends AbstractCollection<MutableString>
implements Size64 {
    private final String filename;
    private final String encoding;
    private long size = -1L;
    private final boolean zipped;

    public FileLinesCollection(CharSequence filename, String encoding) {
        this(filename, encoding, false);
    }

    public FileLinesCollection(CharSequence filename, String encoding, boolean zipped) {
        this.zipped = zipped;
        this.filename = filename.toString();
        this.encoding = encoding;
    }

    public FileLinesIterator iterator() {
        return new FileLinesIterator(this.filename, this.encoding, this.zipped);
    }

    @Override
    public synchronized int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.size);
    }

    public synchronized long size64() {
        if (this.size == -1L) {
            FileLinesIterator i = this.iterator();
            this.size = 0L;
            while (i.hasNext()) {
                ++this.size;
                i.next();
            }
            i.close();
        }
        return this.size;
    }

    public ObjectBigList<MutableString> allLines() {
        ObjectBigArrayBigList result = new ObjectBigArrayBigList();
        FileLinesIterator i = this.iterator();
        while (i.hasNext()) {
            result.add((Object)((MutableString)i.next()).copy());
        }
        return result;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Use allLines()");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("Use allLines()");
    }

    @Override
    public String toString() {
        MutableString separator = new MutableString(System.getProperty("line.separator"));
        MutableString s = new MutableString();
        for (MutableString l : this) {
            s.append(l).append(separator);
        }
        return s.toString();
    }

    public static final class FileLinesIterator
    implements Iterator<MutableString>,
    SafelyCloseable {
        private FastBufferedReader fbr;
        MutableString s = new MutableString();
        MutableString next;
        boolean toAdvance = true;

        private FileLinesIterator(String filename, String encoding, boolean zipped) {
            try {
                this.fbr = encoding != null ? new FastBufferedReader(new InputStreamReader(zipped ? new GZIPInputStream(new FileInputStream(filename)) : new FileInputStream(filename), encoding)) : new FastBufferedReader(new FileReader(filename));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.toAdvance) {
                try {
                    this.next = this.fbr.readLine(this.s);
                    if (this.next == null) {
                        this.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.toAdvance = false;
            }
            return this.next != null;
        }

        @Override
        public MutableString next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.s;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void close() {
            if (this.fbr == null) {
                return;
            }
            try {
                this.fbr.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.fbr = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void finalize() throws Throwable {
            try {
                if (this.fbr != null) {
                    this.close();
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

