/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.util;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.LongInterval;
import it.unimi.dsi.util.LongIntervals;
import java.io.Serializable;
import java.util.Iterator;

public class ImmutableBinaryTrie<T>
extends AbstractObject2LongFunction<T>
implements Serializable {
    private static final boolean ASSERTS = false;
    public static final long serialVersionUID = 1L;
    protected final Node root;
    private int size;
    private final TransformationStrategy<? super T> transformationStrategy;

    private static boolean get(long[] a, long i) {
        return (a[(int)(i >>> 6)] & 1L << (int)(i & 0x3FL)) != 0L;
    }

    public ImmutableBinaryTrie(Iterable<? extends T> elements, TransformationStrategy<? super T> transformationStrategy) {
        this.transformationStrategy = transformationStrategy;
        this.defRetValue = -1L;
        Iterator<T> iterator = elements.iterator();
        ObjectArrayList words = new ObjectArrayList();
        if (iterator.hasNext()) {
            LongArrayBitVector prev = LongArrayBitVector.copy(transformationStrategy.toBitVector(iterator.next()));
            words.add((Object)prev.copy());
            while (iterator.hasNext()) {
                BitVector curr = transformationStrategy.toBitVector(iterator.next());
                int cmp = prev.compareTo(curr);
                if (cmp == 0) {
                    throw new IllegalArgumentException("The trie elements are not unique");
                }
                if (cmp > 0) {
                    throw new IllegalArgumentException("The trie elements are not sorted");
                }
                prev.replace(curr);
                words.add((Object)prev.copy());
            }
        }
        this.root = this.buildTrie((ObjectList<LongArrayBitVector>)words, 0);
    }

    protected Node buildTrie(ObjectList<LongArrayBitVector> elements, int pos) {
        Node n;
        BitVector curr;
        if (elements.size() == 0) {
            return null;
        }
        BitVector first = (BitVector)elements.get(0);
        int prefix = first.size();
        int change = -1;
        if (elements.size() == 1) {
            return new Node(pos < prefix ? LongArrayBitVector.copy(first.subVector(pos, prefix)) : null, this.size++);
        }
        ObjectListIterator i = elements.listIterator(1);
        while (i.hasNext()) {
            int j;
            curr = (BitVector)i.next();
            if (curr.size() < prefix) {
                prefix = curr.size();
            }
            for (j = pos; j < prefix && first.get(j) == curr.get(j); ++j) {
            }
            if (j >= prefix) continue;
            change = i.previousIndex();
            prefix = j;
        }
        if (prefix == first.size()) {
            change = 1;
            ObjectListIterator i2 = elements.listIterator(1);
            while (i2.hasNext() && !(curr = (BitVector)i2.next()).getBoolean(prefix)) {
                ++change;
            }
            n = new Node(prefix > pos ? LongArrayBitVector.copy(first.subVector(pos, prefix)) : null, this.size++);
            n.left = this.buildTrie((ObjectList<LongArrayBitVector>)elements.subList(1, change), prefix + 1);
            n.right = this.buildTrie((ObjectList<LongArrayBitVector>)elements.subList(change, elements.size()), prefix + 1);
        } else {
            n = new Node(prefix > pos ? LongArrayBitVector.copy(first.subVector(pos, prefix)) : null);
            n.left = this.buildTrie((ObjectList<LongArrayBitVector>)elements.subList(0, change), prefix + 1);
            n.right = this.buildTrie((ObjectList<LongArrayBitVector>)elements.subList(change, elements.size()), prefix + 1);
        }
        return n;
    }

    public int size() {
        return this.size;
    }

    public long getIndex(Object element) {
        BitVector word = this.transformationStrategy.toBitVector(element);
        int length = word.size();
        Node n = this.root;
        int pos = 0;
        while (n != null) {
            if (pos == length) {
                return n.word;
            }
            long[] path = n.path;
            if (path != null) {
                int i;
                int minLength = Math.min(length - pos, n.pathLength);
                for (i = 0; i < minLength && word.getBoolean(pos + i) == ImmutableBinaryTrie.get(path, i); ++i) {
                }
                if (i < minLength) {
                    return -1L;
                }
                if ((pos += i) == length) {
                    return n.word;
                }
            }
            n = word.getBoolean(pos++) ? n.right : n.left;
        }
        return -1L;
    }

    public long getLong(Object element) {
        long result = this.getIndex(element);
        return result == -1L ? this.defRetValue : result;
    }

    public boolean containsKey(Object element) {
        return this.getIndex(element) != -1L;
    }

    public long get(BooleanIterator iterator) {
        Node n = this.root;
        while (n != null) {
            if (!iterator.hasNext()) {
                return n.word;
            }
            int pathLength = n.pathLength;
            if (pathLength != 0) {
                int i;
                long[] path = n.path;
                for (i = 0; i < pathLength && iterator.hasNext() && iterator.nextBoolean() == ImmutableBinaryTrie.get(path, i); ++i) {
                }
                if (i < pathLength) {
                    return -1L;
                }
                if (!iterator.hasNext()) {
                    return n.word;
                }
            }
            n = iterator.nextBoolean() ? n.right : n.left;
        }
        return -1L;
    }

    public LongInterval getInterval(BitVector word) {
        int length = word.size();
        Node n = this.root;
        int pos = 0;
        while (n != null && pos != length) {
            long[] path = n.path;
            if (path != null) {
                int i;
                int maxLength = Math.min(length - pos, n.pathLength);
                for (i = 0; i < maxLength && word.getBoolean(pos + i) == ImmutableBinaryTrie.get(path, i); ++i) {
                }
                if (i < maxLength) {
                    return LongIntervals.EMPTY_INTERVAL;
                }
                if ((pos += i) == length) break;
            }
            n = word.getBoolean(pos++) ? n.right : n.left;
        }
        if (n == null) {
            return LongIntervals.EMPTY_INTERVAL;
        }
        Node l = n;
        while (l.word < 0L) {
            l = l.left != null ? l.left : l.right;
        }
        while (!n.isLeaf()) {
            n = n.right != null ? n.right : n.left;
        }
        return LongInterval.valueOf(l.word, n.word);
    }

    public LongInterval getInterval(BooleanIterator iterator) {
        Node n = this.root;
        boolean mismatch = false;
        while (n != null && iterator.hasNext()) {
            int pathLength = n.pathLength;
            if (pathLength != 0) {
                long[] path = n.path;
                for (int i = 0; i < pathLength && iterator.hasNext() && !(mismatch = iterator.nextBoolean() != ImmutableBinaryTrie.get(path, i)); ++i) {
                }
                if (mismatch) {
                    return LongIntervals.EMPTY_INTERVAL;
                }
                if (!iterator.hasNext()) break;
            }
            n = iterator.nextBoolean() ? n.right : n.left;
        }
        if (n == null) {
            return LongIntervals.EMPTY_INTERVAL;
        }
        Node l = n;
        while (l.word < 0L) {
            l = l.left != null ? l.left : l.right;
        }
        while (!n.isLeaf()) {
            n = n.right != null ? n.right : n.left;
        }
        return LongInterval.valueOf(l.word, n.word);
    }

    public LongInterval getApproximatedInterval(T element) {
        BitVector word = this.transformationStrategy.toBitVector(element);
        int length = word.size();
        Node n = this.root;
        boolean exactMatch = false;
        boolean mismatch = false;
        int pos = 0;
        while (n != null) {
            boolean nextBit;
            long[] path = n.path;
            if (pos == length) {
                if (n.word < 0L || path != null) break;
                exactMatch = true;
                break;
            }
            if (path != null) {
                int i;
                int maxLength = Math.min(length - pos, n.pathLength);
                for (i = 0; i < maxLength && !(mismatch = word.getBoolean(pos + i) != ImmutableBinaryTrie.get(path, i)); ++i) {
                }
                if (mismatch) {
                    if (ImmutableBinaryTrie.get(path, i)) {
                        while (n.word < 0L) {
                            n = n.left != null ? n.left : n.right;
                        }
                        return n.word > 0L ? LongInterval.valueOf(n.word - 1L) : LongIntervals.EMPTY_INTERVAL;
                    }
                    while (!n.isLeaf()) {
                        n = n.right != null ? n.right : n.left;
                    }
                    return LongInterval.valueOf(n.word);
                }
                if ((pos += i) == length) {
                    if (i != n.pathLength || n.word < 0L) break;
                    exactMatch = true;
                    break;
                }
            }
            if (n.isLeaf()) break;
            if ((nextBit = word.getBoolean(pos++)) && n.right == null) {
                while (!n.isLeaf()) {
                    n = n.right != null ? n.right : n.left;
                }
                return LongInterval.valueOf(n.word);
            }
            if (!nextBit && n.left == null) {
                while (n.word < 0L) {
                    n = n.left != null ? n.left : n.right;
                }
                return LongInterval.valueOf(n.word);
            }
            n = nextBit ? n.right : n.left;
        }
        Node l = n;
        while (l.word < 0L) {
            l = l.left != null ? l.left : l.right;
        }
        while (!n.isLeaf()) {
            n = n.right != null ? n.right : n.left;
        }
        if (pos == length && !exactMatch) {
            if (l.word == 0L) {
                return mismatch ? LongIntervals.EMPTY_INTERVAL : LongInterval.valueOf(l.word, n.word);
            }
            return LongInterval.valueOf(l.word - 1L, n.word);
        }
        return LongInterval.valueOf(l.word, n.word);
    }

    public LongInterval getApproximatedInterval(BooleanIterator iterator) {
        Node n = this.root;
        boolean exactMatch = false;
        boolean mismatch = false;
        while (true) {
            long[] path = n.path;
            if (!iterator.hasNext()) {
                if (n.word < 0L || path != null) break;
                exactMatch = true;
                break;
            }
            if (path != null) {
                int i;
                int pathSize = n.pathLength;
                for (i = 0; i < pathSize && iterator.hasNext() && !(mismatch = iterator.nextBoolean() != ImmutableBinaryTrie.get(path, i)); ++i) {
                }
                if (mismatch) {
                    if (ImmutableBinaryTrie.get(path, i)) {
                        while (n.word < 0L) {
                            n = n.left != null ? n.left : n.right;
                        }
                        return n.word > 0L ? LongInterval.valueOf(n.word - 1L) : LongIntervals.EMPTY_INTERVAL;
                    }
                    while (!n.isLeaf()) {
                        n = n.right != null ? n.right : n.left;
                    }
                    return LongInterval.valueOf(n.word);
                }
                if (!iterator.hasNext()) {
                    if (i != pathSize || n.word < 0L) break;
                    exactMatch = true;
                    break;
                }
            }
            if (n.isLeaf()) break;
            boolean nextBit = iterator.nextBoolean();
            if (nextBit && n.right == null) {
                while (!n.isLeaf()) {
                    n = n.right != null ? n.right : n.left;
                }
                return LongInterval.valueOf(n.word);
            }
            if (!nextBit && n.left == null) {
                while (n.word < 0L) {
                    n = n.left != null ? n.left : n.right;
                }
                return LongInterval.valueOf(n.word);
            }
            n = nextBit ? n.right : n.left;
        }
        Node l = n;
        while (l.word < 0L) {
            l = l.left != null ? l.left : l.right;
        }
        while (!n.isLeaf()) {
            n = n.right != null ? n.right : n.left;
        }
        if (!iterator.hasNext() && !exactMatch) {
            if (l.word == 0L) {
                return mismatch ? LongIntervals.EMPTY_INTERVAL : LongInterval.valueOf(0L);
            }
            return LongInterval.valueOf(l.word - 1L, n.word);
        }
        return LongInterval.valueOf(l.word, n.word);
    }

    private void recToString(Node n, MutableString printPrefix, MutableString result, MutableString path, int level) {
        if (n == null) {
            return;
        }
        result.append(printPrefix).append('(').append(level).append(')');
        if (n.path != null) {
            path.append(LongArrayBitVector.wrap(n.path, n.pathLength));
            result.append(" path:").append(LongArrayBitVector.wrap(n.path, n.pathLength));
        }
        if (n.word >= 0L) {
            result.append(" word: ").append(n.word).append(" (").append(path).append(')');
        }
        result.append('\n');
        path.append('0');
        this.recToString(n.left, printPrefix.append('\t').append("0 => "), result, path, level + 1);
        path.charAt(path.length() - 1, '1');
        this.recToString(n.right, printPrefix.replace(printPrefix.length() - 5, printPrefix.length(), "1 => "), result, path, level + 1);
        path.delete(path.length() - 1, path.length());
        printPrefix.delete(printPrefix.length() - 6, printPrefix.length());
        path.delete(path.length() - n.pathLength, path.length());
    }

    public String toString() {
        MutableString s = new MutableString();
        this.recToString(this.root, new MutableString(), s, new MutableString(), 0);
        return s.toString();
    }

    protected static class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Node left;
        public Node right;
        public final long[] path;
        public final int pathLength;
        public final long word;

        public Node(BitVector path, int word) {
            if (path == null) {
                this.path = null;
                this.pathLength = 0;
            } else {
                this.path = path.bits();
                this.pathLength = path.size();
            }
            this.word = word;
        }

        public Node(BitVector path) {
            this(path, -1);
        }

        public boolean isLeaf() {
            return this.right == null && this.left == null;
        }

        public String toString() {
            return "[" + LongArrayBitVector.wrap(this.path, this.pathLength) + ", " + this.word + "]";
        }
    }
}

