/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public final class Util {
    private static final NumberFormat FORMAT_DOUBLE = new DecimalFormat("#,##0.00");
    private static final NumberFormat FORMAT_LONG = new DecimalFormat("#,###");
    private static final FieldPosition UNUSED_FIELD_POSITION = new FieldPosition(0);
    public static final Runtime RUNTIME = Runtime.getRuntime();
    private static final AtomicLong seedUniquifier = new AtomicLong();

    private Util() {
    }

    public static synchronized String format(double d) {
        return FORMAT_DOUBLE.format(d, new StringBuffer(), UNUSED_FIELD_POSITION).toString();
    }

    public static synchronized String format(long l) {
        return FORMAT_LONG.format(l, new StringBuffer(), UNUSED_FIELD_POSITION).toString();
    }

    public static String format(double d, NumberFormat format) {
        StringBuffer s = new StringBuffer();
        return format.format(d, s, UNUSED_FIELD_POSITION).toString();
    }

    public static String format(long l, NumberFormat format) {
        StringBuffer s = new StringBuffer();
        return format.format(l, s, UNUSED_FIELD_POSITION).toString();
    }

    public static String formatSize(long l) {
        if (l >= 1000000000000L) {
            return Util.format((double)l / 1.0E12) + "T";
        }
        if (l >= 1000000000L) {
            return Util.format((double)l / 1.0E9) + "G";
        }
        if (l >= 1000000L) {
            return Util.format((double)l / 1000000.0) + "M";
        }
        if (l >= 1000L) {
            return Util.format((double)l / 1000.0) + "K";
        }
        return Long.toString(l);
    }

    public static String formatBinarySize(long l) {
        if ((l & -l) != l) {
            throw new IllegalArgumentException("Not a power of 2: " + l);
        }
        if (l >= 0x10000000000L) {
            return Util.format(l >> 40) + "Ti";
        }
        if (l >= 0x40000000L) {
            return Util.format(l >> 30) + "Gi";
        }
        if (l >= 0x100000L) {
            return Util.format(l >> 20) + "Mi";
        }
        if (l >= 1024L) {
            return Util.format(l >> 10) + "Ki";
        }
        return Long.toString(l);
    }

    public static String formatSize2(long l) {
        if (l >= 0x10000000000L) {
            return Util.format((double)l / 1.099511627776E12) + "Ti";
        }
        if (l >= 0x40000000L) {
            return Util.format((double)l / 1.073741824E9) + "Gi";
        }
        if (l >= 0x100000L) {
            return Util.format((double)l / 1048576.0) + "Mi";
        }
        if (l >= 1024L) {
            return Util.format((double)l / 1024.0) + "Ki";
        }
        return Long.toString(l);
    }

    public static String formatSize(long l, NumberFormat format) {
        if (l >= 1000000000000L) {
            return Util.format((double)l / 1.0E12) + "T";
        }
        if (l >= 1000000000L) {
            return Util.format((double)l / 1.0E9) + "G";
        }
        if (l >= 1000000L) {
            return Util.format((double)l / 1000000.0) + "M";
        }
        if (l >= 1000L) {
            return Util.format((double)l / 1000.0) + "K";
        }
        return Long.toString(l);
    }

    public static String formatBinarySize(long l, NumberFormat format) {
        if ((l & -l) != l) {
            throw new IllegalArgumentException("Not a power of 2: " + l);
        }
        if (l >= 0x10000000000L) {
            return Util.format(l >> 40) + "Ti";
        }
        if (l >= 0x40000000L) {
            return Util.format(l >> 30) + "Gi";
        }
        if (l >= 0x100000L) {
            return Util.format(l >> 20) + "Mi";
        }
        if (l >= 1024L) {
            return Util.format(l >> 10) + "Ki";
        }
        return Long.toString(l);
    }

    public static String formatSize2(long l, NumberFormat format) {
        if (l >= 0x10000000000L) {
            return Util.format((double)l / 1.099511627776E12) + "Ti";
        }
        if (l >= 0x40000000L) {
            return Util.format((double)l / 1.073741824E9) + "Gi";
        }
        if (l >= 0x100000L) {
            return Util.format((double)l / 1048576.0) + "Mi";
        }
        if (l >= 1024L) {
            return Util.format((double)l / 1024.0) + "Ki";
        }
        return Long.toString(l);
    }

    @Deprecated
    public static boolean log4JIsConfigured() {
        if (Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            return true;
        }
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (!logger.getAllAppenders().hasMoreElements()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static void ensureLog4JIsConfigured(Class<?> klass) {
        Util.ensureLog4JIsConfigured(klass, Level.INFO);
    }

    @Deprecated
    public static void ensureLog4JIsConfigured(Class<?> klass, Level level) {
        try {
            Class.forName("org.apache.log4j.ConsoleAppender", false, null);
        }
        catch (ClassNotFoundException e) {
            System.err.println("WARNING: " + (klass != null ? klass.getSimpleName() + " is" : "We are") + " trying to autoconfigure Log4J, but org.apache.log4j.ConsoleAppender is not available (most likely you are using a bridging package that mimics Log4J).");
            return;
        }
        if (!Util.log4JIsConfigured()) {
            System.err.println("WARNING: " + (klass != null ? klass.getSimpleName() + " is" : "We are") + " autoconfiguring Log4J (level: " + level + "). You should configure Log4J properly instead.");
            BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"), "System.err"));
            LogManager.getRootLogger().setLevel(level);
        }
    }

    @Deprecated
    public static void ensureLog4JIsConfigured() {
        Util.ensureLog4JIsConfigured(null, Level.INFO);
    }

    @Deprecated
    public static void ensureLog4JIsConfigured(Level level) {
        Util.ensureLog4JIsConfigured(null, level);
    }

    @Deprecated
    public static Logger getLogger(Class<?> klass) {
        Logger logger = Logger.getLogger(klass);
        Util.ensureLog4JIsConfigured(klass);
        return logger;
    }

    @Deprecated
    public static Logger getDebugLogger(Class<?> klass) {
        Logger logger = Logger.getLogger(klass);
        Util.ensureLog4JIsConfigured(klass, Level.DEBUG);
        return logger;
    }

    public static boolean memoryIsLow() {
        return Util.availableMemory() * 100L < RUNTIME.totalMemory() * 5L;
    }

    public static long availableMemory() {
        return RUNTIME.freeMemory() + (RUNTIME.maxMemory() - RUNTIME.totalMemory());
    }

    public static int percAvailableMemory() {
        return (int)(Util.availableMemory() * 100L / Runtime.getRuntime().maxMemory());
    }

    public static void compactMemory() {
        try {
            byte[][] unused = new byte[128][];
            int i = unused.length;
            while (i-- != 0) {
                unused[i] = new byte[2000000000];
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        System.gc();
    }

    public static long randomSeed() {
        long seed = seedUniquifier.incrementAndGet();
        seed ^= seed >>> 33;
        seed *= -49064778989728563L;
        seed ^= seed >>> 33;
        seed *= -4265267296055464877L;
        seed ^= seed >>> 33;
        seed += System.nanoTime();
        seed ^= seed >>> 33;
        seed *= -49064778989728563L;
        seed ^= seed >>> 33;
        seed *= -4265267296055464877L;
        seed ^= seed >>> 33;
        return seed;
    }

    public static byte[] randomSeedBytes() {
        long seed = Util.randomSeed();
        byte[] s = new byte[8];
        int i = 8;
        while (i-- != 0) {
            s[i] = (byte)(seed >>> i);
        }
        return s;
    }

    public static int[] invertPermutationInPlace(int[] perm) {
        int n = perm.length;
        block0: while (n-- != 0) {
            int i = perm[n];
            if (i < 0) {
                perm[n] = -i - 1;
                continue;
            }
            if (i == n) continue;
            int k = n;
            while (true) {
                int j = perm[i];
                perm[i] = -k - 1;
                if (j == n) {
                    perm[n] = i;
                    continue block0;
                }
                k = i;
                i = j;
            }
        }
        return perm;
    }

    public static int[] invertPermutation(int[] perm, int[] inv) {
        int i = perm.length;
        while (i-- != 0) {
            inv[perm[i]] = i;
        }
        return inv;
    }

    public static int[] invertPermutation(int[] perm) {
        return Util.invertPermutation(perm, new int[perm.length]);
    }

    public static int[] identity(int[] perm) {
        int i = perm.length;
        while (i-- != 0) {
            perm[i] = i;
        }
        return perm;
    }

    public static int[] identity(int n) {
        return Util.identity(new int[n]);
    }

    public static long[][] invertPermutationInPlace(long[][] perm) {
        long n = LongBigArrays.length((long[][])perm);
        block0: while (n-- != 0L) {
            long i = LongBigArrays.get((long[][])perm, (long)n);
            if (i < 0L) {
                LongBigArrays.set((long[][])perm, (long)n, (long)(-i - 1L));
                continue;
            }
            if (i == n) continue;
            long k = n;
            while (true) {
                long j = LongBigArrays.get((long[][])perm, (long)i);
                LongBigArrays.set((long[][])perm, (long)i, (long)(-k - 1L));
                if (j == n) {
                    LongBigArrays.set((long[][])perm, (long)n, (long)i);
                    continue block0;
                }
                k = i;
                i = j;
            }
        }
        return perm;
    }

    public static long[][] invertPermutation(long[][] perm, long[][] inv) {
        int i = perm.length;
        while (i-- != 0) {
            long[] t = perm[i];
            int d = t.length;
            while (d-- != 0) {
                LongBigArrays.set((long[][])inv, (long)t[d], (long)BigArrays.index((int)i, (int)d));
            }
        }
        return inv;
    }

    public static long[][] invertPermutation(long[][] perm) {
        return Util.invertPermutation(perm, LongBigArrays.newBigArray((long)LongBigArrays.length((long[][])perm)));
    }

    public static long[][] identity(long[][] perm) {
        int i = perm.length;
        while (i-- != 0) {
            long[] t = perm[i];
            int d = t.length;
            while (d-- != 0) {
                t[d] = BigArrays.index((int)i, (int)d);
            }
        }
        return perm;
    }

    public static long[][] identity(long n) {
        return Util.identity(LongBigArrays.newBigArray((long)n));
    }
}

