/*
 * Decompiled with CFR 0.152.
 */
package it.svario.xpathapi.jaxp;

import it.svario.xpathapi.jaxp.NodeListIterator;
import it.svario.xpathapi.jaxp.NodeNamespaceContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XPathAPI {
    public static Node selectSingleNode(Node contextNode, String xpathString, String ... args) throws XPathException {
        return XPathAPI.selectSingleNode(contextNode, xpathString, contextNode, args);
    }

    public static Node selectSingleNode(Node contextNode, String xpathString, Map<String, String> namespaces, String ... args) throws XPathException {
        NodeList nodes = XPathAPI.selectNodeList(contextNode, xpathString, namespaces, args);
        return XPathAPI.selectFirstNode(nodes);
    }

    public static Node selectSingleNode(Node contextNode, String xpathString, Node namespaceNode, String ... args) throws XPathException {
        NodeList nodes = XPathAPI.selectNodeList(contextNode, xpathString, namespaceNode, args);
        return XPathAPI.selectFirstNode(nodes);
    }

    private static Node selectFirstNode(NodeList nodes) {
        if (nodes.getLength() == 0) {
            return null;
        }
        return nodes.item(0);
    }

    public static String selectSingleNodeAsString(Node contextNode, String xpathString, String ... args) throws XPathException {
        return XPathAPI.selectSingleNodeAsString(contextNode, xpathString, contextNode, args);
    }

    public static String selectSingleNodeAsString(Node contextNode, String xpathString, Map<String, String> namespaces, String ... args) throws XPathException {
        Node node = XPathAPI.selectSingleNode(contextNode, xpathString, namespaces, args);
        return XPathAPI.selectNodeAsString(node);
    }

    public static String selectSingleNodeAsString(Node contextNode, String xpathString, Node namespaceNode, String ... args) throws XPathException {
        Node node = XPathAPI.selectSingleNode(contextNode, xpathString, namespaceNode, args);
        return XPathAPI.selectNodeAsString(node);
    }

    private static String selectNodeAsString(Node node) {
        if (node == null) {
            return null;
        }
        return node.getTextContent();
    }

    public static NodeList selectNodeList(Node contextNode, String xpathString, String ... args) throws XPathException {
        return XPathAPI.selectNodeList(contextNode, xpathString, contextNode, args);
    }

    public static NodeList selectNodeList(Node contextNode, String xpathString, Node namespaceNode, String ... args) throws XPathException {
        NodeNamespaceContext nsContext = new NodeNamespaceContext(namespaceNode);
        return XPathAPI.selectNodeList(contextNode, xpathString, nsContext, args);
    }

    public static NodeList selectNodeList(Node contextNode, String xpathString, Map<String, String> namespaces, String ... args) throws XPathException {
        NodeNamespaceContext nsContext = new NodeNamespaceContext(contextNode, namespaces);
        return XPathAPI.selectNodeList(contextNode, xpathString, nsContext, args);
    }

    private static NodeList selectNodeList(Node contextNode, String xpathString, NamespaceContext nsContext, String ... args) throws XPathException {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        xpath.setNamespaceContext(nsContext);
        xpathString = XPathAPI.replacePlaceholders(xpathString, args);
        XPathExpression xpathExpr = xpath.compile(xpathString);
        NodeList nodes = (NodeList)xpathExpr.evaluate(contextNode, XPathConstants.NODESET);
        return nodes;
    }

    public static List<Node> selectListOfNodes(Node contextNode, String xpathString, String ... args) throws XPathException {
        return XPathAPI.selectListOfNodes(contextNode, xpathString, contextNode, args);
    }

    public static List<Node> selectListOfNodes(Node contextNode, String xpathString, Node namespaceNode, String ... args) throws XPathException {
        NodeNamespaceContext nsContext = new NodeNamespaceContext(namespaceNode);
        return XPathAPI.selectListOfNodes(contextNode, xpathString, nsContext, args);
    }

    public static List<Node> selectListOfNodes(Node contextNode, String xpathString, Map<String, String> namespaces, String ... args) throws XPathException {
        NodeNamespaceContext nsContext = new NodeNamespaceContext(contextNode, namespaces);
        return XPathAPI.selectListOfNodes(contextNode, xpathString, nsContext, args);
    }

    private static List<Node> selectListOfNodes(Node contextNode, String xpathString, NamespaceContext nsContext, String ... args) throws XPathException {
        xpathString = XPathAPI.replacePlaceholders(xpathString, args);
        NodeList nodeList = XPathAPI.selectNodeList(contextNode, xpathString, nsContext, new String[0]);
        int listLength = nodeList.getLength();
        ArrayList<Node> list = new ArrayList<Node>(listLength);
        for (int i = 0; i < listLength; ++i) {
            Node node = nodeList.item(i);
            list.add(node);
        }
        return list;
    }

    public static List<String> selectNodeListAsStrings(Node contextNode, String xpathString, String ... args) throws XPathException {
        return XPathAPI.selectNodeListAsStrings(contextNode, xpathString, contextNode, args);
    }

    public static List<String> selectNodeListAsStrings(Node contextNode, String xpathString, Map<String, String> namespaces, String ... args) throws XPathException {
        NodeList nodeList = XPathAPI.selectNodeList(contextNode, xpathString, namespaces, args);
        return XPathAPI.nodeListAsStringList(nodeList);
    }

    public static List<String> selectNodeListAsStrings(Node contextNode, String xpathString, Node namespaceNode, String ... args) throws XPathException {
        NodeList nodeList = XPathAPI.selectNodeList(contextNode, xpathString, namespaceNode, args);
        return XPathAPI.nodeListAsStringList(nodeList);
    }

    private static List<String> nodeListAsStringList(NodeList nodeList) {
        ArrayList<String> list = new ArrayList<String>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            list.add(node.getTextContent());
        }
        return list;
    }

    public static NodeIterator selectNodeIterator(Node contextNode, String xpathString, String ... args) throws XPathException {
        return XPathAPI.selectNodeIterator(contextNode, xpathString, contextNode, args);
    }

    public static NodeIterator selectNodeIterator(Node contextNode, String xpathString, Node namespaceNode, String ... args) throws XPathException {
        NodeList nodes = XPathAPI.selectNodeList(contextNode, xpathString, namespaceNode, args);
        return new NodeListIterator(nodes);
    }

    private static String replacePlaceholders(String string, String ... args) {
        for (String arg : args) {
            string = string.replace("{}", arg);
        }
        return string;
    }
}

