/*
 * Decompiled with CFR 0.152.
 */
package it.svario.xpathapi.jaxp;

import it.svario.xpathapi.jaxp.NodeListIterator;
import it.svario.xpathapi.jaxp.NodeNamespaceContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XPathAPI {
    public static Node selectSingleNode(Node contextNode, String xpathString) throws XPathException {
        return XPathAPI.selectSingleNode(contextNode, xpathString, contextNode);
    }

    public static Node selectSingleNode(Node contextNode, String xpathString, Map<String, String> namespaces) throws XPathException {
        NodeList nodes = XPathAPI.selectNodeList(contextNode, xpathString, namespaces);
        return XPathAPI.selectFirstNode(nodes);
    }

    public static Node selectSingleNode(Node contextNode, String xpathString, Node namespaceNode) throws XPathException {
        NodeList nodes = XPathAPI.selectNodeList(contextNode, xpathString, namespaceNode);
        return XPathAPI.selectFirstNode(nodes);
    }

    private static Node selectFirstNode(NodeList nodes) {
        if (nodes.getLength() == 0) {
            return null;
        }
        return nodes.item(0);
    }

    public static String selectSingleNodeAsString(Node contextNode, String xpathString) throws XPathException {
        return XPathAPI.selectSingleNodeAsString(contextNode, xpathString, contextNode);
    }

    public static String selectSingleNodeAsString(Node contextNode, String xpathString, Map<String, String> namespaces) throws XPathException {
        Node node = XPathAPI.selectSingleNode(contextNode, xpathString, namespaces);
        return XPathAPI.selectNodeAsString(node);
    }

    public static String selectSingleNodeAsString(Node contextNode, String xpathString, Node namespaceNode) throws XPathException {
        Node node = XPathAPI.selectSingleNode(contextNode, xpathString, namespaceNode);
        return XPathAPI.selectNodeAsString(node);
    }

    private static String selectNodeAsString(Node node) {
        if (node == null) {
            return null;
        }
        return node.getTextContent();
    }

    public static NodeList selectNodeList(Node contextNode, String xpathString) throws XPathException {
        return XPathAPI.selectNodeList(contextNode, xpathString, contextNode);
    }

    public static NodeList selectNodeList(Node contextNode, String xpathString, Node namespaceNode) throws XPathException {
        NodeNamespaceContext nsContext = new NodeNamespaceContext(namespaceNode);
        return XPathAPI.selectNodeList(contextNode, xpathString, nsContext);
    }

    public static NodeList selectNodeList(Node contextNode, String xpathString, Map<String, String> namespaces) throws XPathException {
        NodeNamespaceContext nsContext = new NodeNamespaceContext(contextNode, namespaces);
        return XPathAPI.selectNodeList(contextNode, xpathString, nsContext);
    }

    private static NodeList selectNodeList(Node contextNode, String xpathString, NamespaceContext nsContext) throws XPathException {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        xpath.setNamespaceContext(nsContext);
        XPathExpression xpathExpr = xpath.compile(xpathString);
        NodeList nodes = (NodeList)xpathExpr.evaluate(contextNode, XPathConstants.NODESET);
        return nodes;
    }

    public static List<String> selectNodeListAsStrings(Node contextNode, String xpathString) throws XPathException {
        return XPathAPI.selectNodeListAsStrings(contextNode, xpathString, contextNode);
    }

    public static List<String> selectNodeListAsStrings(Node contextNode, String xpathString, Map<String, String> namespaces) throws XPathException {
        NodeList nodeList = XPathAPI.selectNodeList(contextNode, xpathString, namespaces);
        return XPathAPI.nodeListAsStringList(nodeList);
    }

    public static List<String> selectNodeListAsStrings(Node contextNode, String xpathString, Node namespaceNode) throws XPathException {
        NodeList nodeList = XPathAPI.selectNodeList(contextNode, xpathString, namespaceNode);
        return XPathAPI.nodeListAsStringList(nodeList);
    }

    private static List<String> nodeListAsStringList(NodeList nodeList) {
        ArrayList<String> list = new ArrayList<String>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            list.add(node.getTextContent());
        }
        return list;
    }

    public static NodeIterator selectNodeIterator(Node contextNode, String xpathString) throws XPathException {
        return XPathAPI.selectNodeIterator(contextNode, xpathString, contextNode);
    }

    public static NodeIterator selectNodeIterator(Node contextNode, String xpathString, Node namespaceNode) throws XPathException {
        NodeList nodes = XPathAPI.selectNodeList(contextNode, xpathString, namespaceNode);
        return new NodeListIterator(nodes);
    }
}

